# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawEntitiesClient, RawEntitiesClient
from .types.delete_entities_response import DeleteEntitiesResponse
from .types.entity_create_request_entity_type import EntityCreateRequestEntityType
from .types.entity_create_request_status import EntityCreateRequestStatus
from .types.entity_update_request_entity_type import EntityUpdateRequestEntityType
from .types.entity_update_request_status import EntityUpdateRequestStatus
from .types.get_entities_response import GetEntitiesResponse
from .types.post_entities_response import PostEntitiesResponse
from .types.put_entities_response import PutEntitiesResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EntitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEntitiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEntitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEntitiesClient
        """
        return self._raw_client

    def get_entity_details(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEntitiesResponse:
        """
        Get details for a specific entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEntitiesResponse
            entity details

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.entities.get_entity_details(entity_id='entityId', )
        """
        _response = self._raw_client.get_entity_details(entity_id=entity_id, request_options=request_options)
        return _response.data

    def create_entity(
        self,
        *,
        legal_name: str,
        external_id: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityCreateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityCreateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostEntitiesResponse:
        """
        Create a new entity

        Parameters
        ----------
        legal_name : str

        external_id : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityCreateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityCreateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostEntitiesResponse
            entity created

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.entities.create_entity(legal_name='legalName', )
        """
        _response = self._raw_client.create_entity(
            legal_name=legal_name,
            external_id=external_id,
            tin=tin,
            us_state=us_state,
            entity_type=entity_type,
            phone_number=phone_number,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def update_entity(
        self,
        *,
        entity_id: str,
        legal_name: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityUpdateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityUpdateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PutEntitiesResponse:
        """
        Update an existing entity

        Parameters
        ----------
        entity_id : str
            entity ID

        legal_name : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityUpdateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityUpdateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PutEntitiesResponse
            entity updated

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.entities.update_entity(entity_id='entityId', )
        """
        _response = self._raw_client.update_entity(
            entity_id=entity_id,
            legal_name=legal_name,
            tin=tin,
            us_state=us_state,
            entity_type=entity_type,
            phone_number=phone_number,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def delete_entity(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteEntitiesResponse:
        """
        Delete an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteEntitiesResponse
            entity deleted

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.entities.delete_entity(entity_id='entityId', )
        """
        _response = self._raw_client.delete_entity(entity_id=entity_id, request_options=request_options)
        return _response.data


class AsyncEntitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEntitiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEntitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEntitiesClient
        """
        return self._raw_client

    async def get_entity_details(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetEntitiesResponse:
        """
        Get details for a specific entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetEntitiesResponse
            entity details

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get_entity_details(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_entity_details(entity_id=entity_id, request_options=request_options)
        return _response.data

    async def create_entity(
        self,
        *,
        legal_name: str,
        external_id: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityCreateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityCreateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostEntitiesResponse:
        """
        Create a new entity

        Parameters
        ----------
        legal_name : str

        external_id : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityCreateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityCreateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostEntitiesResponse
            entity created

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.create_entity(legal_name='legalName', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_entity(
            legal_name=legal_name,
            external_id=external_id,
            tin=tin,
            us_state=us_state,
            entity_type=entity_type,
            phone_number=phone_number,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def update_entity(
        self,
        *,
        entity_id: str,
        legal_name: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityUpdateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityUpdateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PutEntitiesResponse:
        """
        Update an existing entity

        Parameters
        ----------
        entity_id : str
            entity ID

        legal_name : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityUpdateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityUpdateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PutEntitiesResponse
            entity updated

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.update_entity(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_entity(
            entity_id=entity_id,
            legal_name=legal_name,
            tin=tin,
            us_state=us_state,
            entity_type=entity_type,
            phone_number=phone_number,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def delete_entity(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteEntitiesResponse:
        """
        Delete an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteEntitiesResponse
            entity deleted

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.delete_entity(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_entity(entity_id=entity_id, request_options=request_options)
        return _response.data
