# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from .types.delete_entities_response import DeleteEntitiesResponse
from .types.entity_create_request_entity_type import EntityCreateRequestEntityType
from .types.entity_create_request_status import EntityCreateRequestStatus
from .types.entity_update_request_entity_type import EntityUpdateRequestEntityType
from .types.entity_update_request_status import EntityUpdateRequestStatus
from .types.get_entities_response import GetEntitiesResponse
from .types.post_entities_response import PostEntitiesResponse
from .types.put_entities_response import PutEntitiesResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawEntitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_entity_details(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetEntitiesResponse]:
        """
        Get details for a specific entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetEntitiesResponse]
            entity details
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities",
            method="GET",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEntitiesResponse,
                    parse_obj_as(
                        type_=GetEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def create_entity(
        self,
        *,
        legal_name: str,
        external_id: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityCreateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityCreateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostEntitiesResponse]:
        """
        Create a new entity

        Parameters
        ----------
        legal_name : str

        external_id : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityCreateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityCreateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostEntitiesResponse]
            entity created
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities",
            method="POST",
            json={
                "externalId": external_id,
                "legalName": legal_name,
                "tin": tin,
                "usState": us_state,
                "entityType": entity_type,
                "phoneNumber": phone_number,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostEntitiesResponse,
                    parse_obj_as(
                        type_=PostEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def update_entity(
        self,
        *,
        entity_id: str,
        legal_name: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityUpdateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityUpdateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PutEntitiesResponse]:
        """
        Update an existing entity

        Parameters
        ----------
        entity_id : str
            entity ID

        legal_name : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityUpdateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityUpdateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PutEntitiesResponse]
            entity updated
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities",
            method="PUT",
            params={
                "entityId": entity_id,
            },
            json={
                "legalName": legal_name,
                "tin": tin,
                "usState": us_state,
                "entityType": entity_type,
                "phoneNumber": phone_number,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PutEntitiesResponse,
                    parse_obj_as(
                        type_=PutEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def delete_entity(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeleteEntitiesResponse]:
        """
        Delete an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeleteEntitiesResponse]
            entity deleted
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities",
            method="DELETE",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteEntitiesResponse,
                    parse_obj_as(
                        type_=DeleteEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawEntitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_entity_details(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetEntitiesResponse]:
        """
        Get details for a specific entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetEntitiesResponse]
            entity details
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities",
            method="GET",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetEntitiesResponse,
                    parse_obj_as(
                        type_=GetEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def create_entity(
        self,
        *,
        legal_name: str,
        external_id: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityCreateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityCreateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostEntitiesResponse]:
        """
        Create a new entity

        Parameters
        ----------
        legal_name : str

        external_id : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityCreateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityCreateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostEntitiesResponse]
            entity created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities",
            method="POST",
            json={
                "externalId": external_id,
                "legalName": legal_name,
                "tin": tin,
                "usState": us_state,
                "entityType": entity_type,
                "phoneNumber": phone_number,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostEntitiesResponse,
                    parse_obj_as(
                        type_=PostEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def update_entity(
        self,
        *,
        entity_id: str,
        legal_name: typing.Optional[str] = OMIT,
        tin: typing.Optional[str] = OMIT,
        us_state: typing.Optional[str] = OMIT,
        entity_type: typing.Optional[EntityUpdateRequestEntityType] = OMIT,
        phone_number: typing.Optional[str] = OMIT,
        status: typing.Optional[EntityUpdateRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PutEntitiesResponse]:
        """
        Update an existing entity

        Parameters
        ----------
        entity_id : str
            entity ID

        legal_name : typing.Optional[str]

        tin : typing.Optional[str]

        us_state : typing.Optional[str]

        entity_type : typing.Optional[EntityUpdateRequestEntityType]

        phone_number : typing.Optional[str]

        status : typing.Optional[EntityUpdateRequestStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PutEntitiesResponse]
            entity updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities",
            method="PUT",
            params={
                "entityId": entity_id,
            },
            json={
                "legalName": legal_name,
                "tin": tin,
                "usState": us_state,
                "entityType": entity_type,
                "phoneNumber": phone_number,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PutEntitiesResponse,
                    parse_obj_as(
                        type_=PutEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def delete_entity(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeleteEntitiesResponse]:
        """
        Delete an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeleteEntitiesResponse]
            entity deleted
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities",
            method="DELETE",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteEntitiesResponse,
                    parse_obj_as(
                        type_=DeleteEntitiesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
