# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.integration_status_response import IntegrationStatusResponse
from .raw_client import AsyncRawIntegrationsClient, RawIntegrationsClient
from .types.post_integrations_connect_response import PostIntegrationsConnectResponse
from .types.post_integrations_disconnect_response import PostIntegrationsDisconnectResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class IntegrationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIntegrationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIntegrationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIntegrationsClient
        """
        return self._raw_client

    def get_integration_status(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> IntegrationStatusResponse:
        """
        Get status of all integrations for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IntegrationStatusResponse
            Integration status

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.integrations.get_integration_status(entity_id='entityId', )
        """
        _response = self._raw_client.get_integration_status(entity_id=entity_id, request_options=request_options)
        return _response.data

    def connect_integration(
        self,
        *,
        entity_id: str,
        provider: str,
        authorization: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostIntegrationsConnectResponse:
        """
        Connect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        provider : str

        authorization : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostIntegrationsConnectResponse
            Integration connected

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.integrations.connect_integration(entity_id='entityId', provider='provider', authorization={'key': 'value'
        }, )
        """
        _response = self._raw_client.connect_integration(
            entity_id=entity_id, provider=provider, authorization=authorization, request_options=request_options
        )
        return _response.data

    def disconnect_integration(
        self, *, entity_id: str, integration_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PostIntegrationsDisconnectResponse:
        """
        Disconnect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        integration_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostIntegrationsDisconnectResponse
            Integration disconnected

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.integrations.disconnect_integration(entity_id='entityId', integration_id='integrationId', )
        """
        _response = self._raw_client.disconnect_integration(
            entity_id=entity_id, integration_id=integration_id, request_options=request_options
        )
        return _response.data


class AsyncIntegrationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIntegrationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIntegrationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIntegrationsClient
        """
        return self._raw_client

    async def get_integration_status(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> IntegrationStatusResponse:
        """
        Get status of all integrations for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IntegrationStatusResponse
            Integration status

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.integrations.get_integration_status(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_integration_status(entity_id=entity_id, request_options=request_options)
        return _response.data

    async def connect_integration(
        self,
        *,
        entity_id: str,
        provider: str,
        authorization: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostIntegrationsConnectResponse:
        """
        Connect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        provider : str

        authorization : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostIntegrationsConnectResponse
            Integration connected

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.integrations.connect_integration(entity_id='entityId', provider='provider', authorization={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.connect_integration(
            entity_id=entity_id, provider=provider, authorization=authorization, request_options=request_options
        )
        return _response.data

    async def disconnect_integration(
        self, *, entity_id: str, integration_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PostIntegrationsDisconnectResponse:
        """
        Disconnect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        integration_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostIntegrationsDisconnectResponse
            Integration disconnected

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.integrations.disconnect_integration(entity_id='entityId', integration_id='integrationId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.disconnect_integration(
            entity_id=entity_id, integration_id=integration_id, request_options=request_options
        )
        return _response.data
