# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..types.integration_status_response import IntegrationStatusResponse
from .types.post_integrations_connect_response import PostIntegrationsConnectResponse
from .types.post_integrations_disconnect_response import PostIntegrationsDisconnectResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawIntegrationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_integration_status(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[IntegrationStatusResponse]:
        """
        Get status of all integrations for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IntegrationStatusResponse]
            Integration status
        """
        _response = self._client_wrapper.httpx_client.request(
            "integrations/status",
            method="GET",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IntegrationStatusResponse,
                    parse_obj_as(
                        type_=IntegrationStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def connect_integration(
        self,
        *,
        entity_id: str,
        provider: str,
        authorization: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostIntegrationsConnectResponse]:
        """
        Connect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        provider : str

        authorization : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostIntegrationsConnectResponse]
            Integration connected
        """
        _response = self._client_wrapper.httpx_client.request(
            "integrations/connect",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "provider": provider,
                "authorization": authorization,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostIntegrationsConnectResponse,
                    parse_obj_as(
                        type_=PostIntegrationsConnectResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def disconnect_integration(
        self, *, entity_id: str, integration_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PostIntegrationsDisconnectResponse]:
        """
        Disconnect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        integration_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostIntegrationsDisconnectResponse]
            Integration disconnected
        """
        _response = self._client_wrapper.httpx_client.request(
            "integrations/disconnect",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "integrationId": integration_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostIntegrationsDisconnectResponse,
                    parse_obj_as(
                        type_=PostIntegrationsDisconnectResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawIntegrationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_integration_status(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IntegrationStatusResponse]:
        """
        Get status of all integrations for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IntegrationStatusResponse]
            Integration status
        """
        _response = await self._client_wrapper.httpx_client.request(
            "integrations/status",
            method="GET",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IntegrationStatusResponse,
                    parse_obj_as(
                        type_=IntegrationStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def connect_integration(
        self,
        *,
        entity_id: str,
        provider: str,
        authorization: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostIntegrationsConnectResponse]:
        """
        Connect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        provider : str

        authorization : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostIntegrationsConnectResponse]
            Integration connected
        """
        _response = await self._client_wrapper.httpx_client.request(
            "integrations/connect",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "provider": provider,
                "authorization": authorization,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostIntegrationsConnectResponse,
                    parse_obj_as(
                        type_=PostIntegrationsConnectResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def disconnect_integration(
        self, *, entity_id: str, integration_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PostIntegrationsDisconnectResponse]:
        """
        Disconnect a third-party integration

        Parameters
        ----------
        entity_id : str
            entity ID

        integration_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostIntegrationsDisconnectResponse]
            Integration disconnected
        """
        _response = await self._client_wrapper.httpx_client.request(
            "integrations/disconnect",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "integrationId": integration_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostIntegrationsDisconnectResponse,
                    parse_obj_as(
                        type_=PostIntegrationsDisconnectResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
