# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.financial_report import FinancialReport
from ..types.general_ledger import GeneralLedger
from .raw_client import AsyncRawReportsClient, RawReportsClient
from .types.get_reports_financial_request_type import GetReportsFinancialRequestType


class ReportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawReportsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawReportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawReportsClient
        """
        return self._raw_client

    def get_financial_reports(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        type: typing.Optional[GetReportsFinancialRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FinancialReport:
        """
        Get financial statements including balance sheet, income statement, and cash flow

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        type : typing.Optional[GetReportsFinancialRequestType]
            Report type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FinancialReport
            Financial reports

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.reports.get_financial_reports(entity_id='entityId', )
        """
        _response = self._raw_client.get_financial_reports(
            entity_id=entity_id, month=month, year=year, type=type, request_options=request_options
        )
        return _response.data

    def generate_general_ledger(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GeneralLedger:
        """
        Generate a general ledger report for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralLedger
            General ledger report

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.reports.generate_general_ledger(entity_id='entityId', )
        """
        _response = self._raw_client.generate_general_ledger(
            entity_id=entity_id, month=month, year=year, request_options=request_options
        )
        return _response.data


class AsyncReportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawReportsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawReportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawReportsClient
        """
        return self._raw_client

    async def get_financial_reports(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        type: typing.Optional[GetReportsFinancialRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FinancialReport:
        """
        Get financial statements including balance sheet, income statement, and cash flow

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        type : typing.Optional[GetReportsFinancialRequestType]
            Report type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FinancialReport
            Financial reports

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.reports.get_financial_reports(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_financial_reports(
            entity_id=entity_id, month=month, year=year, type=type, request_options=request_options
        )
        return _response.data

    async def generate_general_ledger(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GeneralLedger:
        """
        Generate a general ledger report for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralLedger
            General ledger report

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.reports.generate_general_ledger(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.generate_general_ledger(
            entity_id=entity_id, month=month, year=year, request_options=request_options
        )
        return _response.data
