# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..types.financial_report import FinancialReport
from ..types.general_ledger import GeneralLedger
from .types.get_reports_financial_request_type import GetReportsFinancialRequestType


class RawReportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_financial_reports(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        type: typing.Optional[GetReportsFinancialRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[FinancialReport]:
        """
        Get financial statements including balance sheet, income statement, and cash flow

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        type : typing.Optional[GetReportsFinancialRequestType]
            Report type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FinancialReport]
            Financial reports
        """
        _response = self._client_wrapper.httpx_client.request(
            "reports/financial",
            method="GET",
            params={
                "entityId": entity_id,
                "month": month,
                "year": year,
                "type": type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancialReport,
                    parse_obj_as(
                        type_=FinancialReport,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def generate_general_ledger(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GeneralLedger]:
        """
        Generate a general ledger report for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GeneralLedger]
            General ledger report
        """
        _response = self._client_wrapper.httpx_client.request(
            "reports/general-ledger",
            method="GET",
            params={
                "entityId": entity_id,
                "month": month,
                "year": year,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GeneralLedger,
                    parse_obj_as(
                        type_=GeneralLedger,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawReportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_financial_reports(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        type: typing.Optional[GetReportsFinancialRequestType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[FinancialReport]:
        """
        Get financial statements including balance sheet, income statement, and cash flow

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        type : typing.Optional[GetReportsFinancialRequestType]
            Report type

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FinancialReport]
            Financial reports
        """
        _response = await self._client_wrapper.httpx_client.request(
            "reports/financial",
            method="GET",
            params={
                "entityId": entity_id,
                "month": month,
                "year": year,
                "type": type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancialReport,
                    parse_obj_as(
                        type_=FinancialReport,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def generate_general_ledger(
        self,
        *,
        entity_id: str,
        month: typing.Optional[str] = None,
        year: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GeneralLedger]:
        """
        Generate a general ledger report for an entity

        Parameters
        ----------
        entity_id : str
            entity ID

        month : typing.Optional[str]
            Month (1-12)

        year : typing.Optional[str]
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GeneralLedger]
            General ledger report
        """
        _response = await self._client_wrapper.httpx_client.request(
            "reports/general-ledger",
            method="GET",
            params={
                "entityId": entity_id,
                "month": month,
                "year": year,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GeneralLedger,
                    parse_obj_as(
                        type_=GeneralLedger,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
