# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.sandbox_response import SandboxResponse
from .raw_client import AsyncRawSandboxClient, RawSandboxClient
from .types.sandbox_request_preferences import SandboxRequestPreferences

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SandboxClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSandboxClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSandboxClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSandboxClient
        """
        return self._raw_client

    def create_sandbox_environment(
        self,
        *,
        name: str,
        developer_id: str,
        industry: typing.Optional[str] = OMIT,
        preferences: typing.Optional[SandboxRequestPreferences] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SandboxResponse:
        """
        Creates a complete sandbox environment for development and testing, including a developer account, workspace, instance, entity, ledger structure, and Plaid sandbox bank connections.

        Parameters
        ----------
        name : str

        developer_id : str

        industry : typing.Optional[str]

        preferences : typing.Optional[SandboxRequestPreferences]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SandboxResponse
            Sandbox environment created successfully

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.sandbox.create_sandbox_environment(name='name', developer_id='developer_id', )
        """
        _response = self._raw_client.create_sandbox_environment(
            name=name,
            developer_id=developer_id,
            industry=industry,
            preferences=preferences,
            request_options=request_options,
        )
        return _response.data


class AsyncSandboxClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSandboxClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSandboxClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSandboxClient
        """
        return self._raw_client

    async def create_sandbox_environment(
        self,
        *,
        name: str,
        developer_id: str,
        industry: typing.Optional[str] = OMIT,
        preferences: typing.Optional[SandboxRequestPreferences] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SandboxResponse:
        """
        Creates a complete sandbox environment for development and testing, including a developer account, workspace, instance, entity, ledger structure, and Plaid sandbox bank connections.

        Parameters
        ----------
        name : str

        developer_id : str

        industry : typing.Optional[str]

        preferences : typing.Optional[SandboxRequestPreferences]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SandboxResponse
            Sandbox environment created successfully

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.sandbox.create_sandbox_environment(name='name', developer_id='developer_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_sandbox_environment(
            name=name,
            developer_id=developer_id,
            industry=industry,
            preferences=preferences,
            request_options=request_options,
        )
        return _response.data
