# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.transaction import Transaction
from .raw_client import AsyncRawTransactionsClient, RawTransactionsClient
from .types.delete_transactions_response import DeleteTransactionsResponse
from .types.get_transactions_chat_response import GetTransactionsChatResponse
from .types.post_transactions_categorize_response import PostTransactionsCategorizeResponse
from .types.post_transactions_response import PostTransactionsResponse
from .types.post_transactions_search_response import PostTransactionsSearchResponse
from .types.put_transactions_response import PutTransactionsResponse
from .types.transaction_request_status import TransactionRequestStatus
from .types.transaction_search_request_filters import TransactionSearchRequestFilters

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TransactionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTransactionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTransactionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTransactionsClient
        """
        return self._raw_client

    def get_transactions_by_company(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Transaction]:
        """
        Get all transactions for a company with optional filters

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Transaction]
            List of transactions

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.get_transactions_by_company(entity_id='entityId', )
        """
        _response = self._raw_client.get_transactions_by_company(entity_id=entity_id, request_options=request_options)
        return _response.data

    def create_transaction(
        self,
        *,
        entity_id: str,
        amount: float,
        description: str,
        debit_account_id: str,
        credit_account_id: str,
        date: typing.Optional[dt.datetime] = OMIT,
        currency: typing.Optional[str] = OMIT,
        status: typing.Optional[TransactionRequestStatus] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostTransactionsResponse:
        """
        Create a new transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        amount : float

        description : str

        debit_account_id : str

        credit_account_id : str

        date : typing.Optional[dt.datetime]

        currency : typing.Optional[str]

        status : typing.Optional[TransactionRequestStatus]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostTransactionsResponse
            Transaction created

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.create_transaction(entity_id='entityId', amount=1.1, description='description', debit_account_id='debitAccountId', credit_account_id='creditAccountId', )
        """
        _response = self._raw_client.create_transaction(
            entity_id=entity_id,
            amount=amount,
            description=description,
            debit_account_id=debit_account_id,
            credit_account_id=credit_account_id,
            date=date,
            currency=currency,
            status=status,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def approve_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PutTransactionsResponse:
        """
        Approve a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PutTransactionsResponse
            Transaction approved

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.approve_transaction(entity_id='entityId', transaction_id='transactionId', )
        """
        _response = self._raw_client.approve_transaction(
            entity_id=entity_id, transaction_id=transaction_id, request_options=request_options
        )
        return _response.data

    def delete_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteTransactionsResponse:
        """
        Delete a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str
            Transaction ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTransactionsResponse
            Transaction deleted

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.delete_transaction(entity_id='entityId', transaction_id='transactionId', )
        """
        _response = self._raw_client.delete_transaction(
            entity_id=entity_id, transaction_id=transaction_id, request_options=request_options
        )
        return _response.data

    def get_transactions_by_month(
        self, *, entity_id: str, month: str, year: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Get transactions for a specified month

        Parameters
        ----------
        entity_id : str
            entity ID

        month : str
            Month (1-12)

        year : str
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.get_transactions_by_month(entity_id='entityId', month='month', year='year', )
        """
        _response = self._raw_client.get_transactions_by_month(
            entity_id=entity_id, month=month, year=year, request_options=request_options
        )
        return _response.data

    def categorize_transaction(
        self,
        *,
        entity_id: str,
        transaction_id: str,
        category_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostTransactionsCategorizeResponse:
        """
        Assign a category to a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        category_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostTransactionsCategorizeResponse
            Transaction categorized

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.categorize_transaction(entity_id='entityId', transaction_id='transactionId', category_id='categoryId', )
        """
        _response = self._raw_client.categorize_transaction(
            entity_id=entity_id, transaction_id=transaction_id, category_id=category_id, request_options=request_options
        )
        return _response.data

    def search_transactions(
        self,
        *,
        entity_id: str,
        query: typing.Optional[str] = OMIT,
        filters: typing.Optional[TransactionSearchRequestFilters] = OMIT,
        page: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostTransactionsSearchResponse:
        """
        Search for transactions with various filters

        Parameters
        ----------
        entity_id : str
            entity ID

        query : typing.Optional[str]

        filters : typing.Optional[TransactionSearchRequestFilters]

        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostTransactionsSearchResponse
            Search results

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.search_transactions(entity_id='entityId', )
        """
        _response = self._raw_client.search_transactions(
            entity_id=entity_id, query=query, filters=filters, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    def chat_with_transactions(
        self, *, entity_id: str, prompt: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTransactionsChatResponse:
        """
        Natural language interaction with transactions

        Parameters
        ----------
        entity_id : str
            entity ID

        prompt : str
            Natural language prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTransactionsChatResponse
            AI response

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.transactions.chat_with_transactions(entity_id='entityId', prompt='prompt', )
        """
        _response = self._raw_client.chat_with_transactions(
            entity_id=entity_id, prompt=prompt, request_options=request_options
        )
        return _response.data


class AsyncTransactionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTransactionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTransactionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTransactionsClient
        """
        return self._raw_client

    async def get_transactions_by_company(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Transaction]:
        """
        Get all transactions for a company with optional filters

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Transaction]
            List of transactions

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.get_transactions_by_company(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_transactions_by_company(
            entity_id=entity_id, request_options=request_options
        )
        return _response.data

    async def create_transaction(
        self,
        *,
        entity_id: str,
        amount: float,
        description: str,
        debit_account_id: str,
        credit_account_id: str,
        date: typing.Optional[dt.datetime] = OMIT,
        currency: typing.Optional[str] = OMIT,
        status: typing.Optional[TransactionRequestStatus] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostTransactionsResponse:
        """
        Create a new transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        amount : float

        description : str

        debit_account_id : str

        credit_account_id : str

        date : typing.Optional[dt.datetime]

        currency : typing.Optional[str]

        status : typing.Optional[TransactionRequestStatus]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostTransactionsResponse
            Transaction created

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.create_transaction(entity_id='entityId', amount=1.1, description='description', debit_account_id='debitAccountId', credit_account_id='creditAccountId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_transaction(
            entity_id=entity_id,
            amount=amount,
            description=description,
            debit_account_id=debit_account_id,
            credit_account_id=credit_account_id,
            date=date,
            currency=currency,
            status=status,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def approve_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PutTransactionsResponse:
        """
        Approve a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PutTransactionsResponse
            Transaction approved

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.approve_transaction(entity_id='entityId', transaction_id='transactionId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.approve_transaction(
            entity_id=entity_id, transaction_id=transaction_id, request_options=request_options
        )
        return _response.data

    async def delete_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteTransactionsResponse:
        """
        Delete a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str
            Transaction ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTransactionsResponse
            Transaction deleted

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.delete_transaction(entity_id='entityId', transaction_id='transactionId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_transaction(
            entity_id=entity_id, transaction_id=transaction_id, request_options=request_options
        )
        return _response.data

    async def get_transactions_by_month(
        self, *, entity_id: str, month: str, year: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Get transactions for a specified month

        Parameters
        ----------
        entity_id : str
            entity ID

        month : str
            Month (1-12)

        year : str
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.get_transactions_by_month(entity_id='entityId', month='month', year='year', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_transactions_by_month(
            entity_id=entity_id, month=month, year=year, request_options=request_options
        )
        return _response.data

    async def categorize_transaction(
        self,
        *,
        entity_id: str,
        transaction_id: str,
        category_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostTransactionsCategorizeResponse:
        """
        Assign a category to a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        category_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostTransactionsCategorizeResponse
            Transaction categorized

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.categorize_transaction(entity_id='entityId', transaction_id='transactionId', category_id='categoryId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.categorize_transaction(
            entity_id=entity_id, transaction_id=transaction_id, category_id=category_id, request_options=request_options
        )
        return _response.data

    async def search_transactions(
        self,
        *,
        entity_id: str,
        query: typing.Optional[str] = OMIT,
        filters: typing.Optional[TransactionSearchRequestFilters] = OMIT,
        page: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostTransactionsSearchResponse:
        """
        Search for transactions with various filters

        Parameters
        ----------
        entity_id : str
            entity ID

        query : typing.Optional[str]

        filters : typing.Optional[TransactionSearchRequestFilters]

        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostTransactionsSearchResponse
            Search results

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.search_transactions(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.search_transactions(
            entity_id=entity_id, query=query, filters=filters, page=page, limit=limit, request_options=request_options
        )
        return _response.data

    async def chat_with_transactions(
        self, *, entity_id: str, prompt: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTransactionsChatResponse:
        """
        Natural language interaction with transactions

        Parameters
        ----------
        entity_id : str
            entity ID

        prompt : str
            Natural language prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTransactionsChatResponse
            AI response

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.transactions.chat_with_transactions(entity_id='entityId', prompt='prompt', )
        asyncio.run(main())
        """
        _response = await self._raw_client.chat_with_transactions(
            entity_id=entity_id, prompt=prompt, request_options=request_options
        )
        return _response.data
