# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..types.transaction import Transaction
from .types.delete_transactions_response import DeleteTransactionsResponse
from .types.get_transactions_chat_response import GetTransactionsChatResponse
from .types.post_transactions_categorize_response import PostTransactionsCategorizeResponse
from .types.post_transactions_response import PostTransactionsResponse
from .types.post_transactions_search_response import PostTransactionsSearchResponse
from .types.put_transactions_response import PutTransactionsResponse
from .types.transaction_request_status import TransactionRequestStatus
from .types.transaction_search_request_filters import TransactionSearchRequestFilters

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTransactionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_transactions_by_company(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[Transaction]]:
        """
        Get all transactions for a company with optional filters

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Transaction]]
            List of transactions
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions",
            method="GET",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Transaction],
                    parse_obj_as(
                        type_=typing.List[Transaction],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def create_transaction(
        self,
        *,
        entity_id: str,
        amount: float,
        description: str,
        debit_account_id: str,
        credit_account_id: str,
        date: typing.Optional[dt.datetime] = OMIT,
        currency: typing.Optional[str] = OMIT,
        status: typing.Optional[TransactionRequestStatus] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostTransactionsResponse]:
        """
        Create a new transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        amount : float

        description : str

        debit_account_id : str

        credit_account_id : str

        date : typing.Optional[dt.datetime]

        currency : typing.Optional[str]

        status : typing.Optional[TransactionRequestStatus]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostTransactionsResponse]
            Transaction created
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "date": date,
                "amount": amount,
                "currency": currency,
                "description": description,
                "debitAccountId": debit_account_id,
                "creditAccountId": credit_account_id,
                "status": status,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostTransactionsResponse,
                    parse_obj_as(
                        type_=PostTransactionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def approve_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PutTransactionsResponse]:
        """
        Approve a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PutTransactionsResponse]
            Transaction approved
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions",
            method="PUT",
            params={
                "entityId": entity_id,
            },
            json={
                "transactionId": transaction_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PutTransactionsResponse,
                    parse_obj_as(
                        type_=PutTransactionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def delete_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeleteTransactionsResponse]:
        """
        Delete a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str
            Transaction ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeleteTransactionsResponse]
            Transaction deleted
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions",
            method="DELETE",
            params={
                "entityId": entity_id,
                "transactionId": transaction_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteTransactionsResponse,
                    parse_obj_as(
                        type_=DeleteTransactionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def get_transactions_by_month(
        self, *, entity_id: str, month: str, year: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Get transactions for a specified month

        Parameters
        ----------
        entity_id : str
            entity ID

        month : str
            Month (1-12)

        year : str
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions/by-month",
            method="GET",
            params={
                "entityId": entity_id,
                "month": month,
                "year": year,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def categorize_transaction(
        self,
        *,
        entity_id: str,
        transaction_id: str,
        category_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostTransactionsCategorizeResponse]:
        """
        Assign a category to a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        category_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostTransactionsCategorizeResponse]
            Transaction categorized
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions/categorize",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "transactionId": transaction_id,
                "categoryId": category_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostTransactionsCategorizeResponse,
                    parse_obj_as(
                        type_=PostTransactionsCategorizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def search_transactions(
        self,
        *,
        entity_id: str,
        query: typing.Optional[str] = OMIT,
        filters: typing.Optional[TransactionSearchRequestFilters] = OMIT,
        page: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostTransactionsSearchResponse]:
        """
        Search for transactions with various filters

        Parameters
        ----------
        entity_id : str
            entity ID

        query : typing.Optional[str]

        filters : typing.Optional[TransactionSearchRequestFilters]

        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostTransactionsSearchResponse]
            Search results
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions/search",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "query": query,
                "filters": convert_and_respect_annotation_metadata(
                    object_=filters, annotation=TransactionSearchRequestFilters, direction="write"
                ),
                "page": page,
                "limit": limit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostTransactionsSearchResponse,
                    parse_obj_as(
                        type_=PostTransactionsSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    def chat_with_transactions(
        self, *, entity_id: str, prompt: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetTransactionsChatResponse]:
        """
        Natural language interaction with transactions

        Parameters
        ----------
        entity_id : str
            entity ID

        prompt : str
            Natural language prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetTransactionsChatResponse]
            AI response
        """
        _response = self._client_wrapper.httpx_client.request(
            "transactions/chat",
            method="GET",
            params={
                "entityId": entity_id,
                "prompt": prompt,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTransactionsChatResponse,
                    parse_obj_as(
                        type_=GetTransactionsChatResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawTransactionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_transactions_by_company(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[Transaction]]:
        """
        Get all transactions for a company with optional filters

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Transaction]]
            List of transactions
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions",
            method="GET",
            params={
                "entityId": entity_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Transaction],
                    parse_obj_as(
                        type_=typing.List[Transaction],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def create_transaction(
        self,
        *,
        entity_id: str,
        amount: float,
        description: str,
        debit_account_id: str,
        credit_account_id: str,
        date: typing.Optional[dt.datetime] = OMIT,
        currency: typing.Optional[str] = OMIT,
        status: typing.Optional[TransactionRequestStatus] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostTransactionsResponse]:
        """
        Create a new transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        amount : float

        description : str

        debit_account_id : str

        credit_account_id : str

        date : typing.Optional[dt.datetime]

        currency : typing.Optional[str]

        status : typing.Optional[TransactionRequestStatus]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostTransactionsResponse]
            Transaction created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "date": date,
                "amount": amount,
                "currency": currency,
                "description": description,
                "debitAccountId": debit_account_id,
                "creditAccountId": credit_account_id,
                "status": status,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostTransactionsResponse,
                    parse_obj_as(
                        type_=PostTransactionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def approve_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PutTransactionsResponse]:
        """
        Approve a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PutTransactionsResponse]
            Transaction approved
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions",
            method="PUT",
            params={
                "entityId": entity_id,
            },
            json={
                "transactionId": transaction_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PutTransactionsResponse,
                    parse_obj_as(
                        type_=PutTransactionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def delete_transaction(
        self, *, entity_id: str, transaction_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeleteTransactionsResponse]:
        """
        Delete a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str
            Transaction ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeleteTransactionsResponse]
            Transaction deleted
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions",
            method="DELETE",
            params={
                "entityId": entity_id,
                "transactionId": transaction_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeleteTransactionsResponse,
                    parse_obj_as(
                        type_=DeleteTransactionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def get_transactions_by_month(
        self, *, entity_id: str, month: str, year: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Get transactions for a specified month

        Parameters
        ----------
        entity_id : str
            entity ID

        month : str
            Month (1-12)

        year : str
            Year (YYYY)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions/by-month",
            method="GET",
            params={
                "entityId": entity_id,
                "month": month,
                "year": year,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def categorize_transaction(
        self,
        *,
        entity_id: str,
        transaction_id: str,
        category_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostTransactionsCategorizeResponse]:
        """
        Assign a category to a transaction

        Parameters
        ----------
        entity_id : str
            entity ID

        transaction_id : str

        category_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostTransactionsCategorizeResponse]
            Transaction categorized
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions/categorize",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "transactionId": transaction_id,
                "categoryId": category_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostTransactionsCategorizeResponse,
                    parse_obj_as(
                        type_=PostTransactionsCategorizeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def search_transactions(
        self,
        *,
        entity_id: str,
        query: typing.Optional[str] = OMIT,
        filters: typing.Optional[TransactionSearchRequestFilters] = OMIT,
        page: typing.Optional[int] = OMIT,
        limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostTransactionsSearchResponse]:
        """
        Search for transactions with various filters

        Parameters
        ----------
        entity_id : str
            entity ID

        query : typing.Optional[str]

        filters : typing.Optional[TransactionSearchRequestFilters]

        page : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostTransactionsSearchResponse]
            Search results
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions/search",
            method="POST",
            params={
                "entityId": entity_id,
            },
            json={
                "query": query,
                "filters": convert_and_respect_annotation_metadata(
                    object_=filters, annotation=TransactionSearchRequestFilters, direction="write"
                ),
                "page": page,
                "limit": limit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostTransactionsSearchResponse,
                    parse_obj_as(
                        type_=PostTransactionsSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)

    async def chat_with_transactions(
        self, *, entity_id: str, prompt: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetTransactionsChatResponse]:
        """
        Natural language interaction with transactions

        Parameters
        ----------
        entity_id : str
            entity ID

        prompt : str
            Natural language prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetTransactionsChatResponse]
            AI response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "transactions/chat",
            method="GET",
            params={
                "entityId": entity_id,
                "prompt": prompt,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetTransactionsChatResponse,
                    parse_obj_as(
                        type_=GetTransactionsChatResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
