# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .financial_report_pdf_urls import FinancialReportPdfUrls


class FinancialReport(UniversalBaseModel):
    balance_sheet: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="balanceSheet")
    ] = pydantic.Field(default=None)
    """
    Balance sheet data structure
    """

    income_statement: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="incomeStatement")
    ] = pydantic.Field(default=None)
    """
    Income statement data structure
    """

    cash_flow_statement: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="cashFlowStatement")
    ] = pydantic.Field(default=None)
    """
    Cash flow statement data structure
    """

    pdf_urls: typing.Optional[FinancialReportPdfUrls] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
