# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .transaction_status import TransactionStatus


class Transaction(UniversalBaseModel):
    id: typing.Optional[str] = None
    entity_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="entityId")] = None
    timestamp: typing.Optional[dt.datetime] = None
    amount: typing.Optional[float] = None
    currency: typing.Optional[str] = None
    description: typing.Optional[str] = None
    debit_account_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="debitAccountId")] = None
    credit_account_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="creditAccountId")] = None
    status: typing.Optional[TransactionStatus] = None
    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
