"""
OpenMeteo Python - Open-Meteo API Client

A comprehensive Python library for accessing all Open-Meteo weather APIs.
Supports Weather Forecast, Historical Weather, Air Quality, Marine, Flood,
Climate, Ensemble, Geocoding, and Elevation APIs.

This is a community package, not affiliated with the official openmeteo-sdk.

Example usage:
    >>> from openmeteo import OpenMeteo
    >>> client = OpenMeteo()
    >>> forecast = client.forecast.get(latitude=52.52, longitude=13.41)
    >>> print(forecast.hourly.temperature_2m)

For better performance with large datasets, use FlatBuffers format:
    >>> from openmeteo import OpenMeteo, APIConfig
    >>> config = APIConfig(format="flatbuffers")
    >>> client = OpenMeteo(config=config)
    >>> forecast = client.forecast.get(latitude=52.52, longitude=13.41)
    >>> df = forecast.to_dataframe()  # Zero-copy DataFrame conversion
"""

from openmeteo.client import OpenMeteo
from openmeteo.base import APIConfig, is_flatbuffers_available
from openmeteo.clients.forecast import ForecastClient
from openmeteo.clients.historical import HistoricalClient
from openmeteo.clients.air_quality import AirQualityClient
from openmeteo.clients.marine import MarineClient
from openmeteo.clients.flood import FloodClient
from openmeteo.clients.climate import ClimateClient
from openmeteo.clients.ensemble import EnsembleClient
from openmeteo.clients.geocoding import GeocodingClient
from openmeteo.clients.elevation import ElevationClient
from openmeteo.models import WeatherResponse, Location

__version__ = "1.0.0"
__author__ = "OpenMeteo Python Contributors"
__all__ = [
    "OpenMeteo",
    "APIConfig",
    "is_flatbuffers_available",
    "ForecastClient",
    "HistoricalClient",
    "AirQualityClient",
    "MarineClient",
    "FloodClient",
    "ClimateClient",
    "EnsembleClient",
    "GeocodingClient",
    "ElevationClient",
    "WeatherResponse",
    "Location",
]
