from rewrite import ExecutionContext, Recipe, TreeVisitor
from rewrite.python import PythonVisitor
from rewrite.python.tree import Space, TextComment


class PythonTestRecipe(Recipe):
    """
    A recipe to test recipe authorship and running
    """

    def get_visitor(self) -> TreeVisitor:
        class Visitor(PythonVisitor):
            def visit_space(self, space: Space, loc: Space.Location, p: ExecutionContext) -> Space:
                for comment in space.comments:
                    if not comment.multiline:
                        tc = TextComment(comment)
                        return tc.with_text(" " + comment.text.strip())
                return space

        return Visitor()
