# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'unversioned.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1SecurityContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, capabilities=None, privileged=None, read_only_root_filesystem=None, run_as_non_root=None, run_as_user=None, se_linux_options=None):
        """
        V1SecurityContext - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'capabilities': 'V1Capabilities',
            'privileged': 'bool',
            'read_only_root_filesystem': 'bool',
            'run_as_non_root': 'bool',
            'run_as_user': 'int',
            'se_linux_options': 'V1SELinuxOptions'
        }

        self.attribute_map = {
            'capabilities': 'capabilities',
            'privileged': 'privileged',
            'read_only_root_filesystem': 'readOnlyRootFilesystem',
            'run_as_non_root': 'runAsNonRoot',
            'run_as_user': 'runAsUser',
            'se_linux_options': 'seLinuxOptions'
        }

        self._capabilities = capabilities
        self._privileged = privileged
        self._read_only_root_filesystem = read_only_root_filesystem
        self._run_as_non_root = run_as_non_root
        self._run_as_user = run_as_user
        self._se_linux_options = se_linux_options

    @property
    def capabilities(self):
        """
        Gets the capabilities of this V1SecurityContext.
        The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.

        :return: The capabilities of this V1SecurityContext.
        :rtype: V1Capabilities
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this V1SecurityContext.
        The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.

        :param capabilities: The capabilities of this V1SecurityContext.
        :type: V1Capabilities
        """

        self._capabilities = capabilities

    @property
    def privileged(self):
        """
        Gets the privileged of this V1SecurityContext.
        Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.

        :return: The privileged of this V1SecurityContext.
        :rtype: bool
        """
        return self._privileged

    @privileged.setter
    def privileged(self, privileged):
        """
        Sets the privileged of this V1SecurityContext.
        Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.

        :param privileged: The privileged of this V1SecurityContext.
        :type: bool
        """

        self._privileged = privileged

    @property
    def read_only_root_filesystem(self):
        """
        Gets the read_only_root_filesystem of this V1SecurityContext.
        Whether this container has a read-only root filesystem. Default is false.

        :return: The read_only_root_filesystem of this V1SecurityContext.
        :rtype: bool
        """
        return self._read_only_root_filesystem

    @read_only_root_filesystem.setter
    def read_only_root_filesystem(self, read_only_root_filesystem):
        """
        Sets the read_only_root_filesystem of this V1SecurityContext.
        Whether this container has a read-only root filesystem. Default is false.

        :param read_only_root_filesystem: The read_only_root_filesystem of this V1SecurityContext.
        :type: bool
        """

        self._read_only_root_filesystem = read_only_root_filesystem

    @property
    def run_as_non_root(self):
        """
        Gets the run_as_non_root of this V1SecurityContext.
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :return: The run_as_non_root of this V1SecurityContext.
        :rtype: bool
        """
        return self._run_as_non_root

    @run_as_non_root.setter
    def run_as_non_root(self, run_as_non_root):
        """
        Sets the run_as_non_root of this V1SecurityContext.
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :param run_as_non_root: The run_as_non_root of this V1SecurityContext.
        :type: bool
        """

        self._run_as_non_root = run_as_non_root

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this V1SecurityContext.
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :return: The run_as_user of this V1SecurityContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this V1SecurityContext.
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :param run_as_user: The run_as_user of this V1SecurityContext.
        :type: int
        """

        self._run_as_user = run_as_user

    @property
    def se_linux_options(self):
        """
        Gets the se_linux_options of this V1SecurityContext.
        The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :return: The se_linux_options of this V1SecurityContext.
        :rtype: V1SELinuxOptions
        """
        return self._se_linux_options

    @se_linux_options.setter
    def se_linux_options(self, se_linux_options):
        """
        Sets the se_linux_options of this V1SecurityContext.
        The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :param se_linux_options: The se_linux_options of this V1SecurityContext.
        :type: V1SELinuxOptions
        """

        self._se_linux_options = se_linux_options

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1SecurityContext):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
