# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'unversioned.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1beta1PodDisruptionBudgetStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, current_healthy=None, desired_healthy=None, disrupted_pods=None, disruptions_allowed=None, expected_pods=None, observed_generation=None):
        """
        V1beta1PodDisruptionBudgetStatus - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'current_healthy': 'int',
            'desired_healthy': 'int',
            'disrupted_pods': 'dict(str, datetime)',
            'disruptions_allowed': 'int',
            'expected_pods': 'int',
            'observed_generation': 'int'
        }

        self.attribute_map = {
            'current_healthy': 'currentHealthy',
            'desired_healthy': 'desiredHealthy',
            'disrupted_pods': 'disruptedPods',
            'disruptions_allowed': 'disruptionsAllowed',
            'expected_pods': 'expectedPods',
            'observed_generation': 'observedGeneration'
        }

        self._current_healthy = current_healthy
        self._desired_healthy = desired_healthy
        self._disrupted_pods = disrupted_pods
        self._disruptions_allowed = disruptions_allowed
        self._expected_pods = expected_pods
        self._observed_generation = observed_generation

    @property
    def current_healthy(self):
        """
        Gets the current_healthy of this V1beta1PodDisruptionBudgetStatus.
        current number of healthy pods

        :return: The current_healthy of this V1beta1PodDisruptionBudgetStatus.
        :rtype: int
        """
        return self._current_healthy

    @current_healthy.setter
    def current_healthy(self, current_healthy):
        """
        Sets the current_healthy of this V1beta1PodDisruptionBudgetStatus.
        current number of healthy pods

        :param current_healthy: The current_healthy of this V1beta1PodDisruptionBudgetStatus.
        :type: int
        """
        if current_healthy is None:
            raise ValueError("Invalid value for `current_healthy`, must not be `None`")

        self._current_healthy = current_healthy

    @property
    def desired_healthy(self):
        """
        Gets the desired_healthy of this V1beta1PodDisruptionBudgetStatus.
        minimum desired number of healthy pods

        :return: The desired_healthy of this V1beta1PodDisruptionBudgetStatus.
        :rtype: int
        """
        return self._desired_healthy

    @desired_healthy.setter
    def desired_healthy(self, desired_healthy):
        """
        Sets the desired_healthy of this V1beta1PodDisruptionBudgetStatus.
        minimum desired number of healthy pods

        :param desired_healthy: The desired_healthy of this V1beta1PodDisruptionBudgetStatus.
        :type: int
        """
        if desired_healthy is None:
            raise ValueError("Invalid value for `desired_healthy`, must not be `None`")

        self._desired_healthy = desired_healthy

    @property
    def disrupted_pods(self):
        """
        Gets the disrupted_pods of this V1beta1PodDisruptionBudgetStatus.
        DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.

        :return: The disrupted_pods of this V1beta1PodDisruptionBudgetStatus.
        :rtype: dict(str, datetime)
        """
        return self._disrupted_pods

    @disrupted_pods.setter
    def disrupted_pods(self, disrupted_pods):
        """
        Sets the disrupted_pods of this V1beta1PodDisruptionBudgetStatus.
        DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.

        :param disrupted_pods: The disrupted_pods of this V1beta1PodDisruptionBudgetStatus.
        :type: dict(str, datetime)
        """
        if disrupted_pods is None:
            raise ValueError("Invalid value for `disrupted_pods`, must not be `None`")

        self._disrupted_pods = disrupted_pods

    @property
    def disruptions_allowed(self):
        """
        Gets the disruptions_allowed of this V1beta1PodDisruptionBudgetStatus.
        Number of pod disruptions that are currently allowed.

        :return: The disruptions_allowed of this V1beta1PodDisruptionBudgetStatus.
        :rtype: int
        """
        return self._disruptions_allowed

    @disruptions_allowed.setter
    def disruptions_allowed(self, disruptions_allowed):
        """
        Sets the disruptions_allowed of this V1beta1PodDisruptionBudgetStatus.
        Number of pod disruptions that are currently allowed.

        :param disruptions_allowed: The disruptions_allowed of this V1beta1PodDisruptionBudgetStatus.
        :type: int
        """
        if disruptions_allowed is None:
            raise ValueError("Invalid value for `disruptions_allowed`, must not be `None`")

        self._disruptions_allowed = disruptions_allowed

    @property
    def expected_pods(self):
        """
        Gets the expected_pods of this V1beta1PodDisruptionBudgetStatus.
        total number of pods counted by this disruption budget

        :return: The expected_pods of this V1beta1PodDisruptionBudgetStatus.
        :rtype: int
        """
        return self._expected_pods

    @expected_pods.setter
    def expected_pods(self, expected_pods):
        """
        Sets the expected_pods of this V1beta1PodDisruptionBudgetStatus.
        total number of pods counted by this disruption budget

        :param expected_pods: The expected_pods of this V1beta1PodDisruptionBudgetStatus.
        :type: int
        """
        if expected_pods is None:
            raise ValueError("Invalid value for `expected_pods`, must not be `None`")

        self._expected_pods = expected_pods

    @property
    def observed_generation(self):
        """
        Gets the observed_generation of this V1beta1PodDisruptionBudgetStatus.
        Most recent generation observed when updating this PDB status. PodDisruptionsAllowed and other status informatio is valid only if observedGeneration equals to PDB's object generation.

        :return: The observed_generation of this V1beta1PodDisruptionBudgetStatus.
        :rtype: int
        """
        return self._observed_generation

    @observed_generation.setter
    def observed_generation(self, observed_generation):
        """
        Sets the observed_generation of this V1beta1PodDisruptionBudgetStatus.
        Most recent generation observed when updating this PDB status. PodDisruptionsAllowed and other status informatio is valid only if observedGeneration equals to PDB's object generation.

        :param observed_generation: The observed_generation of this V1beta1PodDisruptionBudgetStatus.
        :type: int
        """

        self._observed_generation = observed_generation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1beta1PodDisruptionBudgetStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
