# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'unversioned.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VersionInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, build_date=None, compiler=None, git_commit=None, git_tree_state=None, git_version=None, go_version=None, major=None, minor=None, platform=None):
        """
        VersionInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'build_date': 'str',
            'compiler': 'str',
            'git_commit': 'str',
            'git_tree_state': 'str',
            'git_version': 'str',
            'go_version': 'str',
            'major': 'str',
            'minor': 'str',
            'platform': 'str'
        }

        self.attribute_map = {
            'build_date': 'buildDate',
            'compiler': 'compiler',
            'git_commit': 'gitCommit',
            'git_tree_state': 'gitTreeState',
            'git_version': 'gitVersion',
            'go_version': 'goVersion',
            'major': 'major',
            'minor': 'minor',
            'platform': 'platform'
        }

        self._build_date = build_date
        self._compiler = compiler
        self._git_commit = git_commit
        self._git_tree_state = git_tree_state
        self._git_version = git_version
        self._go_version = go_version
        self._major = major
        self._minor = minor
        self._platform = platform

    @property
    def build_date(self):
        """
        Gets the build_date of this VersionInfo.

        :return: The build_date of this VersionInfo.
        :rtype: str
        """
        return self._build_date

    @build_date.setter
    def build_date(self, build_date):
        """
        Sets the build_date of this VersionInfo.

        :param build_date: The build_date of this VersionInfo.
        :type: str
        """
        if build_date is None:
            raise ValueError("Invalid value for `build_date`, must not be `None`")

        self._build_date = build_date

    @property
    def compiler(self):
        """
        Gets the compiler of this VersionInfo.

        :return: The compiler of this VersionInfo.
        :rtype: str
        """
        return self._compiler

    @compiler.setter
    def compiler(self, compiler):
        """
        Sets the compiler of this VersionInfo.

        :param compiler: The compiler of this VersionInfo.
        :type: str
        """
        if compiler is None:
            raise ValueError("Invalid value for `compiler`, must not be `None`")

        self._compiler = compiler

    @property
    def git_commit(self):
        """
        Gets the git_commit of this VersionInfo.

        :return: The git_commit of this VersionInfo.
        :rtype: str
        """
        return self._git_commit

    @git_commit.setter
    def git_commit(self, git_commit):
        """
        Sets the git_commit of this VersionInfo.

        :param git_commit: The git_commit of this VersionInfo.
        :type: str
        """
        if git_commit is None:
            raise ValueError("Invalid value for `git_commit`, must not be `None`")

        self._git_commit = git_commit

    @property
    def git_tree_state(self):
        """
        Gets the git_tree_state of this VersionInfo.

        :return: The git_tree_state of this VersionInfo.
        :rtype: str
        """
        return self._git_tree_state

    @git_tree_state.setter
    def git_tree_state(self, git_tree_state):
        """
        Sets the git_tree_state of this VersionInfo.

        :param git_tree_state: The git_tree_state of this VersionInfo.
        :type: str
        """
        if git_tree_state is None:
            raise ValueError("Invalid value for `git_tree_state`, must not be `None`")

        self._git_tree_state = git_tree_state

    @property
    def git_version(self):
        """
        Gets the git_version of this VersionInfo.

        :return: The git_version of this VersionInfo.
        :rtype: str
        """
        return self._git_version

    @git_version.setter
    def git_version(self, git_version):
        """
        Sets the git_version of this VersionInfo.

        :param git_version: The git_version of this VersionInfo.
        :type: str
        """
        if git_version is None:
            raise ValueError("Invalid value for `git_version`, must not be `None`")

        self._git_version = git_version

    @property
    def go_version(self):
        """
        Gets the go_version of this VersionInfo.

        :return: The go_version of this VersionInfo.
        :rtype: str
        """
        return self._go_version

    @go_version.setter
    def go_version(self, go_version):
        """
        Sets the go_version of this VersionInfo.

        :param go_version: The go_version of this VersionInfo.
        :type: str
        """
        if go_version is None:
            raise ValueError("Invalid value for `go_version`, must not be `None`")

        self._go_version = go_version

    @property
    def major(self):
        """
        Gets the major of this VersionInfo.

        :return: The major of this VersionInfo.
        :rtype: str
        """
        return self._major

    @major.setter
    def major(self, major):
        """
        Sets the major of this VersionInfo.

        :param major: The major of this VersionInfo.
        :type: str
        """
        if major is None:
            raise ValueError("Invalid value for `major`, must not be `None`")

        self._major = major

    @property
    def minor(self):
        """
        Gets the minor of this VersionInfo.

        :return: The minor of this VersionInfo.
        :rtype: str
        """
        return self._minor

    @minor.setter
    def minor(self, minor):
        """
        Sets the minor of this VersionInfo.

        :param minor: The minor of this VersionInfo.
        :type: str
        """
        if minor is None:
            raise ValueError("Invalid value for `minor`, must not be `None`")

        self._minor = minor

    @property
    def platform(self):
        """
        Gets the platform of this VersionInfo.

        :return: The platform of this VersionInfo.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """
        Sets the platform of this VersionInfo.

        :param platform: The platform of this VersionInfo.
        :type: str
        """
        if platform is None:
            raise ValueError("Invalid value for `platform`, must not be `None`")

        self._platform = platform

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VersionInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
