# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'unversioned.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1beta1HorizontalPodAutoscalerSpec(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, cpu_utilization=None, max_replicas=None, min_replicas=None, scale_ref=None):
        """
        V1beta1HorizontalPodAutoscalerSpec - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'cpu_utilization': 'V1beta1CPUTargetUtilization',
            'max_replicas': 'int',
            'min_replicas': 'int',
            'scale_ref': 'V1beta1SubresourceReference'
        }

        self.attribute_map = {
            'cpu_utilization': 'cpuUtilization',
            'max_replicas': 'maxReplicas',
            'min_replicas': 'minReplicas',
            'scale_ref': 'scaleRef'
        }

        self._cpu_utilization = cpu_utilization
        self._max_replicas = max_replicas
        self._min_replicas = min_replicas
        self._scale_ref = scale_ref

    @property
    def cpu_utilization(self):
        """
        Gets the cpu_utilization of this V1beta1HorizontalPodAutoscalerSpec.
        target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified it defaults to the target CPU utilization at 80% of the requested resources.

        :return: The cpu_utilization of this V1beta1HorizontalPodAutoscalerSpec.
        :rtype: V1beta1CPUTargetUtilization
        """
        return self._cpu_utilization

    @cpu_utilization.setter
    def cpu_utilization(self, cpu_utilization):
        """
        Sets the cpu_utilization of this V1beta1HorizontalPodAutoscalerSpec.
        target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified it defaults to the target CPU utilization at 80% of the requested resources.

        :param cpu_utilization: The cpu_utilization of this V1beta1HorizontalPodAutoscalerSpec.
        :type: V1beta1CPUTargetUtilization
        """

        self._cpu_utilization = cpu_utilization

    @property
    def max_replicas(self):
        """
        Gets the max_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.

        :return: The max_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        :rtype: int
        """
        return self._max_replicas

    @max_replicas.setter
    def max_replicas(self, max_replicas):
        """
        Sets the max_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.

        :param max_replicas: The max_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        :type: int
        """
        if max_replicas is None:
            raise ValueError("Invalid value for `max_replicas`, must not be `None`")

        self._max_replicas = max_replicas

    @property
    def min_replicas(self):
        """
        Gets the min_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        lower limit for the number of pods that can be set by the autoscaler, default 1.

        :return: The min_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        :rtype: int
        """
        return self._min_replicas

    @min_replicas.setter
    def min_replicas(self, min_replicas):
        """
        Sets the min_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        lower limit for the number of pods that can be set by the autoscaler, default 1.

        :param min_replicas: The min_replicas of this V1beta1HorizontalPodAutoscalerSpec.
        :type: int
        """

        self._min_replicas = min_replicas

    @property
    def scale_ref(self):
        """
        Gets the scale_ref of this V1beta1HorizontalPodAutoscalerSpec.
        reference to Scale subresource; horizontal pod autoscaler will learn the current resource consumption from its status, and will set the desired number of pods by modifying its spec.

        :return: The scale_ref of this V1beta1HorizontalPodAutoscalerSpec.
        :rtype: V1beta1SubresourceReference
        """
        return self._scale_ref

    @scale_ref.setter
    def scale_ref(self, scale_ref):
        """
        Sets the scale_ref of this V1beta1HorizontalPodAutoscalerSpec.
        reference to Scale subresource; horizontal pod autoscaler will learn the current resource consumption from its status, and will set the desired number of pods by modifying its spec.

        :param scale_ref: The scale_ref of this V1beta1HorizontalPodAutoscalerSpec.
        :type: V1beta1SubresourceReference
        """
        if scale_ref is None:
            raise ValueError("Invalid value for `scale_ref`, must not be `None`")

        self._scale_ref = scale_ref

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1beta1HorizontalPodAutoscalerSpec):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
