# ocm-python-client

The generated code is based on code in [Kubernetes client gen ](https://github.com/kubernetes-client/gen)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import ocm_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ocm_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ocm_python_client
from pprint import pprint
from ocm_python_client.api import default_api
from ocm_python_client.model.aws import AWS
from ocm_python_client.model.aws_infrastructure_access_role import AWSInfrastructureAccessRole
from ocm_python_client.model.aws_infrastructure_access_role_grant import AWSInfrastructureAccessRoleGrant
from ocm_python_client.model.add_on import AddOn
from ocm_python_client.model.add_on_installation import AddOnInstallation
from ocm_python_client.model.add_on_version import AddOnVersion
from ocm_python_client.model.alerts_info import AlertsInfo
from ocm_python_client.model.api_clusters_mgmt_v1_addons_addon_id_versions_get200_response import ApiClustersMgmtV1AddonsAddonIdVersionsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_addons_get200_response import ApiClustersMgmtV1AddonsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_aws_infrastructure_access_roles_get200_response import ApiClustersMgmtV1AwsInfrastructureAccessRolesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_aws_inquiries_machine_types_post200_response import ApiClustersMgmtV1AwsInquiriesMachineTypesPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_aws_inquiries_regions_post200_response import ApiClustersMgmtV1AwsInquiriesRegionsPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_aws_inquiries_sts_credential_requests_get200_response import ApiClustersMgmtV1AwsInquiriesStsCredentialRequestsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_aws_inquiries_sts_policies_get200_response import ApiClustersMgmtV1AwsInquiriesStsPoliciesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_aws_inquiries_vpcs_post200_response import ApiClustersMgmtV1AwsInquiriesVpcsPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_available_regions_post200_response import ApiClustersMgmtV1CloudProvidersCloudProviderIdAvailableRegionsPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_regions_get200_response import ApiClustersMgmtV1CloudProvidersCloudProviderIdRegionsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_cloud_providers_get200_response import ApiClustersMgmtV1CloudProvidersGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_addons_get200_response import ApiClustersMgmtV1ClustersClusterIdAddonsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_get200_response import ApiClustersMgmtV1ClustersClusterIdAwsInfrastructureAccessRoleGrantsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_get200_response import ApiClustersMgmtV1ClustersClusterIdExternalConfigurationLabelsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_get200_response import ApiClustersMgmtV1ClustersClusterIdExternalConfigurationSyncsetsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_get200_response import ApiClustersMgmtV1ClustersClusterIdGateAgreementsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_groups_get200_response import ApiClustersMgmtV1ClustersClusterIdGroupsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_get200_response import ApiClustersMgmtV1ClustersClusterIdGroupsGroupIdUsersGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_get200_response import ApiClustersMgmtV1ClustersClusterIdIdentityProvidersGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_get200_response import ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_import_post200_response import ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersImportPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_import_post_request import ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersImportPostRequest
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_ingresses_get200_response import ApiClustersMgmtV1ClustersClusterIdIngressesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_get200_response import ApiClustersMgmtV1ClustersClusterIdLimitedSupportReasonsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_logs_get200_response import ApiClustersMgmtV1ClustersClusterIdLogsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_get200_response import ApiClustersMgmtV1ClustersClusterIdMachinePoolsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_get200_response import ApiClustersMgmtV1ClustersClusterIdStsOperatorRolesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_get200_response import ApiClustersMgmtV1ClustersClusterIdUpgradePoliciesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_clusters_get200_response import ApiClustersMgmtV1ClustersGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_flavours_get200_response import ApiClustersMgmtV1FlavoursGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_gcp_inquiries_encryption_keys_post200_response import ApiClustersMgmtV1GcpInquiriesEncryptionKeysPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_gcp_inquiries_key_rings_post200_response import ApiClustersMgmtV1GcpInquiriesKeyRingsPost200Response
from ocm_python_client.model.api_clusters_mgmt_v1_limited_support_reason_templates_get200_response import ApiClustersMgmtV1LimitedSupportReasonTemplatesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_machine_types_get200_response import ApiClustersMgmtV1MachineTypesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_products_get200_response import ApiClustersMgmtV1ProductsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_provision_shards_get200_response import ApiClustersMgmtV1ProvisionShardsGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_version_gates_get200_response import ApiClustersMgmtV1VersionGatesGet200Response
from ocm_python_client.model.api_clusters_mgmt_v1_versions_get200_response import ApiClustersMgmtV1VersionsGet200Response
from ocm_python_client.model.cpu_totals_node_role_os_metric_node import CPUTotalsNodeRoleOSMetricNode
from ocm_python_client.model.cloud_provider import CloudProvider
from ocm_python_client.model.cloud_provider_data import CloudProviderData
from ocm_python_client.model.cloud_region import CloudRegion
from ocm_python_client.model.cluster import Cluster
from ocm_python_client.model.cluster_credentials import ClusterCredentials
from ocm_python_client.model.cluster_operators_info import ClusterOperatorsInfo
from ocm_python_client.model.cluster_resources import ClusterResources
from ocm_python_client.model.cluster_status import ClusterStatus
from ocm_python_client.model.environment import Environment
from ocm_python_client.model.error import Error
from ocm_python_client.model.event import Event
from ocm_python_client.model.external_configuration import ExternalConfiguration
from ocm_python_client.model.flavour import Flavour
from ocm_python_client.model.group import Group
from ocm_python_client.model.ht_passwd_user import HTPasswdUser
from ocm_python_client.model.identity_provider import IdentityProvider
from ocm_python_client.model.ingress import Ingress
from ocm_python_client.model.label import Label
from ocm_python_client.model.limited_support_reason import LimitedSupportReason
from ocm_python_client.model.limited_support_reason_template import LimitedSupportReasonTemplate
from ocm_python_client.model.log import Log
from ocm_python_client.model.machine_pool import MachinePool
from ocm_python_client.model.metadata import Metadata
from ocm_python_client.model.nodes_info import NodesInfo
from ocm_python_client.model.operator_iam_role import OperatorIAMRole
from ocm_python_client.model.product import Product
from ocm_python_client.model.provision_shard import ProvisionShard
from ocm_python_client.model.socket_totals_node_role_os_metric_node import SocketTotalsNodeRoleOSMetricNode
from ocm_python_client.model.syncset import Syncset
from ocm_python_client.model.upgrade_policy import UpgradePolicy
from ocm_python_client.model.upgrade_policy_state import UpgradePolicyState
from ocm_python_client.model.user import User
from ocm_python_client.model.version import Version
from ocm_python_client.model.version_gate import VersionGate
from ocm_python_client.model.version_gate_agreement import VersionGateAgreement
# Defining the host is optional and defaults to https://api.openshift.com
# See configuration.py for a list of all supported configuration parameters.
configuration = ocm_python_client.Configuration(
    host = "https://api.openshift.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearer
configuration = ocm_python_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with ocm_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    addon_id = "addon_id_example" # str |  (optional)

    try:
        api_instance.api_clusters_mgmt_v1_addons_addon_id_delete(addon_id=addon_id)
    except ocm_python_client.ApiException as e:
        print("Exception when calling DefaultApi->api_clusters_mgmt_v1_addons_addon_id_delete: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.openshift.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_delete) | **DELETE** /api/clusters_mgmt/v1/addons/{addon_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_get) | **GET** /api/clusters_mgmt/v1/addons/{addon_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_patch) | **PATCH** /api/clusters_mgmt/v1/addons/{addon_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_versions_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_versions_get) | **GET** /api/clusters_mgmt/v1/addons/{addon_id}/versions |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_versions_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_versions_post) | **POST** /api/clusters_mgmt/v1/addons/{addon_id}/versions |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_versions_version_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_versions_version_id_delete) | **DELETE** /api/clusters_mgmt/v1/addons/{addon_id}/versions/{version_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_versions_version_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_versions_version_id_get) | **GET** /api/clusters_mgmt/v1/addons/{addon_id}/versions/{version_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_addon_id_versions_version_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_addon_id_versions_version_id_patch) | **PATCH** /api/clusters_mgmt/v1/addons/{addon_id}/versions/{version_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_get) | **GET** /api/clusters_mgmt/v1/addons |
*DefaultApi* | [**api_clusters_mgmt_v1_addons_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_addons_post) | **POST** /api/clusters_mgmt/v1/addons |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_infrastructure_access_roles_aws_infrastructure_access_role_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_infrastructure_access_roles_aws_infrastructure_access_role_id_get) | **GET** /api/clusters_mgmt/v1/aws_infrastructure_access_roles/{aws_infrastructure_access_role_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_infrastructure_access_roles_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_infrastructure_access_roles_get) | **GET** /api/clusters_mgmt/v1/aws_infrastructure_access_roles |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_inquiries_machine_types_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_inquiries_machine_types_post) | **POST** /api/clusters_mgmt/v1/aws_inquiries/machine_types |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_inquiries_regions_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_inquiries_regions_post) | **POST** /api/clusters_mgmt/v1/aws_inquiries/regions |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_inquiries_sts_credential_requests_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_inquiries_sts_credential_requests_get) | **GET** /api/clusters_mgmt/v1/aws_inquiries/sts_credential_requests |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_inquiries_sts_policies_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_inquiries_sts_policies_get) | **GET** /api/clusters_mgmt/v1/aws_inquiries/sts_policies |
*DefaultApi* | [**api_clusters_mgmt_v1_aws_inquiries_vpcs_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_aws_inquiries_vpcs_post) | **POST** /api/clusters_mgmt/v1/aws_inquiries/vpcs |
*DefaultApi* | [**api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_available_regions_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_available_regions_post) | **POST** /api/clusters_mgmt/v1/cloud_providers/{cloud_provider_id}/available_regions |
*DefaultApi* | [**api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_get) | **GET** /api/clusters_mgmt/v1/cloud_providers/{cloud_provider_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_regions_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_regions_get) | **GET** /api/clusters_mgmt/v1/cloud_providers/{cloud_provider_id}/regions |
*DefaultApi* | [**api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_regions_region_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_cloud_providers_cloud_provider_id_regions_region_id_get) | **GET** /api/clusters_mgmt/v1/cloud_providers/{cloud_provider_id}/regions/{region_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_cloud_providers_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_cloud_providers_get) | **GET** /api/clusters_mgmt/v1/cloud_providers |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addon_inquiries_addon_inquiry_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addon_inquiries_addon_inquiry_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/addon_inquiries/{addon_inquiry_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addon_inquiries_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addon_inquiries_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/addon_inquiries |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addons_addoninstallation_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addons_addoninstallation_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/addons/{addoninstallation_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addons_addoninstallation_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addons_addoninstallation_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/addons/{addoninstallation_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addons_addoninstallation_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addons_addoninstallation_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/addons/{addoninstallation_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addons_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addons_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/addons |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_addons_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_addons_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/addons |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_aws_infrastructure_access_role_grant_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_aws_infrastructure_access_role_grant_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/aws_infrastructure_access_role_grants/{aws_infrastructure_access_role_grant_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_aws_infrastructure_access_role_grant_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_aws_infrastructure_access_role_grant_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/aws_infrastructure_access_role_grants/{aws_infrastructure_access_role_grant_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/aws_infrastructure_access_role_grants |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_aws_infrastructure_access_role_grants_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/aws_infrastructure_access_role_grants |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_clusterdeployment_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_clusterdeployment_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/clusterdeployment |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_credentials_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_credentials_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/credentials |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/labels |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_label_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_label_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/labels/{label_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_label_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_label_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/labels/{label_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_label_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_label_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/labels/{label_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_labels_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/labels |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/syncsets |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/syncsets |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_syncset_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_syncset_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/syncsets/{syncset_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_syncset_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_syncset_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/syncsets/{syncset_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_syncset_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_external_configuration_syncsets_syncset_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/external_configuration/syncsets/{syncset_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/gate_agreements |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/gate_agreements |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_version_gate_agreement_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_version_gate_agreement_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/gate_agreements/{version_gate_agreement_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_version_gate_agreement_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_gate_agreements_version_gate_agreement_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/gate_agreements/{version_gate_agreement_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_groups_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_groups_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/groups |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/groups/{group_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/groups/{group_id}/users |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/groups/{group_id}/users |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_user_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_user_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/groups/{group_id}/users/{user_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_user_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_groups_group_id_users_user_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/groups/{group_id}/users/{user_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_hibernate_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_hibernate_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/hibernate |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id}/htpasswd_users |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_htpasswd_user_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_htpasswd_user_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id}/htpasswd_users/{htpasswd_user_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_htpasswd_user_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_htpasswd_user_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id}/htpasswd_users/{htpasswd_user_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_htpasswd_user_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_htpasswd_user_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id}/htpasswd_users/{htpasswd_user_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_import_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_import_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id}/htpasswd_users/import |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_htpasswd_users_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id}/htpasswd_users |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_identity_provider_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers/{identity_provider_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_identity_providers_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/identity_providers |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_ingresses_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_ingresses_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/ingresses |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_ingresses_ingress_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_ingresses_ingress_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/ingresses/{ingress_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_ingresses_ingress_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_ingresses_ingress_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/ingresses/{ingress_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_ingresses_ingress_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_ingresses_ingress_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/ingresses/{ingress_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_ingresses_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_ingresses_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/ingresses |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_ingresses_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_ingresses_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/ingresses |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/limited_support_reasons |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_limited_support_reason_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_limited_support_reason_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/limited_support_reasons/{limited_support_reason_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_limited_support_reason_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_limited_support_reason_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/limited_support_reasons/{limited_support_reason_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_limited_support_reasons_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/limited_support_reasons |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_logs_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_logs_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/logs |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_logs_install_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_logs_install_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/logs/install |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_logs_uninstall_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_logs_uninstall_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/logs/uninstall |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/machine_pools |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_machine_pool_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_machine_pool_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/machine_pools/{machine_pool_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_machine_pool_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_machine_pool_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/machine_pools/{machine_pool_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_machine_pool_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_machine_pool_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/machine_pools/{machine_pool_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_machine_pools_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/machine_pools |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_alerts_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_alerts_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/metric_queries/alerts |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_cluster_operators_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_cluster_operators_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/metric_queries/cluster_operators |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_cpu_total_by_node_roles_os_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_cpu_total_by_node_roles_os_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/metric_queries/cpu_total_by_node_roles_os |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_nodes_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_nodes_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/metric_queries/nodes |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_socket_total_by_node_roles_os_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_metric_queries_socket_total_by_node_roles_os_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/metric_queries/socket_total_by_node_roles_os |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_product_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_product_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/product |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_provision_shard_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_provision_shard_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/provision_shard |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_resources_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_resources_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/resources |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_resources_live_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_resources_live_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/resources/live |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_resume_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_resume_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/resume |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_status_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_status_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/status |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/sts_operator_roles |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_operator_iam_role_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_operator_iam_role_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/sts_operator_roles/{operator_iam_role_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_sts_operator_roles_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/sts_operator_roles |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_post) | **POST** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_delete) | **DELETE** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies/{upgrade_policy_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies/{upgrade_policy_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies/{upgrade_policy_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_state_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_state_get) | **GET** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies/{upgrade_policy_id}/state |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_state_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_cluster_id_upgrade_policies_upgrade_policy_id_state_patch) | **PATCH** /api/clusters_mgmt/v1/clusters/{cluster_id}/upgrade_policies/{upgrade_policy_id}/state |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_get) | **GET** /api/clusters_mgmt/v1/clusters |
*DefaultApi* | [**api_clusters_mgmt_v1_clusters_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_clusters_post) | **POST** /api/clusters_mgmt/v1/clusters |
*DefaultApi* | [**api_clusters_mgmt_v1_environment_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_environment_get) | **GET** /api/clusters_mgmt/v1/environment |
*DefaultApi* | [**api_clusters_mgmt_v1_environment_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_environment_patch) | **PATCH** /api/clusters_mgmt/v1/environment |
*DefaultApi* | [**api_clusters_mgmt_v1_events_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_events_post) | **POST** /api/clusters_mgmt/v1/events |
*DefaultApi* | [**api_clusters_mgmt_v1_flavours_flavour_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_flavours_flavour_id_get) | **GET** /api/clusters_mgmt/v1/flavours/{flavour_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_flavours_flavour_id_patch**](docs/DefaultApi.md#api_clusters_mgmt_v1_flavours_flavour_id_patch) | **PATCH** /api/clusters_mgmt/v1/flavours/{flavour_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_flavours_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_flavours_get) | **GET** /api/clusters_mgmt/v1/flavours |
*DefaultApi* | [**api_clusters_mgmt_v1_flavours_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_flavours_post) | **POST** /api/clusters_mgmt/v1/flavours |
*DefaultApi* | [**api_clusters_mgmt_v1_gcp_inquiries_encryption_keys_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_gcp_inquiries_encryption_keys_post) | **POST** /api/clusters_mgmt/v1/gcp_inquiries/encryption_keys |
*DefaultApi* | [**api_clusters_mgmt_v1_gcp_inquiries_key_rings_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_gcp_inquiries_key_rings_post) | **POST** /api/clusters_mgmt/v1/gcp_inquiries/key_rings |
*DefaultApi* | [**api_clusters_mgmt_v1_gcp_inquiries_regions_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_gcp_inquiries_regions_post) | **POST** /api/clusters_mgmt/v1/gcp_inquiries/regions |
*DefaultApi* | [**api_clusters_mgmt_v1_gcp_inquiries_vpcs_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_gcp_inquiries_vpcs_post) | **POST** /api/clusters_mgmt/v1/gcp_inquiries/vpcs |
*DefaultApi* | [**api_clusters_mgmt_v1_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_get) | **GET** /api/clusters_mgmt/v1 |
*DefaultApi* | [**api_clusters_mgmt_v1_limited_support_reason_templates_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_limited_support_reason_templates_get) | **GET** /api/clusters_mgmt/v1/limited_support_reason_templates |
*DefaultApi* | [**api_clusters_mgmt_v1_limited_support_reason_templates_limited_support_reason_template_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_limited_support_reason_templates_limited_support_reason_template_id_get) | **GET** /api/clusters_mgmt/v1/limited_support_reason_templates/{limited_support_reason_template_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_machine_types_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_machine_types_get) | **GET** /api/clusters_mgmt/v1/machine_types |
*DefaultApi* | [**api_clusters_mgmt_v1_products_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_products_get) | **GET** /api/clusters_mgmt/v1/products |
*DefaultApi* | [**api_clusters_mgmt_v1_products_product_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_products_product_id_get) | **GET** /api/clusters_mgmt/v1/products/{product_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_provision_shards_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_provision_shards_get) | **GET** /api/clusters_mgmt/v1/provision_shards |
*DefaultApi* | [**api_clusters_mgmt_v1_provision_shards_provision_shard_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_provision_shards_provision_shard_id_get) | **GET** /api/clusters_mgmt/v1/provision_shards/{provision_shard_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_version_gates_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_version_gates_get) | **GET** /api/clusters_mgmt/v1/version_gates |
*DefaultApi* | [**api_clusters_mgmt_v1_version_gates_post**](docs/DefaultApi.md#api_clusters_mgmt_v1_version_gates_post) | **POST** /api/clusters_mgmt/v1/version_gates |
*DefaultApi* | [**api_clusters_mgmt_v1_version_gates_version_gate_id_delete**](docs/DefaultApi.md#api_clusters_mgmt_v1_version_gates_version_gate_id_delete) | **DELETE** /api/clusters_mgmt/v1/version_gates/{version_gate_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_version_gates_version_gate_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_version_gates_version_gate_id_get) | **GET** /api/clusters_mgmt/v1/version_gates/{version_gate_id} |
*DefaultApi* | [**api_clusters_mgmt_v1_versions_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_versions_get) | **GET** /api/clusters_mgmt/v1/versions |
*DefaultApi* | [**api_clusters_mgmt_v1_versions_version_id_get**](docs/DefaultApi.md#api_clusters_mgmt_v1_versions_version_id_get) | **GET** /api/clusters_mgmt/v1/versions/{version_id} |


## Documentation For Models

 - [AWS](docs/AWS.md)
 - [AWSFlavour](docs/AWSFlavour.md)
 - [AWSInfrastructureAccessRole](docs/AWSInfrastructureAccessRole.md)
 - [AWSInfrastructureAccessRoleGrant](docs/AWSInfrastructureAccessRoleGrant.md)
 - [AWSInfrastructureAccessRoleGrantState](docs/AWSInfrastructureAccessRoleGrantState.md)
 - [AWSInfrastructureAccessRoleState](docs/AWSInfrastructureAccessRoleState.md)
 - [AWSMachinePool](docs/AWSMachinePool.md)
 - [AWSSTSPolicy](docs/AWSSTSPolicy.md)
 - [AWSSpotMarketOptions](docs/AWSSpotMarketOptions.md)
 - [AWSVolume](docs/AWSVolume.md)
 - [AddOn](docs/AddOn.md)
 - [AddOnConfig](docs/AddOnConfig.md)
 - [AddOnEnvironmentVariable](docs/AddOnEnvironmentVariable.md)
 - [AddOnInstallMode](docs/AddOnInstallMode.md)
 - [AddOnInstallation](docs/AddOnInstallation.md)
 - [AddOnInstallationParameter](docs/AddOnInstallationParameter.md)
 - [AddOnInstallationState](docs/AddOnInstallationState.md)
 - [AddOnParameter](docs/AddOnParameter.md)
 - [AddOnParameterOption](docs/AddOnParameterOption.md)
 - [AddOnRequirement](docs/AddOnRequirement.md)
 - [AddOnRequirementStatus](docs/AddOnRequirementStatus.md)
 - [AddOnSubOperator](docs/AddOnSubOperator.md)
 - [AddOnVersion](docs/AddOnVersion.md)
 - [AdminCredentials](docs/AdminCredentials.md)
 - [AlertInfo](docs/AlertInfo.md)
 - [AlertSeverity](docs/AlertSeverity.md)
 - [AlertsInfo](docs/AlertsInfo.md)
 - [ApiClustersMgmtV1AddonsAddonIdVersionsGet200Response](docs/ApiClustersMgmtV1AddonsAddonIdVersionsGet200Response.md)
 - [ApiClustersMgmtV1AddonsGet200Response](docs/ApiClustersMgmtV1AddonsGet200Response.md)
 - [ApiClustersMgmtV1AwsInfrastructureAccessRolesGet200Response](docs/ApiClustersMgmtV1AwsInfrastructureAccessRolesGet200Response.md)
 - [ApiClustersMgmtV1AwsInquiriesMachineTypesPost200Response](docs/ApiClustersMgmtV1AwsInquiriesMachineTypesPost200Response.md)
 - [ApiClustersMgmtV1AwsInquiriesRegionsPost200Response](docs/ApiClustersMgmtV1AwsInquiriesRegionsPost200Response.md)
 - [ApiClustersMgmtV1AwsInquiriesStsCredentialRequestsGet200Response](docs/ApiClustersMgmtV1AwsInquiriesStsCredentialRequestsGet200Response.md)
 - [ApiClustersMgmtV1AwsInquiriesStsPoliciesGet200Response](docs/ApiClustersMgmtV1AwsInquiriesStsPoliciesGet200Response.md)
 - [ApiClustersMgmtV1AwsInquiriesVpcsPost200Response](docs/ApiClustersMgmtV1AwsInquiriesVpcsPost200Response.md)
 - [ApiClustersMgmtV1CloudProvidersCloudProviderIdAvailableRegionsPost200Response](docs/ApiClustersMgmtV1CloudProvidersCloudProviderIdAvailableRegionsPost200Response.md)
 - [ApiClustersMgmtV1CloudProvidersCloudProviderIdRegionsGet200Response](docs/ApiClustersMgmtV1CloudProvidersCloudProviderIdRegionsGet200Response.md)
 - [ApiClustersMgmtV1CloudProvidersGet200Response](docs/ApiClustersMgmtV1CloudProvidersGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdAddonsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdAddonsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdAwsInfrastructureAccessRoleGrantsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdAwsInfrastructureAccessRoleGrantsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdExternalConfigurationLabelsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdExternalConfigurationLabelsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdExternalConfigurationSyncsetsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdExternalConfigurationSyncsetsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdGateAgreementsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdGateAgreementsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdGroupsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdGroupsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdGroupsGroupIdUsersGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdGroupsGroupIdUsersGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdIdentityProvidersGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdIdentityProvidersGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersImportPost200Response](docs/ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersImportPost200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersImportPostRequest](docs/ApiClustersMgmtV1ClustersClusterIdIdentityProvidersIdentityProviderIdHtpasswdUsersImportPostRequest.md)
 - [ApiClustersMgmtV1ClustersClusterIdIngressesGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdIngressesGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdLimitedSupportReasonsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdLimitedSupportReasonsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdLogsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdLogsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdMachinePoolsGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdMachinePoolsGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdStsOperatorRolesGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdStsOperatorRolesGet200Response.md)
 - [ApiClustersMgmtV1ClustersClusterIdUpgradePoliciesGet200Response](docs/ApiClustersMgmtV1ClustersClusterIdUpgradePoliciesGet200Response.md)
 - [ApiClustersMgmtV1ClustersGet200Response](docs/ApiClustersMgmtV1ClustersGet200Response.md)
 - [ApiClustersMgmtV1FlavoursGet200Response](docs/ApiClustersMgmtV1FlavoursGet200Response.md)
 - [ApiClustersMgmtV1GcpInquiriesEncryptionKeysPost200Response](docs/ApiClustersMgmtV1GcpInquiriesEncryptionKeysPost200Response.md)
 - [ApiClustersMgmtV1GcpInquiriesKeyRingsPost200Response](docs/ApiClustersMgmtV1GcpInquiriesKeyRingsPost200Response.md)
 - [ApiClustersMgmtV1LimitedSupportReasonTemplatesGet200Response](docs/ApiClustersMgmtV1LimitedSupportReasonTemplatesGet200Response.md)
 - [ApiClustersMgmtV1MachineTypesGet200Response](docs/ApiClustersMgmtV1MachineTypesGet200Response.md)
 - [ApiClustersMgmtV1ProductsGet200Response](docs/ApiClustersMgmtV1ProductsGet200Response.md)
 - [ApiClustersMgmtV1ProvisionShardsGet200Response](docs/ApiClustersMgmtV1ProvisionShardsGet200Response.md)
 - [ApiClustersMgmtV1VersionGatesGet200Response](docs/ApiClustersMgmtV1VersionGatesGet200Response.md)
 - [ApiClustersMgmtV1VersionsGet200Response](docs/ApiClustersMgmtV1VersionsGet200Response.md)
 - [BillingModel](docs/BillingModel.md)
 - [CCS](docs/CCS.md)
 - [CPUTotalNodeRoleOSMetricNode](docs/CPUTotalNodeRoleOSMetricNode.md)
 - [CPUTotalsNodeRoleOSMetricNode](docs/CPUTotalsNodeRoleOSMetricNode.md)
 - [CloudProvider](docs/CloudProvider.md)
 - [CloudProviderData](docs/CloudProviderData.md)
 - [CloudRegion](docs/CloudRegion.md)
 - [CloudVPC](docs/CloudVPC.md)
 - [Cluster](docs/Cluster.md)
 - [ClusterAPI](docs/ClusterAPI.md)
 - [ClusterConfigurationMode](docs/ClusterConfigurationMode.md)
 - [ClusterConsole](docs/ClusterConsole.md)
 - [ClusterCredentials](docs/ClusterCredentials.md)
 - [ClusterDeployment](docs/ClusterDeployment.md)
 - [ClusterHealthState](docs/ClusterHealthState.md)
 - [ClusterNodes](docs/ClusterNodes.md)
 - [ClusterOperatorInfo](docs/ClusterOperatorInfo.md)
 - [ClusterOperatorState](docs/ClusterOperatorState.md)
 - [ClusterOperatorsInfo](docs/ClusterOperatorsInfo.md)
 - [ClusterRegistration](docs/ClusterRegistration.md)
 - [ClusterResources](docs/ClusterResources.md)
 - [ClusterState](docs/ClusterState.md)
 - [ClusterStatus](docs/ClusterStatus.md)
 - [CredentialRequest](docs/CredentialRequest.md)
 - [DNS](docs/DNS.md)
 - [DetectionType](docs/DetectionType.md)
 - [EncryptionKey](docs/EncryptionKey.md)
 - [Environment](docs/Environment.md)
 - [Error](docs/Error.md)
 - [Event](docs/Event.md)
 - [ExternalConfiguration](docs/ExternalConfiguration.md)
 - [Flavour](docs/Flavour.md)
 - [FlavourNodes](docs/FlavourNodes.md)
 - [GCP](docs/GCP.md)
 - [GCPFlavour](docs/GCPFlavour.md)
 - [GCPNetwork](docs/GCPNetwork.md)
 - [GithubIdentityProvider](docs/GithubIdentityProvider.md)
 - [GitlabIdentityProvider](docs/GitlabIdentityProvider.md)
 - [GoogleIdentityProvider](docs/GoogleIdentityProvider.md)
 - [Group](docs/Group.md)
 - [HTPasswdIdentityProvider](docs/HTPasswdIdentityProvider.md)
 - [HTPasswdUser](docs/HTPasswdUser.md)
 - [HyperShift](docs/HyperShift.md)
 - [IdentityProvider](docs/IdentityProvider.md)
 - [IdentityProviderMappingMethod](docs/IdentityProviderMappingMethod.md)
 - [IdentityProviderType](docs/IdentityProviderType.md)
 - [InflightCheck](docs/InflightCheck.md)
 - [InflightCheckState](docs/InflightCheckState.md)
 - [Ingress](docs/Ingress.md)
 - [InstanceIAMRoles](docs/InstanceIAMRoles.md)
 - [KeyRing](docs/KeyRing.md)
 - [LDAPAttributes](docs/LDAPAttributes.md)
 - [LDAPIdentityProvider](docs/LDAPIdentityProvider.md)
 - [Label](docs/Label.md)
 - [LimitedSupportReason](docs/LimitedSupportReason.md)
 - [LimitedSupportReasonTemplate](docs/LimitedSupportReasonTemplate.md)
 - [ListeningMethod](docs/ListeningMethod.md)
 - [Log](docs/Log.md)
 - [MachinePool](docs/MachinePool.md)
 - [MachinePoolAutoscaling](docs/MachinePoolAutoscaling.md)
 - [MachinePoolSecurityGroupFilter](docs/MachinePoolSecurityGroupFilter.md)
 - [MachineType](docs/MachineType.md)
 - [MachineTypeCategory](docs/MachineTypeCategory.md)
 - [MachineTypeSize](docs/MachineTypeSize.md)
 - [ManagedService](docs/ManagedService.md)
 - [Metadata](docs/Metadata.md)
 - [Network](docs/Network.md)
 - [NodeInfo](docs/NodeInfo.md)
 - [NodeType](docs/NodeType.md)
 - [NodesInfo](docs/NodesInfo.md)
 - [OpenIDClaims](docs/OpenIDClaims.md)
 - [OpenIDIdentityProvider](docs/OpenIDIdentityProvider.md)
 - [OperatorIAMRole](docs/OperatorIAMRole.md)
 - [Product](docs/Product.md)
 - [ProvisionShard](docs/ProvisionShard.md)
 - [Proxy](docs/Proxy.md)
 - [SSHCredentials](docs/SSHCredentials.md)
 - [STS](docs/STS.md)
 - [STSCredentialRequest](docs/STSCredentialRequest.md)
 - [STSOperator](docs/STSOperator.md)
 - [ServerConfig](docs/ServerConfig.md)
 - [SocketTotalNodeRoleOSMetricNode](docs/SocketTotalNodeRoleOSMetricNode.md)
 - [SocketTotalsNodeRoleOSMetricNode](docs/SocketTotalsNodeRoleOSMetricNode.md)
 - [Subnetwork](docs/Subnetwork.md)
 - [Subscription](docs/Subscription.md)
 - [Syncset](docs/Syncset.md)
 - [Taint](docs/Taint.md)
 - [UpgradePolicy](docs/UpgradePolicy.md)
 - [UpgradePolicyState](docs/UpgradePolicyState.md)
 - [UpgradePolicyStateValue](docs/UpgradePolicyStateValue.md)
 - [User](docs/User.md)
 - [Value](docs/Value.md)
 - [Version](docs/Version.md)
 - [VersionGate](docs/VersionGate.md)
 - [VersionGateAgreement](docs/VersionGateAgreement.md)


## Documentation For Authorization


## bearer

- **Type**: Bearer authentication (JWT)


## Author

ocm-feedback@redhat.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ocm_python_client.apis and ocm_python_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ocm_python_client.api.default_api import DefaultApi`
- `from ocm_python_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ocm_python_client
from ocm_python_client.apis import *
from ocm_python_client.models import *
```
