# Generated using https://github.com/RedHatQE/openshift-python-wrapper/blob/main/scripts/resource/README.md


from typing import Any

from ocp_resources.resource import NamespacedResource


class ConfigMap(NamespacedResource):
    """
    ConfigMap holds configuration data for pods to consume.
    """

    api_version: str = NamespacedResource.ApiVersion.V1

    def __init__(
        self,
        binary_data: dict[str, Any] | None = None,
        data: dict[str, Any] | None = None,
        immutable: bool | None = None,
        **kwargs: Any,
    ) -> None:
        r"""
        Args:
            binary_data (dict[str, Any]): BinaryData contains the binary data. Each key must consist of
              alphanumeric characters, '-', '_' or '.'. BinaryData can contain
              byte sequences that are not in the UTF-8 range. The keys stored in
              BinaryData must not overlap with the ones in the Data field, this
              is enforced during validation process. Using this field will
              require 1.10+ apiserver and kubelet.

            data (dict[str, Any]): Data contains the configuration data. Each key must consist of
              alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8
              byte sequences must use the BinaryData field. The keys stored in
              Data must not overlap with the keys in the BinaryData field, this
              is enforced during validation process.

            immutable (bool): Immutable, if set to true, ensures that data stored in the ConfigMap
              cannot be updated (only object metadata can be modified). If not
              set to true, the field can be modified at any time. Defaulted to
              nil.

        """
        super().__init__(**kwargs)

        self.binary_data = binary_data
        self.data = data
        self.immutable = immutable

    def to_dict(self) -> None:

        super().to_dict()

        if not self.kind_dict and not self.yaml_file:
            if self.binary_data is not None:
                self.res["binaryData"] = self.binary_data

            if self.data is not None:
                self.res["data"] = self.data

            if self.immutable is not None:
                self.res["immutable"] = self.immutable

    # End of generated code
