# Generated using https://github.com/RedHatQE/openshift-python-wrapper/blob/main/scripts/resource/README.md#adding-tests

import filecmp
from pathlib import Path
import pytest

from class_generator.constants import TESTS_MANIFESTS_DIR
from class_generator.core.generator import class_generator


@pytest.mark.parametrize(
    "kind",
    (
        "APIServer",
        "ClusterOperator",
        "ConfigMap",
        "DNS",
        "Deployment",
        "Image",
        "ImageContentSourcePolicy",
        "Machine",
        "NMState",
        "OAuth",
        "Pipeline",
        "Pod",
        "Secret",
        "ServiceMeshMember",
        "ServingRuntime",
    ),
)
def test_parse_explain(tmpdir_factory, kind):
    output_dir = tmpdir_factory.mktemp("output-dir")
    output_files = class_generator(
        kind=kind,
        output_dir=output_dir,
    )
    for output_file in output_files:
        assert filecmp.cmp(output_file, str(TESTS_MANIFESTS_DIR / kind / Path(output_file).name))
