# Generated using https://github.com/RedHatQE/openshift-python-wrapper/blob/main/scripts/resource/README.md


from typing import Any
from ocp_resources.resource import Resource, MissingRequiredArgumentError


class Config(Resource):
    """
        Config is the configuration object for a registry instance managed by
    the registry operator

    Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).
    """

    api_group: str = Resource.ApiGroup.IMAGEREGISTRY_OPERATOR_OPENSHIFT_IO

    def __init__(
        self,
        affinity: dict[str, Any] | None = None,
        default_route: bool | None = None,
        disable_redirect: bool | None = None,
        http_secret: str | None = None,
        log_level: str | None = None,
        logging: int | None = None,
        management_state: str | None = None,
        node_selector: dict[str, Any] | None = None,
        observed_config: dict[str, Any] | None = None,
        operator_log_level: str | None = None,
        proxy: dict[str, Any] | None = None,
        read_only: bool | None = None,
        replicas: int | None = None,
        requests: dict[str, Any] | None = None,
        resources: dict[str, Any] | None = None,
        rollout_strategy: str | None = None,
        routes: list[Any] | None = None,
        storage: dict[str, Any] | None = None,
        tolerations: list[Any] | None = None,
        topology_spread_constraints: list[Any] | None = None,
        unsupported_config_overrides: dict[str, Any] | None = None,
        **kwargs: Any,
    ) -> None:
        r"""
        Args:
            affinity (dict[str, Any]): affinity is a group of node affinity scheduling rules for the image
              registry pod(s).

            default_route (bool): defaultRoute indicates whether an external facing route for the
              registry should be created using the default generated hostname.

            disable_redirect (bool): disableRedirect controls whether to route all data through the
              Registry, rather than redirecting to the backend.

            http_secret (str): httpSecret is the value needed by the registry to secure uploads,
              generated by default.

            log_level (str): logLevel is an intent based logging for an overall component.  It does
              not give fine grained control, but it is a simple way to manage
              coarse grained logging choices that operators have to interpret
              for their operands.  Valid values are: "Normal", "Debug", "Trace",
              "TraceAll". Defaults to "Normal".

            logging (int): logging is deprecated, use logLevel instead.

            management_state (str): managementState indicates whether and how the operator should manage
              the component

            node_selector (dict[str, Any]): nodeSelector defines the node selection constraints for the registry
              pod.

            observed_config (dict[str, Any]): observedConfig holds a sparse config that controller has observed from
              the cluster state.  It exists in spec because it is an input to
              the level for the operator

            operator_log_level (str): operatorLogLevel is an intent based logging for the operator itself.
              It does not give fine grained control, but it is a simple way to
              manage coarse grained logging choices that operators have to
              interpret for themselves.  Valid values are: "Normal", "Debug",
              "Trace", "TraceAll". Defaults to "Normal".

            proxy (dict[str, Any]): proxy defines the proxy to be used when calling master api, upstream
              registries, etc.

            read_only (bool): readOnly indicates whether the registry instance should reject
              attempts to push new images or delete existing ones.

            replicas (int): replicas determines the number of registry instances to run.

            requests (dict[str, Any]): requests controls how many parallel requests a given registry instance
              will handle before queuing additional requests.

            resources (dict[str, Any]): resources defines the resource requests+limits for the registry pod.

            rollout_strategy (str): rolloutStrategy defines rollout strategy for the image registry
              deployment.

            routes (list[Any]): routes defines additional external facing routes which should be
              created for the registry.

            storage (dict[str, Any]): storage details for configuring registry storage, e.g. S3 bucket
              coordinates.

            tolerations (list[Any]): tolerations defines the tolerations for the registry pod.

            topology_spread_constraints (list[Any]): topologySpreadConstraints specify how to spread matching pods among
              the given topology.

            unsupported_config_overrides (dict[str, Any]): unsupportedConfigOverrides overrides the final configuration that was
              computed by the operator. Red Hat does not support the use of this
              field. Misuse of this field could lead to unexpected behavior or
              conflict with other configuration options. Seek guidance from the
              Red Hat support before using this field. Use of this property
              blocks cluster upgrades, it must be removed before upgrading your
              cluster.

        """
        super().__init__(**kwargs)

        self.affinity = affinity
        self.default_route = default_route
        self.disable_redirect = disable_redirect
        self.http_secret = http_secret
        self.log_level = log_level
        self.logging = logging
        self.management_state = management_state
        self.node_selector = node_selector
        self.observed_config = observed_config
        self.operator_log_level = operator_log_level
        self.proxy = proxy
        self.read_only = read_only
        self.replicas = replicas
        self.requests = requests
        self.resources = resources
        self.rollout_strategy = rollout_strategy
        self.routes = routes
        self.storage = storage
        self.tolerations = tolerations
        self.topology_spread_constraints = topology_spread_constraints
        self.unsupported_config_overrides = unsupported_config_overrides

    def to_dict(self) -> None:
        super().to_dict()

        if not self.kind_dict and not self.yaml_file:
            if self.replicas is None:
                raise MissingRequiredArgumentError(argument="self.replicas")

            self.res["spec"] = {}
            _spec = self.res["spec"]

            _spec["replicas"] = self.replicas

            if self.affinity is not None:
                _spec["affinity"] = self.affinity

            if self.default_route is not None:
                _spec["defaultRoute"] = self.default_route

            if self.disable_redirect is not None:
                _spec["disableRedirect"] = self.disable_redirect

            if self.http_secret is not None:
                _spec["httpSecret"] = self.http_secret

            if self.log_level is not None:
                _spec["logLevel"] = self.log_level

            if self.logging is not None:
                _spec["logging"] = self.logging

            if self.management_state is not None:
                _spec["managementState"] = self.management_state

            if self.node_selector is not None:
                _spec["nodeSelector"] = self.node_selector

            if self.observed_config is not None:
                _spec["observedConfig"] = self.observed_config

            if self.operator_log_level is not None:
                _spec["operatorLogLevel"] = self.operator_log_level

            if self.proxy is not None:
                _spec["proxy"] = self.proxy

            if self.read_only is not None:
                _spec["readOnly"] = self.read_only

            if self.requests is not None:
                _spec["requests"] = self.requests

            if self.resources is not None:
                _spec["resources"] = self.resources

            if self.rollout_strategy is not None:
                _spec["rolloutStrategy"] = self.rollout_strategy

            if self.routes is not None:
                _spec["routes"] = self.routes

            if self.storage is not None:
                _spec["storage"] = self.storage

            if self.tolerations is not None:
                _spec["tolerations"] = self.tolerations

            if self.topology_spread_constraints is not None:
                _spec["topologySpreadConstraints"] = self.topology_spread_constraints

            if self.unsupported_config_overrides is not None:
                _spec["unsupportedConfigOverrides"] = self.unsupported_config_overrides

    # End of generated code
