# example-code

This readme is intended as a guide on how Python code in **github.com/equinor/ops-py** should be written, documented and distributed.

It also includes an [example](#example-on-how-to-use-this-example-simple_service-code-in-other-projects) on how to *use* such a Python library (PIP package) in other Python code/projects, in GitHub Action/Azure DevOps Pipelines etc.

The files included in the `code/example-code-template/src` directory may be used as a template in other projects.
```
├─ code/example-code-template/src/
│  ├─ readme.md
│  ├─ simple_service/
│  │  ├─ __init__.py
│  │  ├─ simple_service.py
```

The additional files, neeeded by [setuptools](https://setuptools.pypa.io/en/latest/userguide/pyproject_config.html), will be generated by [ops-py-generate-pyproject](https://pypi.org/project/ops-py-generate-pyproject) during CI/CD pipeline run.

If the [ops-py-generate-pyproject](https://pypi.org/project/ops-py-generate-pyproject) is not used, please refer to the `tools/build.sh` script.


### What needs to be done before start coding
Create a directory where the project files, code files and directories will reside.
The files and subfolder within this directory must be structured as the `example-code-template` directory tree above.  

Run `tools/create_venv.sh`  
This will create a hidden directory `.venv` within the `src` directory. This will be the virtual environment for the code to use and where  packages will be installed during development.

Notes from `tools/create_venv.sh`:
```
Instead of installing all the needed pip packages
on to your system, the packages should be
installed to an isolated environment instead.
Use this script to create a virtual environment
before you start coding.

Only the needed packages, and verified version, should
be installed during deploy. This is ensured by generating a
requirements.txt file when ready to distribute
and deploy. (Please refer to the create_requirements.sh
script.)

Create a directory for your project. Make sure to also
create a directory named 'src' within the project directory.
All the Python code will reside in the 'src' directory.
The virtual enviroment will be created in a '.venv' directory,
within the 'src' 'directory.

Execute the script followed by the path to the project as an
argument, e.g: tools/create_venv.sh code/my-fabulous-project

Specify this '.venv' dir as the interpreter for you IDE project.
To activate it from shell:
cd code/my-fabulous-project/src
source .venv/bin/activate
```


### When ready to start coding
Make sure the venv is activated. Please refer to your IDE or activate it from command line using `source .venv/bin/activate`

The code must be placed inn subfolder(s) within the `src` directory - like with the `simple_service` diretory from the template / example.


### How the code should be written and documented
The code should include comments and proper documentation. **Use Docstrings**
Please refer to the documentation in [simple_service.py](https://github.com/equinor/ops-infra/blob/python_guidelines/python/template_simple_service/src/simple_service/simple_service.py)
and to [Documenting Python Code: A Complete Guide](https://realpython.com/documenting-python-code)

To write proper and understandable code, for you and for others to read, please refer to
[How to Write Beautiful Python Code With PEP 8](https://realpython.com/python-pep8/)


### What needs to be done prior to build and distribution of the code
- `src/my_code_dir/__init__.py`  
This file **MUST** include the version of the project.  
Example from the **template_simple_service**:
```
__version__ = '0.0.1'
__author__ = "Svein Tore Eikeskog"
__email__ = "svte@equinor.com"
__description__ = "A simple service to calculate number of atoms in the universe"

```
**NOTE:** Next time the project is pushed to pypi the version must be bumped. Edit the `__init__py` file accordingly.

- `src/requirements.txt`  
If pip packages are installed during develompent, a `requirements.txt` file must be checked in and always follow the code. You may use the `tools/create_requirements.sh` to create one. If new packages are installed or updated during the development, the `requirements.txt` must be regenerated. Use the `tools/create_requirements.sh` frequently/whenever needed.

- `src/readme.md`  


### Usage example:
Create a new directory for your project. Create a new virtual venv and source it:

 ```
 mkdir my_new_project`
 cd my_new_project
 python3 -m venv venv
 source venv/bin/activate
 ```

 Install the simple service from the example:
```
pip install ops-py-example-code
```

Start the Python interpreter
```
python
```

Example code:
```
from simple_service import simple_service
wan_service = simple_service.SimpleService()
wan_service.fetch_wan_ip()
my_ip = wan_service.get_wan_ip()
print(my_ip)
```
