# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['orchid_python_api']

package_data = \
{'': ['*']}

install_requires = \
['deal==3.9.0',
 'matplotlib==3.3.0',
 'numpy==1.19.0',
 'pandas==1.0.5',
 'python-dateutil==2.8.1',
 'pythonnet==2.5.1',
 'pyyaml==5.3.1',
 'seaborn==0.10.1',
 'toolz==0.10.0',
 'typing-extensions==3.7.4.2']

setup_kwargs = {
    'name': 'orchid-python-api',
    'version': '2020.4.151',
    'description': 'Defines and implements the Python API for Orchid*. (*Orchid is a mark of Reveal Energy Services, Inc.)',
    'long_description': '# Introduction \n\nThis project defines the implementation of the Python API for Orchid*.\n\n(*Orchid in a mark of Revel Energy Services. Inc.)\n\nSpecifically, the `orchid` package exposes the Orchid API to Python applications and the Python REPL.\nAdditionally, this project contains a number of examples in the `examples` directory:\n\n- `plot_trajectories.ipynb`\n- `plot_treatment.ipynb`\n- `plot_monitor_pressure.py`\n- `completion_analysis.ipynb`\n\nThe first two notebooks plot:\n\n- The well trajectories for a project\n- The treatment curves (pressure, slurry rate and concentration) for a specific stage of a well in a project\n\nThe console application, `plot_monitor_pressure.py`, plots the monitor pressure curves for a project specified as a\ncommand line argument. \n \nFinally, the notebook, `completion_analysis.ipynb`, provides a more detailed analysis of the completion performed on\n two different wells in a project.\n\n# Getting Started\n\n## End-user Usage\n\nWe recommend the use of virtual environments to use the Orchid Python API. This choice avoids putting \nOrchid-specific-packages in your system Python environment.\n\nYou have several options to create and manage virtual environments: `venv`, `pipenv`, `poetry`, and `conda`.\nThe `venv ` is available as a standard Python package and is a spartan tool to manage environments. `poetry`\nis a tool targeting developers but can be used by end-users. Our recommended tool is `pipenv`. It provides a \ngood balance between `venv ` and `poetry`. Remember, both `pipenv` and `poetry` must be installed in your \nPython environment separately from Python itself, but can be installed using `pip`. Finally, `conda` supports \nthe creation of virtual environments, but assumes that you have installed a Python distribution using Anaconda\nor miniconda. We will not describe `conda` further.\n\nUsing any of `pipenv`, `venv` or `poetry`, your first step is to create a directory for *your* project. Then, \nchange into *your* project directory.\n\n### Pipenv\n\n- Create virtual environment (using Powershell (recommended) or Windows console)\n    - `</path/to/python-3.7/installation/Scripts/pipenv install`\n    - `pipenv shell`\n    - `pip install orchid-python-api`\n        \n## Venv\n\n- Create a directory to host all your virtual environments. A good choice is \n`</path/to/user/directory/.virtualenvs>`. In subsequent steps, I will use the directory, \n`</path/to/user/directory/.virtualenvs/orchid-python-api>`, to hold my virtual environment.\n- Create virtual environment (using Powershell (recommended) or Windows console)\n    - Create an empty virtual environment\n        - `</path/to/python-3.7/installation/python -m venv </path/to/user/directory/.virtualenvs/orchid-python-api>`\n    - Activate the virtual environment\n        - `</path/to/user/directory/.virtualenvs/orchid-python-api/bin/Activate.ps1>` in Powershell or\n        - `</path/to/user/directory/.virtualenvs/orchid-python-api/bin/Activate.bat>` in Windows console\n    - Install orchid-python-api\n        - `pip install orchid-python-api`\n        \n### Poetry\n\n- Create a an empty virtual environment (using Powershell (recommended) or Windows console) by executing,\n    `poetry env use /c/Users/larry.jones/AppData/Local/Programs/Python/Python37/python`\n- Install packages into the empty virtual environment\n    - `poetry shell`\n    - `pip install orchid-python-api`\n\n## Development Overview\n\nTo understand the structure of the code, the [development README](./docs_dev/README.md) contains an overview of \nthe application / package design.\n\n## Development\n\nTo avoid "contamination" of other python environments, we use [pipenv](https://pipenv.pypa.io/en/stable/) to manage our\ndevelopment (and target) environment. (See this [tutorial](https://realpython.com/pipenv-guide/) for a gentler\nintroduction to using `pipenv`.)\n\n### Install Python\n\nTo use `pipenv`, you\'ll may need to perform up to three steps. First, if you do not have python **3** installed, you\'ll need to\ninstall it. To determine if python 3 is installed:\n\n- In the Windows 10, search bar, type "add or remove programs".\n- On the "Apps & features" page, search for "python"\n\nIf you see an item named "Python 3.x", you have python 3 installed.\n\nIf Python is not installed, follow [these instructions](https://docs.python.org/3/using/windows.html). To ensure access\nfrom the command line, be sure to select the "Add Python 3.x to PATH" option on the [installer start\npage](https://docs.python.org/3/_images/win_installer.png). \n\n### Ensure Command Line Access To Python\n\nAlthough you may be able perform development without command line access using, for example, `PyCharm`, many\ninstructions, including these instructions, will assume command line access. To verify command line access:\n\n- Open a command prompt\n- Type the command `python -V`\n\nYou should see a result like "Python 3.x".\n\n### Install Pipenv\n\nTo install `pipenv`:\n\n- Open a command prompt\n- Invoke the command `pip install pipenv`.\n\nThis will install the `pipenv` package in your system python installation. (Note that python 3.x, by default, installs\n`pip`. And if Python is available from the command line, `pip` will also be available from the command line.)\n\n### Create development environment\n\nTo create the development environment using `pipenv`:\n\n- Clone the `PyhonApi` repository into a directory on your workstation. For convenience, we\'ll call that directory\n  `$PYTHON_API_ROOT`.\n- Open a command prompt\n- Navigate to the `$PYTHON_API_ROOT`directory by executing `cd $PYTHON_API_ROOT`\n- Execute the command `pipenv install --ignore-pipfile`\n\nFor an explanation of this last command, see either the [reference documentation](https://pipenv.pypa.io/en/stable/) or\nthe [tutorial](https://realpython.com/pipenv-guide/).\n\nWait patiently. This command will install **both** the run-time and development-time packages to support changing and\nrunning in your local, development environment.\n\n#### Alternative development environments\n\nMany people, including this author, use an IDE for python development. It is not necessary, but provides a number of\nconveniences for development.\n\nTo use [PyCharm](https://www.jetbrains.com/pycharm/) from [JetBrains](https://www.jetbrains.com/):\n\n- Start `PyCharm`\n- Select `Open an existing project`.\n- Select the `$PYTHON_API_ROOT` directory\n\n(I believe it will detect your `Pipfile` / `Pipfile.lock` and use that to configure the project settings correctly.)\n\nTo use Visual Studio, a recommended tool is [Python Tools for Visual\nStudio](https://visualstudio.microsoft.com/vs/features/python/). The author assumes you are familiar with (or will\nbecome familiar with) this tool and its capabilities.\n\nIf you prefer a "lighter" development environment, consider [Visual Studio\nCode](https://code.visualstudio.com/docs/languages/python). Again, the author assumes you are familiar with (or will\nbecome familiar) with this tool and its capabilities.\n\nFinally, many, many, many other tools exist to support Python ranging from "editors" (Emacs and Vim) to tools like Atom\nand Sublime. You can most likely use whatever editing environment you are familiar with (or, like me, more than one).\nRemember the recommendation from the book, _The Pragmatic Programmer_: "Find one editor and stick to it."\n\n# Build and Test Locally\n\nTODO: Describe and show how to build your code and run the tests. \n\n# Contribute\n\nTo contribute to this project, follow our typical development process:\n\n- Clone this repository using [HTTPS](https://github.com/Reveal-Energy-Services/orchid-python-api.git) or\n  [SSH](git@github.com:Reveal-Energy-Services/orchid-python-api.git)\n- Create a branch for you work typically branching from `develop`\n- Make changes on your branch\n- Push your branch to the Azure DevOps repository\n- Create a pull request to have have others review your branch\n- When approved, complete your pull request to merge you work onto `develop`\n\nAlthough not yet enforced, any changes will need to pass all unit tests and any integration tests that are part of the\nproject before the pull request can be completed.\n',
    'author': 'Reveal Energy Services, Inc.',
    'author_email': 'support@reveal-energy.com',
    'maintainer': 'Reveal Energy Services, Inc.',
    'maintainer_email': 'support@reveal-energy.com',
    'url': 'https://github.com/Reveal-Energy-Services/orchid-python-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
