# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['orchid_python_api']

package_data = \
{'': ['*'], 'orchid_python_api': ['examples/*']}

install_requires = \
['deal==3.9.0',
 'matplotlib==3.3.0',
 'numpy==1.19.0',
 'pandas==1.0.5',
 'python-dateutil==2.8.1',
 'pythonnet==2.5.1',
 'pyyaml==5.3.1',
 'seaborn==0.10.1',
 'toolz==0.10.0',
 'typing-extensions==3.7.4.2']

entry_points = \
{'console_scripts': ['copy_orchid_examples = copy_orchid_examples:main']}

setup_kwargs = {
    'name': 'orchid-python-api',
    'version': '2020.4.361',
    'description': 'Defines and implements the Python API for Orchid*. (*Orchid is a mark of Reveal Energy Services, Inc.)',
    'long_description': '# Introduction \n\nThis project defines the implementation of the Python API for Orchid*.\n\n(*Orchid in a mark of Revel Energy Services. Inc.)\n\nSpecifically, the `orchid` package exposes the Orchid API to Python applications and to the Python REPL.\n\n# Getting Started\n\n## Create a virtual environment\n\n# Examples\n\nAdditionally, this project installs four examples in the `examples` directory of the `orchid-python-api`\npackage:\n\n- `plot_trajectories.ipynb`\n- `plot_monitor_curves.ipynb`\n- `plot_treatment.ipynb`\n- `completion_analysis.ipynb`\n\nThe first three notebooks plot:\n\n- The well trajectories for a project\n- The monitor curves for a project\n- The treatment curves (pressure, slurry rate and concentration) for a specific stage of a well in a project\n \nAdditionally, the notebook, `completion_analysis.ipynb`, provides a more detailed analysis of the completion\nperformed on two different wells in a project.\n \nTo use these examples: \n\n- You may need to \n  [configure the Orchid Python API to find the Orchid installation](#configure-the-orchid-python-api)\n- You **must** \n  [configure the Orchid Python API to find the Orchid training data](#configure-the-orchid-training-data)\n- You may want to invoke the command, `copy_orchid_examples`\n\n    This command copies the example files into an optionally specified (virtual environment) directory. (The \n    default destination is your current working directory.) Note that this command is a command-line script \n    that runs in a console or terminal. Additionally, this command supports a help flag (`-h` / `--help`) to \n    provide you with help on running this command.\n\n## End-user preparation\n\nWe recommend the use of virtual environments to use the Orchid Python API. This choice avoids putting \nOrchid-specific packages in your system Python environment.\n\nYou have several options to create and manage virtual environments: `venv`, `pipenv`, `poetry`, and `conda`.\nThe `venv ` is available as a standard Python package and is a spartan tool to manage environments. `poetry`\nis a tool targeting developers but can be used by end-users. Our recommended tool is `pipenv`. It provides a \ngood balance between `venv ` and `poetry`. Remember, both `pipenv` and `poetry` must be installed in your \nPython environment separately from Python itself, but can be installed using `pip`. Finally, `conda` supports \nthe creation of virtual environments, but assumes that you have installed a Python distribution using Anaconda\nor miniconda. We will not describe `conda` further.\n\nUsing any of `pipenv`, `venv` or `poetry`, your first step is to create a directory for *your* project. Then, \nchange into *your* project directory.\n\nWe recommend the use of `pipenv`. This environment hides a number of details involved in managing a virtualenv\nand yet provides a fairly simple interface. We will assume in this document that you are using `pipenv`.\n\n# Step-by-step install\n\n- Install python 3.7 by following [these instructions](https://docs.python.org/3/using/windows.html). To \n  ensure access from the command line, be sure to select the "Add Python 3.x to PATH" option on the\n  [installer start page](https://docs.python.org/3/_images/win_installer.png). \n- Installing `pipenv` by following the \n  [install documentation](https://pipenv.pypa.io/en/latest/install/#installing-pipenv).\n- Open a console using either `powershell` or the Windows console.\n- Create a directory for the virtual environment. We will symbolically call it `/path/to/orchid-virtualenv`.\n- Change the current working directory to by `chdir /path/to/orchid-virtualenv`.\n- Create an empty virtual environment by running `pipenv install`.\n- Activate the virtual environment by running `pipenv shell`\n- Install orchid by running `pip install orchid-python-api`.\n- Optionally install jupyter lab or jupyter notebook if you wish to use these tools to explore.\n\n## Configure the Orchid Python API\n\nThe Orchid Python API requires a licensed Orchid installation on your workstation. Depending on the details of\nthe installation, you may need to configure the Orchid Python API to refer to different locations.\n\n### Using the fallback configuration\n\nIf you installed the latest version Orchid using the installation defaults and you installed the \n`orchid-python-api` , you need to take **no** additional steps to configure the Orchid Python API to find this\ninstallation. For your information, the default installation location is,\n`%ProgramFiles%\\Reveal Energy Services, Inc\\Orchid`. The Orchid Python API uses its version to find and use\nthe corresponding version of Orchid.\n\n### Using an environment variable\n\nThis mechanism is perhaps the easiest procedure to create an Orchid Python API configuration that changes \nrarely and is available to all your tools. It works best with a system restart. (Environment variables can be \nmade available for a narrow set of tools on your system or available to all your tools depending on arcane\ntechnical rules that you need not understand.) \n\nTo use environment variables to configure the Orchid Python API, you will need to create the environment \nvariable `ORCHID_ROOT` and set its value to the root Orchid installation directory. (For your information, the\nversion-specific Orchid binary files, `.exe`\'s and `.dll`\'s should be in a subdirectory of `ORCHID_ROOT` \nwith a name like `Orchid-2020.4.232`.) \n\nThis document assumes you want to create a long-term configuration that survives a system restart and is \navailable to all your tools. Symbolically, this document will refer to the root of the Orchid installation as\n`/path/to/orchid-installation`. \n\nTo create the required environment variable, enter the search term "environment variables" in the Windows-10 \nsearch box and select the item named, "Edit environment variables for your account." The system will then \npresent your with the "Environment Variables" dialog. Under the section named "User variables for \n<your.username>", click the "New" button. In the "Variable name" text box, enter "ORCHID_ROOT". (These two \nwords are separated by the underscore, (_) symbol.)\n\nNavigate to the "Variable Value" text box. Click the "Browse Directory" button to select the directory into \nwhich Orchid is installed, `/path/to/orchid-installation`. This action pastes the directory name into the \n"Variable Value" text box. Verify that the directory is correct and the click "OK". Verify that you see the \nname `ORCHID_ROOT` with the correct value in the "User variables for <your.username>" list. Finally, click \n"OK" to dismiss the "Environment Variables" dialog.\n\nAlthough you have now created the `ORCHID_ROOT` environment variable with the appropriate value, only "new" \ntools can now use that variable. However, the details of "new" is technical and may not correspond to your \nwhat you expect. If you understand these details, you can jump to [Verify Installation](#verify-installation).\nIf you are not confident of these details, restart your system before proceeding to \n[Verify Installation](#verify-installation).\n\n### Using an configuration file\n\nAnother option to configure the Orchid Python API is by creating a configuration file. A configuration file is\neasier to change than an environment variable and does not require a system restart to work best. However, it\nrequires more knowledge and work on your part. In general, a configuration file is better if your requirements\nchange "often". For example, if you are working with multiple, side-by-side Orchid versions and Orchid Python \nAPI versions, you may find it faster and easier to create a configuration file once and change it as you \nchange Orchid / Orchid Python API versions.\n\nTo create a configuration file used by the Orchid Python API, you create a file named `python_api.yaml`\nand put it in the directory, `/path/to/home-directory/.orchid`, where `/path/to/home-directory` is a \nsymbolic reference to your home directory. Technically, the format of the file is `YAML` ("YAML Ain\'t Markup\nLanguage"), a "human friendly data serialization standard". (For technical details, visit \n[the website](https://yaml.org/). For a gentler introduction, visit \n[the Wikipedia entry](https://en.wikipedia.org/wiki/YAML) or read / watch on of the many `YAML` \nintroductions / tutorials.)\n\nBecause these articles describe `YAML` generally, they **do not** describe the details of the `YAML` document\nexpected by the Orchid Python API. We, however, distribute an example file name `python_api.yaml.example` in \neach installed `orchid-python-api` package. Assuming you created a virtual environment as described in \n[Step-by step install](#step-by-step-install), you can find this example file, `python_api.yaml.example`, in\nthe directory, `/path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples`. \n\nTo use this configuration file as an example:\n\n- Copy the file to the expected location. For example, assuming the symbolic names referenced above, execute\n  `copy /path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples/python_api.yaml.example\n   /path/to/home-directory/.orchid/python_api.yaml`\n- Edit the copied file, `/path/to/home-directory/.orchid/python_api.yaml`, using your favorite **text** editor.\n\nThe example file, contains comments, introduced by a leading octothorpe character (#, number sign, or hash), \nthat describe the information expected by the Orchid Python API. In summary, you\'ll need to provide a value\nfor the \'orchid\' > \'root\' key that contains the pathname of the directory containing the Orchid binaries\ncorresponding to the installed version of the `orchid-python-api` package.\n\n## Configure the Orchid training data\n\nThe Orchid Python API **requires** a licensed Orchid installation on your workstation. However, configuring\nthe Orchid Python API to find the Orchid training data is only needed to run the example Jupyter notebooks.\n\n### Using an environment variable\n\nThis mechanism is perhaps the easiest procedure to create an Orchid Python API configuration that changes \nrarely and is available to all your tools. It works best with a system restart. (Environment variables can be \nmade available for a narrow set of tools on your system or available to all your tools depending on arcane\ntechnical rules that you need not understand.) \n\nTo use environment variables to configure the Orchid Python API to find the Orchid training data, you will \nneed to create the environment variable `ORCHID_TRAINING_DATA` and set its value to the location of the Orchid \ntraining data.\n\nThis document assumes you want to create a long-term configuration that survives a system restart and is \navailable to all your tools. Symbolically, this document will refer to the Orchid training data location as\n`/path-to/orchid/training-data`. \n\nTo create the required environment variable, enter the search term "environment variables" in the Windows-10 \nsearch box and select the item named, "Edit environment variables for your account." The system will then \npresent your with the "Environment Variables" dialog. Under the section named "User variables for \n<your.username>", click the "New" button. In the "Variable name" text box, enter "ORCHID_TRAINING_DATA".\n(These two words are separated by the underscore, (_) symbol.)\n\nNavigate to the "Variable Value" text box. Click the "Browse Directory" button to select the directory \ncontaining the Orchid training data, `/path-to/orchid/training-data`. This action pastes the directory name\n into the "Variable Value" text box. Verify that the directory is correct and the click "OK". Verify that you\nsee the name `ORCHID_TRAINING_DATA` with the correct value in the "User variables for <your.username>" list. \nFinally, click "OK" to dismiss the "Environment Variables" dialog.\n\nAlthough you have now created the `ORCHID_ROOT` environment variable with the appropriate value, only "new"\ntools can now use that variable. However, the details of "new" is technical and may not correspond to your \nwhat you expect. If you understand these details, you can jump to [Verify Installation](#verify-installation).\nIf you are not confident of these details, restart your system before proceeding to \n[Verify Installation](#verify-installation).\n\n### Using an configuration file\n\nAnother option to configure the Orchid Python API to find the Orchid training data is by creating a \nconfiguration file. A configuration file is easier to change than an environment variable and does not require \na system restart to work best. However, it requires more knowledge and work on your part. In general, a \nconfiguration file is better if your requirements change "often". For example, if you are working with \nmultiple, side-by-side Orchid versions and Orchid Python API versions, you may find it faster and easier to \ncreate a configuration file once and change it as you change Orchid / Orchid Python API versions.\n\nTo create a configuration file used by the Orchid Python API, you create a file named `python_api.yaml`\nand put it in the directory, `/path/to/home-directory/.orchid`, where `/path/to/home-directory` is a \nsymbolic reference to your home directory. Technically, the format of the file is `YAML` ("YAML Ain\'t Markup\nLanguage"), a "human friendly data serialization standard". (For technical details, visit \n[the website](https://yaml.org/). For a gentler introduction, visit \n[the Wikipedia entry](https://en.wikipedia.org/wiki/YAML) or read / watch on of the many `YAML` \nintroductions / tutorials.)\n\nBecause these articles describe `YAML` generally, they **do not** describe the details of the `YAML` document\nexpected by the Orchid Python API. We, however, distribute an example file name `python_api.yaml.example` in \neach installed `orchid-python-api` package. Assuming you created a virtual environment as described in \n[Step-by step install](#step-by-step-install), you can find this example file, `python_api.yaml.example`, in\nthe directory, `/path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples`. \n\nTo use this configuration file as an example:\n\n- Copy the file to the expected location. For example, assuming the symbolic names referenced above, execute\n  `copy /path/to/orchid-virtualenv/Lib/site-packages/orchid_python_api/examples/python_api.yaml.example\n   /path/to/home-directory/.orchid/python_api.yaml`\n- Edit the copied file, `/path/to/home-directory/.orchid/python_api.yaml`, using your favorite **text** editor.\n\nThe example file, contains comments, introduced by a leading octothorpe character (#, number sign, or hash), \nthat describe the information expected by the Orchid Python API. In summary, you\'ll need to provide a value\nfor the \'orchid\' > \'training_data\' key that contains the pathname of the directory containing the Orchid \nbinaries corresponding to the installed version of the `orchid-python-api` package.\n\n# Verify installation\n\n## Jupyter lab\n\n- In your activated virtual environment, run `jupyter lab` to open a browser tab.\n- In the first cell, enter `import orchid`.\n- Run the cell.\n- Wait patiently.\n\nThe import should complete with no errors.\n\n## Python REPL\n\n- In your activated virtual environment, run `python` to open a REPL.\n- Enter `import orchid`.\n- Wait patiently.\n\nThe import should complete with no errors.\n\n# Run orchid examples\n\n- Navigate to the directory associated with the virtual environment\n- Run `python </path/to/virtualenv/Lib/site-packages/copy_orchid_examples.py`\n- If the script reports that it skipped notebooks, repeat the command with an additional argument:  \n  `python </path/to/virtualenv/Lib/site-packages/copy_orchid_examples.py --overwrite`\n- Verify that the current directory has four notebooks:\n    - `plot_trajectories.ipynb`\n    - `plot_monitor_curves.ipynb`\n    - `plot_treatment.ipynb`\n    - `completion_analysis.ipynb`\n- The notebooks, as installed, "symbolically" reference the Orchid training data. To resolve this "symbolic\n  reference", \n  [configure the Orchid Python API to find the Orchid training data](#configure-the-orchid-training-data).\n- Activate your virtual environment by `pipenv shell` if not already activated\n- Open Jupyter by running `jupyter lab` in the shell\n- Within Jupyter,\n    Run the notebook, `plot_trajectories.ipynb`\n        1. Open notebook\n        2. Run all cells of notebook\n        3. Wait patiently\n        4. Verify that no exceptions occurred\n    - Repeat for remaining notebooks:\n        - `plot_monitor_curves.ipynb`\n        - `plot_treatment.ipynb`\n        - `completion_analysis.ipynb`\n',
    'author': 'Reveal Energy Services, Inc.',
    'author_email': 'support@reveal-energy.com',
    'maintainer': 'Reveal Energy Services, Inc.',
    'maintainer_email': 'support@reveal-energy.com',
    'url': 'https://github.com/Reveal-Energy-Services/orchid-python-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
