#  Copyright (c) 2017-2025 KAPPA
#
#  Licensed under the Apache License, Version 2.0 (the "License"); 
#  you may not use this file except in compliance with the License. 
#  You may obtain a copy of the License at 
#
#      http://www.apache.org/licenses/LICENSE-2.0 
#
#  Unless required by applicable law or agreed to in writing, software 
#  distributed under the License is distributed on an "AS IS" BASIS, 
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
#  See the License for the specific language governing permissions and 
#  limitations under the License. 
#
# This file is part of Orchid and related technologies.
#


# Load the appropriate runtime **before** executing `import clr`
import pythonnet
pythonnet.load('coreclr')

from .dot_net import prepare_imports
prepare_imports()

# High-level API
from .core import load_project, save_project, optimized_but_possibly_unsafe_save

# Helpful constants
from .native_treatment_curve_adapter import TreatmentCurveTypes
from .native_time_series_adapter import TimeSeriesCurveTypes
from .net_date_time import UTC

# Helpful functions
from .convert import to_unit
from .measurement import registry as unit_registry
from .native_treatment_calculations import (median_treating_pressure, pumped_fluid_volume, total_proppant_mass)
from .reference_origins import WellReferenceFrameXy
from .unit_system import abbreviation, make_measurement

# Only for training data
from .configuration import training_data_path
