from __future__ import annotations
import abc
from typing import Any, Iterable, TYPE_CHECKING

if TYPE_CHECKING:
    from ormlambda import ColumnProxy


class IAggregate():
    alias: str

    def __repr__(self):
        return f"{IAggregate.__name__}: {type(self).__name__}"

    @abc.abstractmethod
    def used_columns(self) -> Iterable[ColumnProxy]: ...

    @property
    @abc.abstractmethod
    def dtype(self) -> Any: ...
