"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from orq_poc_python_client.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import NotRequired, TypedDict


PromptTypedDict = Union[str, List[Any]]
r"""The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays."""


Prompt = Union[str, List[Any]]
r"""The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays."""


StopTypedDict = Union[str, List[str]]
r"""Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence."""


Stop = Union[str, List[str]]
r"""Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence."""


class PostV2RouterCompletionsRequestBodyTypedDict(TypedDict):
    r"""A request body that follows the official OpenAI schema"""

    model: str
    r"""ID of the model to use"""
    prompt: PromptTypedDict
    r"""The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays."""
    echo: NotRequired[Nullable[bool]]
    r"""Echo back the prompt in addition to the completion"""
    frequency_penalty: NotRequired[Nullable[float]]
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim."""
    max_tokens: NotRequired[Nullable[float]]
    r"""The maximum number of tokens that can be generated in the completion."""
    presence_penalty: NotRequired[Nullable[float]]
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics."""
    seed: NotRequired[Nullable[float]]
    r"""If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result."""
    stop: NotRequired[Nullable[StopTypedDict]]
    r"""Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence."""
    stream: NotRequired[Nullable[bool]]
    r"""Whether to stream back partial progress."""
    temperature: NotRequired[Nullable[float]]
    r"""What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic."""
    top_p: NotRequired[Nullable[float]]
    r"""An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered."""
    user: NotRequired[str]
    r"""A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse."""


class PostV2RouterCompletionsRequestBody(BaseModel):
    r"""A request body that follows the official OpenAI schema"""

    model: str
    r"""ID of the model to use"""

    prompt: Prompt
    r"""The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays."""

    echo: OptionalNullable[bool] = False
    r"""Echo back the prompt in addition to the completion"""

    frequency_penalty: OptionalNullable[float] = 0
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim."""

    max_tokens: OptionalNullable[float] = 16
    r"""The maximum number of tokens that can be generated in the completion."""

    presence_penalty: OptionalNullable[float] = 0
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics."""

    seed: OptionalNullable[float] = UNSET
    r"""If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result."""

    stop: OptionalNullable[Stop] = UNSET
    r"""Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence."""

    stream: OptionalNullable[bool] = False
    r"""Whether to stream back partial progress."""

    temperature: OptionalNullable[float] = 1
    r"""What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic."""

    top_p: OptionalNullable[float] = 1
    r"""An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered."""

    user: Optional[str] = None
    r"""A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "echo",
            "frequency_penalty",
            "max_tokens",
            "presence_penalty",
            "seed",
            "stop",
            "stream",
            "temperature",
            "top_p",
            "user",
        ]
        nullable_fields = [
            "echo",
            "frequency_penalty",
            "max_tokens",
            "presence_penalty",
            "seed",
            "stop",
            "stream",
            "temperature",
            "top_p",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FinishReason(str, Enum):
    r"""The reason the model stopped generating tokens."""

    STOP = "stop"
    LENGTH = "length"
    CONTENT_FILTER = "content_filter"
    TOOL_CALLS = "tool_calls"


class PostV2RouterCompletionsChoicesTypedDict(TypedDict):
    finish_reason: FinishReason
    r"""The reason the model stopped generating tokens."""
    index: float
    r"""The index of the choice in the list of choices."""
    text: str


class PostV2RouterCompletionsChoices(BaseModel):
    finish_reason: FinishReason
    r"""The reason the model stopped generating tokens."""

    index: float
    r"""The index of the choice in the list of choices."""

    text: str


class PostV2RouterCompletionsUsageTypedDict(TypedDict):
    r"""Usage statistics for the completion request."""

    completion_tokens: NotRequired[float]
    r"""Number of tokens in the generated completion."""
    prompt_tokens: NotRequired[float]
    r"""Number of tokens in the prompt."""
    total_tokens: NotRequired[float]
    r"""Total number of tokens used in the request (prompt + completion)."""


class PostV2RouterCompletionsUsage(BaseModel):
    r"""Usage statistics for the completion request."""

    completion_tokens: Optional[float] = None
    r"""Number of tokens in the generated completion."""

    prompt_tokens: Optional[float] = None
    r"""Number of tokens in the prompt."""

    total_tokens: Optional[float] = None
    r"""Total number of tokens used in the request (prompt + completion)."""


class PostV2RouterCompletionsResponseBodyTypedDict(TypedDict):
    r"""A response body that follows the official OpenAI schema"""

    id: str
    r"""A unique identifier for the completion."""
    choices: List[PostV2RouterCompletionsChoicesTypedDict]
    r"""The list of completion choices the model generated for the input prompt."""
    created: float
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""
    model: str
    r"""The model used for the chat completion."""
    system_fingerprint: str
    r"""This fingerprint represents the backend configuration that the model runs with."""
    object: str
    r"""The object type"""
    usage: PostV2RouterCompletionsUsageTypedDict
    r"""Usage statistics for the completion request."""


class PostV2RouterCompletionsResponseBody(BaseModel):
    r"""A response body that follows the official OpenAI schema"""

    id: str
    r"""A unique identifier for the completion."""

    choices: List[PostV2RouterCompletionsChoices]
    r"""The list of completion choices the model generated for the input prompt."""

    created: float
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""

    model: str
    r"""The model used for the chat completion."""

    system_fingerprint: str
    r"""This fingerprint represents the backend configuration that the model runs with."""

    object: str
    r"""The object type"""

    usage: PostV2RouterCompletionsUsage
    r"""Usage statistics for the completion request."""
