"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from orq_poc_python_client.types import BaseModel
from typing import List, Optional, Union
from typing_extensions import NotRequired, TypedDict


InputTypedDict = Union[str, List[str]]
r"""Input text to embed, encoded as a string or array of tokens."""


Input = Union[str, List[str]]
r"""Input text to embed, encoded as a string or array of tokens."""


class EncodingFormat(str, Enum):
    r"""Type of the document element"""

    BASE64 = "base64"
    FLOAT = "float"


class PostV2RouterEmbeddingsRequestBodyTypedDict(TypedDict):
    input: InputTypedDict
    r"""Input text to embed, encoded as a string or array of tokens."""
    model: str
    r"""ID of the model to use"""
    encoding_format: NotRequired[EncodingFormat]
    r"""Type of the document element"""
    dimensions: NotRequired[float]
    r"""The number of dimensions the resulting output embeddings should have."""
    user: NotRequired[str]
    r"""A unique identifier representing your end-user"""


class PostV2RouterEmbeddingsRequestBody(BaseModel):
    input: Input
    r"""Input text to embed, encoded as a string or array of tokens."""

    model: str
    r"""ID of the model to use"""

    encoding_format: Optional[EncodingFormat] = EncodingFormat.FLOAT
    r"""Type of the document element"""

    dimensions: Optional[float] = None
    r"""The number of dimensions the resulting output embeddings should have."""

    user: Optional[str] = None
    r"""A unique identifier representing your end-user"""


class PostV2RouterEmbeddingsObject(str, Enum):
    LIST = "list"


class PostV2RouterEmbeddingsRouterEmbeddingsObject(str, Enum):
    r"""The object type, which is always \"embedding\"."""

    EMBEDDING = "embedding"


EmbeddingTypedDict = Union[List[float], str]
r"""The embedding result."""


Embedding = Union[List[float], str]
r"""The embedding result."""


class PostV2RouterEmbeddingsDataTypedDict(TypedDict):
    object: PostV2RouterEmbeddingsRouterEmbeddingsObject
    r"""The object type, which is always \"embedding\"."""
    embedding: EmbeddingTypedDict
    r"""The embedding result."""
    index: float
    r"""The index of the embedding in the list of embeddings."""


class PostV2RouterEmbeddingsData(BaseModel):
    object: PostV2RouterEmbeddingsRouterEmbeddingsObject
    r"""The object type, which is always \"embedding\"."""

    embedding: Embedding
    r"""The embedding result."""

    index: float
    r"""The index of the embedding in the list of embeddings."""


class PostV2RouterEmbeddingsUsageTypedDict(TypedDict):
    prompt_tokens: float
    total_tokens: float


class PostV2RouterEmbeddingsUsage(BaseModel):
    prompt_tokens: float

    total_tokens: float


class PostV2RouterEmbeddingsResponseBodyTypedDict(TypedDict):
    r"""Embeddings created"""

    object: PostV2RouterEmbeddingsObject
    data: List[PostV2RouterEmbeddingsDataTypedDict]
    model: str
    r"""ID of the model to use"""
    usage: PostV2RouterEmbeddingsUsageTypedDict


class PostV2RouterEmbeddingsResponseBody(BaseModel):
    r"""Embeddings created"""

    object: PostV2RouterEmbeddingsObject

    data: List[PostV2RouterEmbeddingsData]

    model: str
    r"""ID of the model to use"""

    usage: PostV2RouterEmbeddingsUsage
