"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from enum import Enum
from orq_poc_python_client import models, utils
from orq_poc_python_client._hooks import HookContext
from orq_poc_python_client.types import BaseModel, OptionalNullable, UNSET
from orq_poc_python_client.utils import eventstreaming, get_security_from_env
from typing import Optional, Union, cast


class CreateAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_EVENT_STREAM = "text/event-stream"


class OrqCompletions(BaseSDK):
    def create(
        self,
        *,
        request: Union[
            models.PostV2RouterChatCompletionsRequestBody,
            models.PostV2RouterChatCompletionsRequestBodyTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[CreateAcceptEnum] = None,
    ) -> models.PostV2RouterChatCompletionsResponse:
        r"""Chat

        For sending requests to chat completion models

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, models.PostV2RouterChatCompletionsRequestBody
            )
        request = cast(models.PostV2RouterChatCompletionsRequestBody, request)

        req = self.build_request(
            method="POST",
            path="/v2/router/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/event-stream;q=0",
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.PostV2RouterChatCompletionsRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                operation_id="post_/v2/router/chat/completions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            http_response_text = utils.stream_to_text(http_res)
            return utils.unmarshal_json(
                http_response_text, models.PostV2RouterChatCompletionsResponseBody
            )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.stream_events(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw,
                    models.PostV2RouterChatCompletionsRouterChatCompletionsResponseBody,
                ),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        request: Union[
            models.PostV2RouterChatCompletionsRequestBody,
            models.PostV2RouterChatCompletionsRequestBodyTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        accept_header_override: Optional[CreateAcceptEnum] = None,
    ) -> models.PostV2RouterChatCompletionsResponse:
        r"""Chat

        For sending requests to chat completion models

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 600000

        if server_url is not None:
            base_url = server_url

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(
                request, models.PostV2RouterChatCompletionsRequestBody
            )
        request = cast(models.PostV2RouterChatCompletionsRequestBody, request)

        req = self.build_request_async(
            method="POST",
            path="/v2/router/chat/completions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value=accept_header_override.value
            if accept_header_override is not None
            else "application/json;q=1, text/event-stream;q=0",
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.PostV2RouterChatCompletionsRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                operation_id="post_/v2/router/chat/completions",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            stream=True,
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            http_response_text = await utils.stream_to_text_async(http_res)
            return utils.unmarshal_json(
                http_response_text, models.PostV2RouterChatCompletionsResponseBody
            )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.stream_events_async(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw,
                    models.PostV2RouterChatCompletionsRouterChatCompletionsResponseBody,
                ),
                sentinel="[DONE]",
            )
        if utils.match_response(http_res, ["4XX", "5XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
