"""
server settings for mysite project.

Generated by 'server-admin startproject' using server 2.1.7.

For more information on this file, see
https://docs.serverproject.com/en/2.1/topics/settings/

For the full list of settings and their values, see
https://docs.serverproject.com/en/2.1/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.serverproject.com/en/2.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '12o+p(rp2n4e0)kn%!(r%57scc3#h0p5j_(p9hm!)j=gd0_wo7'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

ALLOWED_HOSTS = ['localhost', 'http://127.0.0.1', 'http://127.0.0.1:8000/', '127.0.0.1']


# Application definition

INSTALLED_APPS = [
    'polls.apps.PollsConfig',
    'server.contrib.admin',
    'server.contrib.auth',
    'server.contrib.contenttypes',
    'server.contrib.sessions',
    'server.contrib.messages',
    'server.contrib.staticfiles',
]

MIDDLEWARE = [
    'server.middleware.security.SecurityMiddleware',
    'server.contrib.sessions.middleware.SessionMiddleware',
    'server.middleware.common.CommonMiddleware',
    'server.middleware.csrf.CsrfViewMiddleware',
    'server.contrib.auth.middleware.AuthenticationMiddleware',
    'server.contrib.messages.middleware.MessageMiddleware',
    'server.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'mysite.urls'

TEMPLATES = [
    {
        'BACKEND': 'server.template.backends.server.serverTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'server.template.context_processors.debug',
                'server.template.context_processors.request',
                'server.contrib.auth.context_processors.auth',
                'server.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'mysite.wsgi.application'


# Database
# https://docs.serverproject.com/en/2.1/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'server.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}


# Password validation
# https://docs.serverproject.com/en/2.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'server.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'server.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'server.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'server.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.serverproject.com/en/2.1/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'CET'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.serverproject.com/en/2.1/howto/static-files/

STATIC_URL = '/data/'
