# Ostium Python SDK

A python based SDK developed for interacting with Ostium v1 Trading Platform (https://ostium.app/)

Ostium is a decentralized perpetuals exchange on Arbitrum (Ethereum L2) with a focus on providing a seamless experience for traders for trading currencies, commodities, indices, crypto and more.

This SDK is designed to be used by developers who want to build applications on top of Ostium and automate their trading strategies.


## Pip Install

The SDK can be installed via pip:

```bash
pip install ostium-python-sdk
```

## Requirements

Developed using:
```python
  python=3.8
```

## Usage Example

### Opening a Trade
```python
from ostium_python_sdk import OstiumSDK
from dotenv import load_dotenv

# Load environment variables if using .env file
load_dotenv()

# Initialize SDK (using environment variables)
sdk = OstiumSDK(network="arbitrum")

# Or initialize with explicit private key
# sdk = OstiumSDK(
#     network="arbitrum",
#     private_key="your_private_key_here",
#     rpc_url="https://arb1.arbitrum.io/rpc"
# )

# Define trade parameters
trade_params = {
    'collateral': 100,        # USDC amount
    'leverage': 10,           # Leverage multiplier
    'asset_type': 0,         # 0 for BTC
    'direction': True,       # True for Long, False for Short
    'order_type': 'MARKET'   # 'MARKET', 'LIMIT', or 'STOP'
}

try:
    # Get latest price for BTC
    latest_price = sdk.ostium.get_latest_price(trade_params['asset_type'])
    
    # Execute trade at current market price
    receipt = sdk.ostium.perform_trade(trade_params, at_price=latest_price)
    print(f"Trade successful! Transaction hash: {receipt['transactionHash'].hex()}")
except Exception as e:
    print(f"Trade failed: {str(e)}")

## Example Usage Script


### Read Block Number

To run the example:

```bash
python examples/example-read-block-number.py
```

See [example-read-block-number.py](https://github.com/0xOstium/ostium_python_sdk/blob/main/examples/example-read-block-number.py) for an example of how to use the SDK.

### Read Positions

To run the example:

```bash
python examples/example-read-positions.py
```

See [example-read-positions.py](https://github.com/0xOstium/ostium_python_sdk/blob/main/examples/example-read-positions.py) for an example of how to use the SDK.


### Get Feed Prices

To open a trade you need the latest feed price. 

See this example script on how to get the latest feed prices.

```bash
python examples/example-get-prices.py
```

See [example-get-prices.py](https://github.com/0xOstium/ostium_python_sdk/blob/main/examples/example-get-prices.py) for an example of how to use the SDK.



### Get Balance of an Address



See this example script on how to get the latest feed prices.

```bash
python examples/example-get-balance.py
```

See [example-get-balance.py](https://github.com/0xOstium/ostium_python_sdk/blob/main/examples/example-get-balance.py) for an example of how to use the SDK.




