
# python wrapper for package gotdf_python within overall package gotdf_python
# This is what you import to use the package.
# File is generated by gopy. Do not edit.
# gopy build --output=otdf_python -vm=python3 .

# the following is required to enable dlopen to open the _go.so file
import os,sys,inspect,collections
try:
	import collections.abc as _collections_abc
except ImportError:
	_collections_abc = collections

cwd = os.getcwd()
currentdir = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
os.chdir(currentdir)
from . import _gotdf_python
from . import go

os.chdir(cwd)

# to use this code in your end-user python file, import it as follows:
# from gotdf_python import gotdf_python
# and then refer to everything using gotdf_python. prefix
# packages imported by this package listed below:




# ---- Types ---


#---- Enums from Go (collections of consts with same type) ---


#---- Constants from Go: Python can only ask that you please don't change these! ---


# ---- Global Variables: can only use functions to access ---


# ---- Interfaces ---


# ---- Structs ---

# Python type for struct gotdf_python.DecryptionConfig
class DecryptionConfig(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_gotdf_python.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_gotdf_python.IncRef(self.handle)
		else:
			self.handle = _gotdf_python.gotdf_python_DecryptionConfig_CTor()
			_gotdf_python.IncRef(self.handle)
			if  0 < len(args):
				self.ClientId = args[0]
			if "ClientId" in kwargs:
				self.ClientId = kwargs["ClientId"]
			if  1 < len(args):
				self.ClientSecret = args[1]
			if "ClientSecret" in kwargs:
				self.ClientSecret = kwargs["ClientSecret"]
			if  2 < len(args):
				self.PlatformEndpoint = args[2]
			if "PlatformEndpoint" in kwargs:
				self.PlatformEndpoint = kwargs["PlatformEndpoint"]
			if  3 < len(args):
				self.TokenEndpoint = args[3]
			if "TokenEndpoint" in kwargs:
				self.TokenEndpoint = kwargs["TokenEndpoint"]
			if  4 < len(args):
				self.KasUrl = args[4]
			if "KasUrl" in kwargs:
				self.KasUrl = kwargs["KasUrl"]
	def __del__(self):
		_gotdf_python.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'gotdf_python.DecryptionConfig{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'gotdf_python.DecryptionConfig ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def ClientId(self):
		return _gotdf_python.gotdf_python_DecryptionConfig_ClientId_Get(self.handle)
	@ClientId.setter
	def ClientId(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_DecryptionConfig_ClientId_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_DecryptionConfig_ClientId_Set(self.handle, value)
	@property
	def ClientSecret(self):
		return _gotdf_python.gotdf_python_DecryptionConfig_ClientSecret_Get(self.handle)
	@ClientSecret.setter
	def ClientSecret(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_DecryptionConfig_ClientSecret_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_DecryptionConfig_ClientSecret_Set(self.handle, value)
	@property
	def PlatformEndpoint(self):
		return _gotdf_python.gotdf_python_DecryptionConfig_PlatformEndpoint_Get(self.handle)
	@PlatformEndpoint.setter
	def PlatformEndpoint(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_DecryptionConfig_PlatformEndpoint_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_DecryptionConfig_PlatformEndpoint_Set(self.handle, value)
	@property
	def TokenEndpoint(self):
		return _gotdf_python.gotdf_python_DecryptionConfig_TokenEndpoint_Get(self.handle)
	@TokenEndpoint.setter
	def TokenEndpoint(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_DecryptionConfig_TokenEndpoint_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_DecryptionConfig_TokenEndpoint_Set(self.handle, value)
	@property
	def KasUrl(self):
		return _gotdf_python.gotdf_python_DecryptionConfig_KasUrl_Get(self.handle)
	@KasUrl.setter
	def KasUrl(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_DecryptionConfig_KasUrl_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_DecryptionConfig_KasUrl_Set(self.handle, value)

# Python type for struct gotdf_python.EncryptionConfig
class EncryptionConfig(go.GoClass):
	"""In a pure golang library, we'd probably embed\nthe 'DecryptionConfig' struct into the\n'EncryptionConfig' struct.  However, this makes\nusage from Python / Gopy difficult, so\nit's not worthwhile.\n"""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_gotdf_python.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_gotdf_python.IncRef(self.handle)
		else:
			self.handle = _gotdf_python.gotdf_python_EncryptionConfig_CTor()
			_gotdf_python.IncRef(self.handle)
			if  0 < len(args):
				self.ClientId = args[0]
			if "ClientId" in kwargs:
				self.ClientId = kwargs["ClientId"]
			if  1 < len(args):
				self.ClientSecret = args[1]
			if "ClientSecret" in kwargs:
				self.ClientSecret = kwargs["ClientSecret"]
			if  2 < len(args):
				self.PlatformEndpoint = args[2]
			if "PlatformEndpoint" in kwargs:
				self.PlatformEndpoint = kwargs["PlatformEndpoint"]
			if  3 < len(args):
				self.TokenEndpoint = args[3]
			if "TokenEndpoint" in kwargs:
				self.TokenEndpoint = kwargs["TokenEndpoint"]
			if  4 < len(args):
				self.KasUrl = args[4]
			if "KasUrl" in kwargs:
				self.KasUrl = kwargs["KasUrl"]
			if  5 < len(args):
				self.DataAttributes = args[5]
			if "DataAttributes" in kwargs:
				self.DataAttributes = kwargs["DataAttributes"]
	def __del__(self):
		_gotdf_python.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'gotdf_python.EncryptionConfig{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'gotdf_python.EncryptionConfig ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def ClientId(self):
		return _gotdf_python.gotdf_python_EncryptionConfig_ClientId_Get(self.handle)
	@ClientId.setter
	def ClientId(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_EncryptionConfig_ClientId_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_EncryptionConfig_ClientId_Set(self.handle, value)
	@property
	def ClientSecret(self):
		return _gotdf_python.gotdf_python_EncryptionConfig_ClientSecret_Get(self.handle)
	@ClientSecret.setter
	def ClientSecret(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_EncryptionConfig_ClientSecret_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_EncryptionConfig_ClientSecret_Set(self.handle, value)
	@property
	def PlatformEndpoint(self):
		return _gotdf_python.gotdf_python_EncryptionConfig_PlatformEndpoint_Get(self.handle)
	@PlatformEndpoint.setter
	def PlatformEndpoint(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_EncryptionConfig_PlatformEndpoint_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_EncryptionConfig_PlatformEndpoint_Set(self.handle, value)
	@property
	def TokenEndpoint(self):
		return _gotdf_python.gotdf_python_EncryptionConfig_TokenEndpoint_Get(self.handle)
	@TokenEndpoint.setter
	def TokenEndpoint(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_EncryptionConfig_TokenEndpoint_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_EncryptionConfig_TokenEndpoint_Set(self.handle, value)
	@property
	def KasUrl(self):
		return _gotdf_python.gotdf_python_EncryptionConfig_KasUrl_Get(self.handle)
	@KasUrl.setter
	def KasUrl(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_EncryptionConfig_KasUrl_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_EncryptionConfig_KasUrl_Set(self.handle, value)
	@property
	def DataAttributes(self):
		return go.Slice_string(handle=_gotdf_python.gotdf_python_EncryptionConfig_DataAttributes_Get(self.handle))
	@DataAttributes.setter
	def DataAttributes(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_EncryptionConfig_DataAttributes_Set(self.handle, value.handle)
		else:
			raise TypeError("supplied argument type {t} is not a go.GoClass".format(t=type(value)))

# Python type for struct gotdf_python.TokenAuth
class TokenAuth(go.GoClass):
	""""""
	def __init__(self, *args, **kwargs):
		"""
		handle=A Go-side object is always initialized with an explicit handle=arg
		otherwise parameters can be unnamed in order of field names or named fields
		in which case a new Go object is constructed first
		"""
		if len(kwargs) == 1 and 'handle' in kwargs:
			self.handle = kwargs['handle']
			_gotdf_python.IncRef(self.handle)
		elif len(args) == 1 and isinstance(args[0], go.GoClass):
			self.handle = args[0].handle
			_gotdf_python.IncRef(self.handle)
		else:
			self.handle = _gotdf_python.gotdf_python_TokenAuth_CTor()
			_gotdf_python.IncRef(self.handle)
			if  0 < len(args):
				self.AccessToken = args[0]
			if "AccessToken" in kwargs:
				self.AccessToken = kwargs["AccessToken"]
			if  1 < len(args):
				self.NpeClientId = args[1]
			if "NpeClientId" in kwargs:
				self.NpeClientId = kwargs["NpeClientId"]
	def __del__(self):
		_gotdf_python.DecRef(self.handle)
	def __str__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'gotdf_python.TokenAuth{'
		first = True
		for v in pr:
			if callable(v[1]):
				continue
			if first:
				first = False
			else:
				sv += ', '
			sv += v[0] + '=' + str(v[1])
		return sv + '}'
	def __repr__(self):
		pr = [(p, getattr(self, p)) for p in dir(self) if not p.startswith('__')]
		sv = 'gotdf_python.TokenAuth ( '
		for v in pr:
			if not callable(v[1]):
				sv += v[0] + '=' + str(v[1]) + ', '
		return sv + ')'
	@property
	def AccessToken(self):
		return _gotdf_python.gotdf_python_TokenAuth_AccessToken_Get(self.handle)
	@AccessToken.setter
	def AccessToken(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_TokenAuth_AccessToken_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_TokenAuth_AccessToken_Set(self.handle, value)
	@property
	def NpeClientId(self):
		return _gotdf_python.gotdf_python_TokenAuth_NpeClientId_Get(self.handle)
	@NpeClientId.setter
	def NpeClientId(self, value):
		if isinstance(value, go.GoClass):
			_gotdf_python.gotdf_python_TokenAuth_NpeClientId_Set(self.handle, value.handle)
		else:
			_gotdf_python.gotdf_python_TokenAuth_NpeClientId_Set(self.handle, value)


# ---- Slices ---


# ---- Maps ---


# ---- Constructors ---


# ---- Functions ---
def Hello():
	"""Hello() str
	
	A simple "Hello, world" function, used for learning golang (e.g. unit testing),
	as well as validating the necessary mechanisms to compile this library
	into a Python wheel.
	
	In the future, this function might be removed or replaced with a more
	conventional & useful function like GetVersion()
	"""
	return _gotdf_python.gotdf_python_Hello()
def DecryptFile(inputFilePath, outputFilePath, config):
	"""DecryptFile(str inputFilePath, str outputFilePath, object config) str, str"""
	return _gotdf_python.gotdf_python_DecryptFile(inputFilePath, outputFilePath, config.handle)
def DecryptFilePE(inputFilePath, outputFilePath, config, token):
	"""DecryptFilePE(str inputFilePath, str outputFilePath, object config, object token) str, str"""
	return _gotdf_python.gotdf_python_DecryptFilePE(inputFilePath, outputFilePath, config.handle, token.handle)
def DecryptStringPE(inputText, config, token):
	"""DecryptStringPE(str inputText, object config, object token) str, str"""
	return _gotdf_python.gotdf_python_DecryptStringPE(inputText, config.handle, token.handle)
def EncryptFile(inputFilePath, outputFilePath, config):
	"""EncryptFile(str inputFilePath, str outputFilePath, object config) str, str"""
	return _gotdf_python.gotdf_python_EncryptFile(inputFilePath, outputFilePath, config.handle)
def EncryptFilePE(inputFilePath, outputFilePath, config, token):
	"""EncryptFilePE(str inputFilePath, str outputFilePath, object config, object token) str, str
	
	Encrypts a file as a PE (Person Entity), returning a TDF manifest and the cipher text.
	"""
	return _gotdf_python.gotdf_python_EncryptFilePE(inputFilePath, outputFilePath, config.handle, token.handle)
def EncryptString(inputText, config):
	"""EncryptString(str inputText, object config) str, str"""
	return _gotdf_python.gotdf_python_EncryptString(inputText, config.handle)


