# -*- coding: utf-8 -*-
# Generated by https://github.com/connectrpc/connect-python.  DO NOT EDIT!
# source: authorization/authorization.proto

from collections.abc import AsyncGenerator, AsyncIterator, Iterable, Iterator, Mapping
from typing import Protocol

from connectrpc.client import ConnectClient, ConnectClientSync
from connectrpc.code import Code
from connectrpc.errors import ConnectError
from connectrpc.interceptor import Interceptor, InterceptorSync
from connectrpc.method import IdempotencyLevel, MethodInfo
from connectrpc.request import Headers, RequestContext
from connectrpc.server import ConnectASGIApplication, ConnectWSGIApplication, Endpoint, EndpointSync
from . import authorization_pb2 as authorization_dot_authorization__pb2


class AuthorizationService(Protocol):
    async def get_decisions(self, request: authorization_dot_authorization__pb2.GetDecisionsRequest, ctx: RequestContext) -> authorization_dot_authorization__pb2.GetDecisionsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_decisions_by_token(self, request: authorization_dot_authorization__pb2.GetDecisionsByTokenRequest, ctx: RequestContext) -> authorization_dot_authorization__pb2.GetDecisionsByTokenResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_entitlements(self, request: authorization_dot_authorization__pb2.GetEntitlementsRequest, ctx: RequestContext) -> authorization_dot_authorization__pb2.GetEntitlementsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AuthorizationServiceASGIApplication(ConnectASGIApplication[AuthorizationService]):
    def __init__(self, service: AuthorizationService | AsyncGenerator[AuthorizationService], *, interceptors: Iterable[Interceptor]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            service=service,
            endpoints=lambda svc: {
                "/authorization.AuthorizationService/GetDecisions": Endpoint.unary(
                    method=MethodInfo(
                        name="GetDecisions",
                        service_name="authorization.AuthorizationService",
                        input=authorization_dot_authorization__pb2.GetDecisionsRequest,
                        output=authorization_dot_authorization__pb2.GetDecisionsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_decisions,
                ),
                "/authorization.AuthorizationService/GetDecisionsByToken": Endpoint.unary(
                    method=MethodInfo(
                        name="GetDecisionsByToken",
                        service_name="authorization.AuthorizationService",
                        input=authorization_dot_authorization__pb2.GetDecisionsByTokenRequest,
                        output=authorization_dot_authorization__pb2.GetDecisionsByTokenResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_decisions_by_token,
                ),
                "/authorization.AuthorizationService/GetEntitlements": Endpoint.unary(
                    method=MethodInfo(
                        name="GetEntitlements",
                        service_name="authorization.AuthorizationService",
                        input=authorization_dot_authorization__pb2.GetEntitlementsRequest,
                        output=authorization_dot_authorization__pb2.GetEntitlementsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_entitlements,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/authorization.AuthorizationService"


class AuthorizationServiceClient(ConnectClient):
    async def get_decisions(
        self,
        request: authorization_dot_authorization__pb2.GetDecisionsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_authorization__pb2.GetDecisionsResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisions",
                service_name="authorization.AuthorizationService",
                input=authorization_dot_authorization__pb2.GetDecisionsRequest,
                output=authorization_dot_authorization__pb2.GetDecisionsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_decisions_by_token(
        self,
        request: authorization_dot_authorization__pb2.GetDecisionsByTokenRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_authorization__pb2.GetDecisionsByTokenResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisionsByToken",
                service_name="authorization.AuthorizationService",
                input=authorization_dot_authorization__pb2.GetDecisionsByTokenRequest,
                output=authorization_dot_authorization__pb2.GetDecisionsByTokenResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_entitlements(
        self,
        request: authorization_dot_authorization__pb2.GetEntitlementsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_authorization__pb2.GetEntitlementsResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetEntitlements",
                service_name="authorization.AuthorizationService",
                input=authorization_dot_authorization__pb2.GetEntitlementsRequest,
                output=authorization_dot_authorization__pb2.GetEntitlementsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )


class AuthorizationServiceSync(Protocol):
    def get_decisions(self, request: authorization_dot_authorization__pb2.GetDecisionsRequest, ctx: RequestContext) -> authorization_dot_authorization__pb2.GetDecisionsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_decisions_by_token(self, request: authorization_dot_authorization__pb2.GetDecisionsByTokenRequest, ctx: RequestContext) -> authorization_dot_authorization__pb2.GetDecisionsByTokenResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_entitlements(self, request: authorization_dot_authorization__pb2.GetEntitlementsRequest, ctx: RequestContext) -> authorization_dot_authorization__pb2.GetEntitlementsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AuthorizationServiceWSGIApplication(ConnectWSGIApplication):
    def __init__(self, service: AuthorizationServiceSync, interceptors: Iterable[InterceptorSync]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            endpoints={
                "/authorization.AuthorizationService/GetDecisions": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetDecisions",
                        service_name="authorization.AuthorizationService",
                        input=authorization_dot_authorization__pb2.GetDecisionsRequest,
                        output=authorization_dot_authorization__pb2.GetDecisionsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_decisions,
                ),
                "/authorization.AuthorizationService/GetDecisionsByToken": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetDecisionsByToken",
                        service_name="authorization.AuthorizationService",
                        input=authorization_dot_authorization__pb2.GetDecisionsByTokenRequest,
                        output=authorization_dot_authorization__pb2.GetDecisionsByTokenResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_decisions_by_token,
                ),
                "/authorization.AuthorizationService/GetEntitlements": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetEntitlements",
                        service_name="authorization.AuthorizationService",
                        input=authorization_dot_authorization__pb2.GetEntitlementsRequest,
                        output=authorization_dot_authorization__pb2.GetEntitlementsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_entitlements,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/authorization.AuthorizationService"


class AuthorizationServiceClientSync(ConnectClientSync):
    def get_decisions(
        self,
        request: authorization_dot_authorization__pb2.GetDecisionsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_authorization__pb2.GetDecisionsResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisions",
                service_name="authorization.AuthorizationService",
                input=authorization_dot_authorization__pb2.GetDecisionsRequest,
                output=authorization_dot_authorization__pb2.GetDecisionsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_decisions_by_token(
        self,
        request: authorization_dot_authorization__pb2.GetDecisionsByTokenRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_authorization__pb2.GetDecisionsByTokenResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisionsByToken",
                service_name="authorization.AuthorizationService",
                input=authorization_dot_authorization__pb2.GetDecisionsByTokenRequest,
                output=authorization_dot_authorization__pb2.GetDecisionsByTokenResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_entitlements(
        self,
        request: authorization_dot_authorization__pb2.GetEntitlementsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_authorization__pb2.GetEntitlementsResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetEntitlements",
                service_name="authorization.AuthorizationService",
                input=authorization_dot_authorization__pb2.GetEntitlementsRequest,
                output=authorization_dot_authorization__pb2.GetEntitlementsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )
