# -*- coding: utf-8 -*-
# Generated by https://github.com/connectrpc/connect-python.  DO NOT EDIT!
# source: authorization/v2/authorization.proto

from collections.abc import AsyncGenerator, AsyncIterator, Iterable, Iterator, Mapping
from typing import Protocol

from connectrpc.client import ConnectClient, ConnectClientSync
from connectrpc.code import Code
from connectrpc.errors import ConnectError
from connectrpc.interceptor import Interceptor, InterceptorSync
from connectrpc.method import IdempotencyLevel, MethodInfo
from connectrpc.request import Headers, RequestContext
from connectrpc.server import ConnectASGIApplication, ConnectWSGIApplication, Endpoint, EndpointSync
import authorization.v2.authorization_pb2 as authorization_dot_v2_dot_authorization__pb2


class AuthorizationService(Protocol):
    async def get_decision(self, request: authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_decision_multi_resource(self, request: authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_decision_bulk(self, request: authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_entitlements(self, request: authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AuthorizationServiceASGIApplication(ConnectASGIApplication[AuthorizationService]):
    def __init__(self, service: AuthorizationService | AsyncGenerator[AuthorizationService], *, interceptors: Iterable[Interceptor]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            service=service,
            endpoints=lambda svc: {
                "/authorization.v2.AuthorizationService/GetDecision": Endpoint.unary(
                    method=MethodInfo(
                        name="GetDecision",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_decision,
                ),
                "/authorization.v2.AuthorizationService/GetDecisionMultiResource": Endpoint.unary(
                    method=MethodInfo(
                        name="GetDecisionMultiResource",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_decision_multi_resource,
                ),
                "/authorization.v2.AuthorizationService/GetDecisionBulk": Endpoint.unary(
                    method=MethodInfo(
                        name="GetDecisionBulk",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_decision_bulk,
                ),
                "/authorization.v2.AuthorizationService/GetEntitlements": Endpoint.unary(
                    method=MethodInfo(
                        name="GetEntitlements",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_entitlements,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/authorization.v2.AuthorizationService"


class AuthorizationServiceClient(ConnectClient):
    async def get_decision(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecision",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_decision_multi_resource(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisionMultiResource",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_decision_bulk(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisionBulk",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_entitlements(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetEntitlements",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )


class AuthorizationServiceSync(Protocol):
    def get_decision(self, request: authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_decision_multi_resource(self, request: authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_decision_bulk(self, request: authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_entitlements(self, request: authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest, ctx: RequestContext) -> authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AuthorizationServiceWSGIApplication(ConnectWSGIApplication):
    def __init__(self, service: AuthorizationServiceSync, interceptors: Iterable[InterceptorSync]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            endpoints={
                "/authorization.v2.AuthorizationService/GetDecision": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetDecision",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_decision,
                ),
                "/authorization.v2.AuthorizationService/GetDecisionMultiResource": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetDecisionMultiResource",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_decision_multi_resource,
                ),
                "/authorization.v2.AuthorizationService/GetDecisionBulk": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetDecisionBulk",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_decision_bulk,
                ),
                "/authorization.v2.AuthorizationService/GetEntitlements": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetEntitlements",
                        service_name="authorization.v2.AuthorizationService",
                        input=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest,
                        output=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_entitlements,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/authorization.v2.AuthorizationService"


class AuthorizationServiceClientSync(ConnectClientSync):
    def get_decision(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecision",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetDecisionRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetDecisionResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_decision_multi_resource(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisionMultiResource",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetDecisionMultiResourceResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_decision_bulk(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetDecisionBulk",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetDecisionBulkResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_entitlements(
        self,
        request: authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetEntitlements",
                service_name="authorization.v2.AuthorizationService",
                input=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsRequest,
                output=authorization_dot_v2_dot_authorization__pb2.GetEntitlementsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )
