# -*- coding: utf-8 -*-
# Generated by https://github.com/connectrpc/connect-python.  DO NOT EDIT!
# source: entityresolution/entity_resolution.proto

from collections.abc import AsyncGenerator, AsyncIterator, Iterable, Iterator, Mapping
from typing import Protocol

from connectrpc.client import ConnectClient, ConnectClientSync
from connectrpc.code import Code
from connectrpc.errors import ConnectError
from connectrpc.interceptor import Interceptor, InterceptorSync
from connectrpc.method import IdempotencyLevel, MethodInfo
from connectrpc.request import Headers, RequestContext
from connectrpc.server import ConnectASGIApplication, ConnectWSGIApplication, Endpoint, EndpointSync
from . import entity_resolution_pb2 as entityresolution_dot_entity__resolution__pb2


class EntityResolutionService(Protocol):
    async def resolve_entities(self, request: entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest, ctx: RequestContext) -> entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def create_entity_chain_from_jwt(self, request: entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest, ctx: RequestContext) -> entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class EntityResolutionServiceASGIApplication(ConnectASGIApplication[EntityResolutionService]):
    def __init__(self, service: EntityResolutionService | AsyncGenerator[EntityResolutionService], *, interceptors: Iterable[Interceptor]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            service=service,
            endpoints=lambda svc: {
                "/entityresolution.EntityResolutionService/ResolveEntities": Endpoint.unary(
                    method=MethodInfo(
                        name="ResolveEntities",
                        service_name="entityresolution.EntityResolutionService",
                        input=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest,
                        output=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.resolve_entities,
                ),
                "/entityresolution.EntityResolutionService/CreateEntityChainFromJwt": Endpoint.unary(
                    method=MethodInfo(
                        name="CreateEntityChainFromJwt",
                        service_name="entityresolution.EntityResolutionService",
                        input=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest,
                        output=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.create_entity_chain_from_jwt,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/entityresolution.EntityResolutionService"


class EntityResolutionServiceClient(ConnectClient):
    async def resolve_entities(
        self,
        request: entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ResolveEntities",
                service_name="entityresolution.EntityResolutionService",
                input=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest,
                output=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def create_entity_chain_from_jwt(
        self,
        request: entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateEntityChainFromJwt",
                service_name="entityresolution.EntityResolutionService",
                input=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest,
                output=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )


class EntityResolutionServiceSync(Protocol):
    def resolve_entities(self, request: entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest, ctx: RequestContext) -> entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def create_entity_chain_from_jwt(self, request: entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest, ctx: RequestContext) -> entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class EntityResolutionServiceWSGIApplication(ConnectWSGIApplication):
    def __init__(self, service: EntityResolutionServiceSync, interceptors: Iterable[InterceptorSync]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            endpoints={
                "/entityresolution.EntityResolutionService/ResolveEntities": EndpointSync.unary(
                    method=MethodInfo(
                        name="ResolveEntities",
                        service_name="entityresolution.EntityResolutionService",
                        input=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest,
                        output=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.resolve_entities,
                ),
                "/entityresolution.EntityResolutionService/CreateEntityChainFromJwt": EndpointSync.unary(
                    method=MethodInfo(
                        name="CreateEntityChainFromJwt",
                        service_name="entityresolution.EntityResolutionService",
                        input=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest,
                        output=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.create_entity_chain_from_jwt,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/entityresolution.EntityResolutionService"


class EntityResolutionServiceClientSync(ConnectClientSync):
    def resolve_entities(
        self,
        request: entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ResolveEntities",
                service_name="entityresolution.EntityResolutionService",
                input=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesRequest,
                output=entityresolution_dot_entity__resolution__pb2.ResolveEntitiesResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def create_entity_chain_from_jwt(
        self,
        request: entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateEntityChainFromJwt",
                service_name="entityresolution.EntityResolutionService",
                input=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtRequest,
                output=entityresolution_dot_entity__resolution__pb2.CreateEntityChainFromJwtResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )
