# -*- coding: utf-8 -*-
# Generated by https://github.com/connectrpc/connect-python.  DO NOT EDIT!
# source: policy/attributes/attributes.proto

from collections.abc import AsyncGenerator, AsyncIterator, Iterable, Iterator, Mapping
from typing import Protocol

from connectrpc.client import ConnectClient, ConnectClientSync
from connectrpc.code import Code
from connectrpc.errors import ConnectError
from connectrpc.interceptor import Interceptor, InterceptorSync
from connectrpc.method import IdempotencyLevel, MethodInfo
from connectrpc.request import Headers, RequestContext
from connectrpc.server import ConnectASGIApplication, ConnectWSGIApplication, Endpoint, EndpointSync
import policy.attributes.attributes_pb2 as policy_dot_attributes_dot_attributes__pb2


class AttributesService(Protocol):
    async def list_attributes(self, request: policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def list_attribute_values(self, request: policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_attribute_values_by_fqns(self, request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def create_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def update_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def deactivate_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def create_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def update_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def deactivate_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def assign_key_access_server_to_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def remove_key_access_server_from_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def assign_key_access_server_to_value(self, request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def remove_key_access_server_from_value(self, request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def assign_public_key_to_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def remove_public_key_from_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def assign_public_key_to_value(self, request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def remove_public_key_from_value(self, request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AttributesServiceASGIApplication(ConnectASGIApplication[AttributesService]):
    def __init__(self, service: AttributesService | AsyncGenerator[AttributesService], *, interceptors: Iterable[Interceptor]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            service=service,
            endpoints=lambda svc: {
                "/policy.attributes.AttributesService/ListAttributes": Endpoint.unary(
                    method=MethodInfo(
                        name="ListAttributes",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.list_attributes,
                ),
                "/policy.attributes.AttributesService/ListAttributeValues": Endpoint.unary(
                    method=MethodInfo(
                        name="ListAttributeValues",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.list_attribute_values,
                ),
                "/policy.attributes.AttributesService/GetAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="GetAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.get_attribute,
                ),
                "/policy.attributes.AttributesService/GetAttributeValuesByFqns": Endpoint.unary(
                    method=MethodInfo(
                        name="GetAttributeValuesByFqns",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.get_attribute_values_by_fqns,
                ),
                "/policy.attributes.AttributesService/CreateAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="CreateAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.create_attribute,
                ),
                "/policy.attributes.AttributesService/UpdateAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="UpdateAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.update_attribute,
                ),
                "/policy.attributes.AttributesService/DeactivateAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="DeactivateAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.deactivate_attribute,
                ),
                "/policy.attributes.AttributesService/GetAttributeValue": Endpoint.unary(
                    method=MethodInfo(
                        name="GetAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.get_attribute_value,
                ),
                "/policy.attributes.AttributesService/CreateAttributeValue": Endpoint.unary(
                    method=MethodInfo(
                        name="CreateAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.create_attribute_value,
                ),
                "/policy.attributes.AttributesService/UpdateAttributeValue": Endpoint.unary(
                    method=MethodInfo(
                        name="UpdateAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.update_attribute_value,
                ),
                "/policy.attributes.AttributesService/DeactivateAttributeValue": Endpoint.unary(
                    method=MethodInfo(
                        name="DeactivateAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.deactivate_attribute_value,
                ),
                "/policy.attributes.AttributesService/AssignKeyAccessServerToAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="AssignKeyAccessServerToAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.assign_key_access_server_to_attribute,
                ),
                "/policy.attributes.AttributesService/RemoveKeyAccessServerFromAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="RemoveKeyAccessServerFromAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.remove_key_access_server_from_attribute,
                ),
                "/policy.attributes.AttributesService/AssignKeyAccessServerToValue": Endpoint.unary(
                    method=MethodInfo(
                        name="AssignKeyAccessServerToValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.assign_key_access_server_to_value,
                ),
                "/policy.attributes.AttributesService/RemoveKeyAccessServerFromValue": Endpoint.unary(
                    method=MethodInfo(
                        name="RemoveKeyAccessServerFromValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.remove_key_access_server_from_value,
                ),
                "/policy.attributes.AttributesService/AssignPublicKeyToAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="AssignPublicKeyToAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.assign_public_key_to_attribute,
                ),
                "/policy.attributes.AttributesService/RemovePublicKeyFromAttribute": Endpoint.unary(
                    method=MethodInfo(
                        name="RemovePublicKeyFromAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.remove_public_key_from_attribute,
                ),
                "/policy.attributes.AttributesService/AssignPublicKeyToValue": Endpoint.unary(
                    method=MethodInfo(
                        name="AssignPublicKeyToValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.assign_public_key_to_value,
                ),
                "/policy.attributes.AttributesService/RemovePublicKeyFromValue": Endpoint.unary(
                    method=MethodInfo(
                        name="RemovePublicKeyFromValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.remove_public_key_from_value,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/policy.attributes.AttributesService"


class AttributesServiceClient(ConnectClient):
    async def list_attributes(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ListAttributes",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest,
                output=policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def list_attribute_values(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ListAttributeValues",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest,
                output=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def get_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def get_attribute_values_by_fqns(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetAttributeValuesByFqns",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest,
                output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def create_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def update_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UpdateAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def deactivate_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="DeactivateAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def create_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def update_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UpdateAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def deactivate_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="DeactivateAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def assign_key_access_server_to_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignKeyAccessServerToAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def remove_key_access_server_from_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemoveKeyAccessServerFromAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def assign_key_access_server_to_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignKeyAccessServerToValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def remove_key_access_server_from_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemoveKeyAccessServerFromValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def assign_public_key_to_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignPublicKeyToAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def remove_public_key_from_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemovePublicKeyFromAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def assign_public_key_to_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignPublicKeyToValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def remove_public_key_from_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemovePublicKeyFromValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )


class AttributesServiceSync(Protocol):
    def list_attributes(self, request: policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def list_attribute_values(self, request: policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_attribute_values_by_fqns(self, request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def create_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def update_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def deactivate_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def create_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def update_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def deactivate_attribute_value(self, request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def assign_key_access_server_to_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def remove_key_access_server_from_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def assign_key_access_server_to_value(self, request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def remove_key_access_server_from_value(self, request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def assign_public_key_to_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def remove_public_key_from_attribute(self, request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def assign_public_key_to_value(self, request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def remove_public_key_from_value(self, request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest, ctx: RequestContext) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AttributesServiceWSGIApplication(ConnectWSGIApplication):
    def __init__(self, service: AttributesServiceSync, interceptors: Iterable[InterceptorSync]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            endpoints={
                "/policy.attributes.AttributesService/ListAttributes": EndpointSync.unary(
                    method=MethodInfo(
                        name="ListAttributes",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.list_attributes,
                ),
                "/policy.attributes.AttributesService/ListAttributeValues": EndpointSync.unary(
                    method=MethodInfo(
                        name="ListAttributeValues",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.list_attribute_values,
                ),
                "/policy.attributes.AttributesService/GetAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.get_attribute,
                ),
                "/policy.attributes.AttributesService/GetAttributeValuesByFqns": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetAttributeValuesByFqns",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.get_attribute_values_by_fqns,
                ),
                "/policy.attributes.AttributesService/CreateAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="CreateAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.create_attribute,
                ),
                "/policy.attributes.AttributesService/UpdateAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="UpdateAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.update_attribute,
                ),
                "/policy.attributes.AttributesService/DeactivateAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="DeactivateAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.deactivate_attribute,
                ),
                "/policy.attributes.AttributesService/GetAttributeValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.get_attribute_value,
                ),
                "/policy.attributes.AttributesService/CreateAttributeValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="CreateAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.create_attribute_value,
                ),
                "/policy.attributes.AttributesService/UpdateAttributeValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="UpdateAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.update_attribute_value,
                ),
                "/policy.attributes.AttributesService/DeactivateAttributeValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="DeactivateAttributeValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.deactivate_attribute_value,
                ),
                "/policy.attributes.AttributesService/AssignKeyAccessServerToAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="AssignKeyAccessServerToAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.assign_key_access_server_to_attribute,
                ),
                "/policy.attributes.AttributesService/RemoveKeyAccessServerFromAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="RemoveKeyAccessServerFromAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.remove_key_access_server_from_attribute,
                ),
                "/policy.attributes.AttributesService/AssignKeyAccessServerToValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="AssignKeyAccessServerToValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.assign_key_access_server_to_value,
                ),
                "/policy.attributes.AttributesService/RemoveKeyAccessServerFromValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="RemoveKeyAccessServerFromValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.remove_key_access_server_from_value,
                ),
                "/policy.attributes.AttributesService/AssignPublicKeyToAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="AssignPublicKeyToAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.assign_public_key_to_attribute,
                ),
                "/policy.attributes.AttributesService/RemovePublicKeyFromAttribute": EndpointSync.unary(
                    method=MethodInfo(
                        name="RemovePublicKeyFromAttribute",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.remove_public_key_from_attribute,
                ),
                "/policy.attributes.AttributesService/AssignPublicKeyToValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="AssignPublicKeyToValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.assign_public_key_to_value,
                ),
                "/policy.attributes.AttributesService/RemovePublicKeyFromValue": EndpointSync.unary(
                    method=MethodInfo(
                        name="RemovePublicKeyFromValue",
                        service_name="policy.attributes.AttributesService",
                        input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest,
                        output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.remove_public_key_from_value,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/policy.attributes.AttributesService"


class AttributesServiceClientSync(ConnectClientSync):
    def list_attributes(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ListAttributes",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.ListAttributesRequest,
                output=policy_dot_attributes_dot_attributes__pb2.ListAttributesResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def list_attribute_values(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ListAttributeValues",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesRequest,
                output=policy_dot_attributes_dot_attributes__pb2.ListAttributeValuesResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def get_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.GetAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.GetAttributeResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def get_attribute_values_by_fqns(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetAttributeValuesByFqns",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsRequest,
                output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValuesByFqnsResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def create_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def update_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UpdateAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def deactivate_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="DeactivateAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.GetAttributeValueResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def create_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.CreateAttributeValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def update_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UpdateAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.UpdateAttributeValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def deactivate_attribute_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="DeactivateAttributeValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.DeactivateAttributeValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def assign_key_access_server_to_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignKeyAccessServerToAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def remove_key_access_server_from_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemoveKeyAccessServerFromAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def assign_key_access_server_to_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignKeyAccessServerToValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignKeyAccessServerToValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def remove_key_access_server_from_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemoveKeyAccessServerFromValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemoveKeyAccessServerFromValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def assign_public_key_to_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignPublicKeyToAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def remove_public_key_from_attribute(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemovePublicKeyFromAttribute",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromAttributeResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def assign_public_key_to_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="AssignPublicKeyToValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.AssignPublicKeyToValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def remove_public_key_from_value(
        self,
        request: policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="RemovePublicKeyFromValue",
                service_name="policy.attributes.AttributesService",
                input=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueRequest,
                output=policy_dot_attributes_dot_attributes__pb2.RemovePublicKeyFromValueResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )
