# -*- coding: utf-8 -*-
# Generated by https://github.com/connectrpc/connect-python.  DO NOT EDIT!
# source: kas/kas.proto

from collections.abc import AsyncGenerator, AsyncIterator, Iterable, Iterator, Mapping
from typing import Protocol

from connectrpc.client import ConnectClient, ConnectClientSync
from connectrpc.code import Code
from connectrpc.errors import ConnectError
from connectrpc.interceptor import Interceptor, InterceptorSync
from connectrpc.method import IdempotencyLevel, MethodInfo
from connectrpc.request import Headers, RequestContext
from connectrpc.server import ConnectASGIApplication, ConnectWSGIApplication, Endpoint, EndpointSync
import google.protobuf.wrappers_pb2 as google_dot_protobuf_dot_wrappers__pb2
from . import kas_pb2 as kas_dot_kas__pb2


class AccessService(Protocol):
    async def public_key(self, request: kas_dot_kas__pb2.PublicKeyRequest, ctx: RequestContext) -> kas_dot_kas__pb2.PublicKeyResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def legacy_public_key(self, request: kas_dot_kas__pb2.LegacyPublicKeyRequest, ctx: RequestContext) -> google_dot_protobuf_dot_wrappers__pb2.StringValue:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def rewrap(self, request: kas_dot_kas__pb2.RewrapRequest, ctx: RequestContext) -> kas_dot_kas__pb2.RewrapResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AccessServiceASGIApplication(ConnectASGIApplication[AccessService]):
    def __init__(self, service: AccessService | AsyncGenerator[AccessService], *, interceptors: Iterable[Interceptor]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            service=service,
            endpoints=lambda svc: {
                "/kas.AccessService/PublicKey": Endpoint.unary(
                    method=MethodInfo(
                        name="PublicKey",
                        service_name="kas.AccessService",
                        input=kas_dot_kas__pb2.PublicKeyRequest,
                        output=kas_dot_kas__pb2.PublicKeyResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.public_key,
                ),
                "/kas.AccessService/LegacyPublicKey": Endpoint.unary(
                    method=MethodInfo(
                        name="LegacyPublicKey",
                        service_name="kas.AccessService",
                        input=kas_dot_kas__pb2.LegacyPublicKeyRequest,
                        output=google_dot_protobuf_dot_wrappers__pb2.StringValue,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=svc.legacy_public_key,
                ),
                "/kas.AccessService/Rewrap": Endpoint.unary(
                    method=MethodInfo(
                        name="Rewrap",
                        service_name="kas.AccessService",
                        input=kas_dot_kas__pb2.RewrapRequest,
                        output=kas_dot_kas__pb2.RewrapResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.rewrap,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/kas.AccessService"


class AccessServiceClient(ConnectClient):
    async def public_key(
        self,
        request: kas_dot_kas__pb2.PublicKeyRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> kas_dot_kas__pb2.PublicKeyResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="PublicKey",
                service_name="kas.AccessService",
                input=kas_dot_kas__pb2.PublicKeyRequest,
                output=kas_dot_kas__pb2.PublicKeyResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def legacy_public_key(
        self,
        request: kas_dot_kas__pb2.LegacyPublicKeyRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> google_dot_protobuf_dot_wrappers__pb2.StringValue:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="LegacyPublicKey",
                service_name="kas.AccessService",
                input=kas_dot_kas__pb2.LegacyPublicKeyRequest,
                output=google_dot_protobuf_dot_wrappers__pb2.StringValue,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    async def rewrap(
        self,
        request: kas_dot_kas__pb2.RewrapRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> kas_dot_kas__pb2.RewrapResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="Rewrap",
                service_name="kas.AccessService",
                input=kas_dot_kas__pb2.RewrapRequest,
                output=kas_dot_kas__pb2.RewrapResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )


class AccessServiceSync(Protocol):
    def public_key(self, request: kas_dot_kas__pb2.PublicKeyRequest, ctx: RequestContext) -> kas_dot_kas__pb2.PublicKeyResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def legacy_public_key(self, request: kas_dot_kas__pb2.LegacyPublicKeyRequest, ctx: RequestContext) -> google_dot_protobuf_dot_wrappers__pb2.StringValue:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def rewrap(self, request: kas_dot_kas__pb2.RewrapRequest, ctx: RequestContext) -> kas_dot_kas__pb2.RewrapResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class AccessServiceWSGIApplication(ConnectWSGIApplication):
    def __init__(self, service: AccessServiceSync, interceptors: Iterable[InterceptorSync]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            endpoints={
                "/kas.AccessService/PublicKey": EndpointSync.unary(
                    method=MethodInfo(
                        name="PublicKey",
                        service_name="kas.AccessService",
                        input=kas_dot_kas__pb2.PublicKeyRequest,
                        output=kas_dot_kas__pb2.PublicKeyResponse,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.public_key,
                ),
                "/kas.AccessService/LegacyPublicKey": EndpointSync.unary(
                    method=MethodInfo(
                        name="LegacyPublicKey",
                        service_name="kas.AccessService",
                        input=kas_dot_kas__pb2.LegacyPublicKeyRequest,
                        output=google_dot_protobuf_dot_wrappers__pb2.StringValue,
                        idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
                    ),
                    function=service.legacy_public_key,
                ),
                "/kas.AccessService/Rewrap": EndpointSync.unary(
                    method=MethodInfo(
                        name="Rewrap",
                        service_name="kas.AccessService",
                        input=kas_dot_kas__pb2.RewrapRequest,
                        output=kas_dot_kas__pb2.RewrapResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.rewrap,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/kas.AccessService"


class AccessServiceClientSync(ConnectClientSync):
    def public_key(
        self,
        request: kas_dot_kas__pb2.PublicKeyRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> kas_dot_kas__pb2.PublicKeyResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="PublicKey",
                service_name="kas.AccessService",
                input=kas_dot_kas__pb2.PublicKeyRequest,
                output=kas_dot_kas__pb2.PublicKeyResponse,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def legacy_public_key(
        self,
        request: kas_dot_kas__pb2.LegacyPublicKeyRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
        use_get: bool = False,
    ) -> google_dot_protobuf_dot_wrappers__pb2.StringValue:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="LegacyPublicKey",
                service_name="kas.AccessService",
                input=kas_dot_kas__pb2.LegacyPublicKeyRequest,
                output=google_dot_protobuf_dot_wrappers__pb2.StringValue,
                idempotency_level=IdempotencyLevel.NO_SIDE_EFFECTS,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
            use_get=use_get,
        )

    def rewrap(
        self,
        request: kas_dot_kas__pb2.RewrapRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> kas_dot_kas__pb2.RewrapResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="Rewrap",
                service_name="kas.AccessService",
                input=kas_dot_kas__pb2.RewrapRequest,
                output=kas_dot_kas__pb2.RewrapResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )
