from .request_builder import RequestBuilder


class Common:

    def __init__(self):
        self.version = 'v1'
        self.request_builder = RequestBuilder()

    def supported_currencies(self):
        """
        Get the list of supported currencies.

        :return: JSON response with a list of supported currencies.
        :raises RequestBuilderException: If the request fails.
        """
        uri = self.version + '/common/currencies'
        return self.request_builder.send_request(uri=uri, method='get')
    
    def price(self):
        """
        Get current prices for supported assets.

        :return: JSON response with price details.
        :raises RequestBuilderException: If the request fails.
        """
        uri = self.version + '/common/prices'
        return self.request_builder.send_request(uri=uri, method='get')
    
    def supported_fiat_currencies(self):
        """
        Get the list of supported fiat currencies.

        :return: JSON response with supported fiat currencies.
        :raises RequestBuilderException: If the request fails.
        """
        uri = self.version + '/common/fiats'
        return self.request_builder.send_request(uri=uri, method='get')

    def supported_networks(self):
        """
        Get the list of supported networks.

        :return: JSON response with supported networks.
        :raises RequestBuilderException: If the request fails.
        """
        uri = self.version + '/common/networks'
        return self.request_builder.send_request(uri=uri, method='get')

    def system_status(self):
        """
        Check the system status and monitor uptime.

        :return: JSON response with system status details.
        :raises RequestBuilderException: If the request fails.
        """
        uri = self.version + '/common/monitor'
        return self.request_builder.send_request(uri=uri, method='get')

