class RequestExceptionsBuilder(Exception):

    def __init__(self, message: str, response_code: int, uri: str, errors: list = None):
        """
        :param str message: Description of the error.
        :param int response_code: HTTP status code of the response.
        :param str uri: API endpoint that caused the error.
        :param errors: Additional error details.
        :return Exception
        """

        self.method = uri
        self.errors = errors if errors else []
        super(RequestExceptionsBuilder, self).__init__(message, response_code, errors)

    def get_method(self):
        return self.method

    def get_errors(self):
        return self.errors