from setuptools import setup


with open("README.md", "r") as fh:
    long_description = fh.read()


setup(
    name='oxapay-python',
    packages=['oxapay_python'],
    version='1.0.0',
    license='MIT',
    description='Official Python SDK for OxaPay API',
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='OxaPay',
    author_email='frankdev@oxapay.com',
    url='https://github.com/OxaPay/oxapay-python',
    download_url='https://github.com/OxaPay/oxapay-python/archive/refs/tags/v1.0.0.tar.gz',
    keywords=['oxapay', 'crypto payment', 'sdk', 'bitcoin', 'etherium', 'crypto', 'blockchain'],
    install_requires=[
        'aiohttp',
        'requests'
    ],
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'Programming Language :: Python :: 3.13',
    ],
)