import pygame
import math
import sys
import types
import cairo
import random
import __main__
import builtins
from typing import Callable, Optional
from p5.constants import *
from p5.timedata import *
from p5.drawcurve import *
from p5.settings import *
from p5.color import *
from p5.transform import *
from p5.renderer import *  

CAIRO_SURFACE = None

builtins.setup_method: Optional[Callable] = None
builtins.draw_method: Optional[Callable] = None
builtins.mouse_clicked_method: Optional[Callable] = None
builtins.mouse_pressed_method: Optional[Callable] = None
builtins.mouse_released_method: Optional[Callable] = None
builtins.mouse_moved_method: Optional[Callable] = None
builtins.mouse_dragged_method: Optional[Callable] = None
builtins.key_pressed_method: Optional[Callable] = None
builtins.key_released_method: Optional[Callable] = None
 

def draw():
    pass

def setup():
    pass

def mouseClicked():
    pass

def mousePressed():
    pass

def mouseReleased():
    pass

def mouseMoved():
    pass

def mouseDragged():
    pass   
        
def keyPressed():
    pass

def keyReleased():
    pass
    

def run():    # Run a sketch.    
    # get the user-defined function: setup(), draw(), etc

    if hasattr(__main__, "setup"):
        builtins.setup_method = __main__.setup
    else:
        builtins.setup_method = setup

    if hasattr(__main__, "draw"):
        builtins.draw_method = __main__.draw
    else:
        builtins.draw_method = draw
        
    if hasattr(__main__, "mouseClicked"):
        builtins.mouse_clicked_method = __main__.mouseClicked        
    else:
        builtins.mouse_clicked_method = mouseClicked
        
    if hasattr(__main__, "mousePressed"):
        builtins.mouse_pressed_method = __main__.mousePressed           
    else:
        builtins.mouse_pressed_method = mousePressed    

    if hasattr(__main__, "mouseReleased"):
        builtins.mouse_released_method = __main__.mouseReleased           
    else:
        builtins.mouse_released_method = mouseReleased 
    
    if hasattr(__main__, "mouseMoved"):
        builtins.mouse_moved_method = __main__.mouseMoved           
    else:
        builtins.mouse_moved_method = mouseMoved

    if hasattr(__main__, "mouseDragged"):
        builtins.mouse_dragged_method = __main__.mouseDragged           
    else:
        builtins.mouse_dragged_method = mouseDragged
        
    if hasattr(__main__, "keyPressed"):
        builtins.key_pressed_method = __main__.keyPressed           
    else:
        builtins.key_pressed_method = keyPressed
        
    if hasattr(__main__, "keyReleased"):
        builtins.key_released_method = __main__.keyReleased           
    else:
        builtins.key_released_method = keyReleased                
     
    _setup()
    _draw()
    pass      





    


def angle_RAD(a):
    if builtins.ANGLEMODE == DEGREES:
        return a * math.pi/180
    else:
        return a    

def angle_DEG(a):
    if builtins.ANGLEMODE == RADIANS:
        return int(a * 180 / math.pi)
    else:
        return int(a) 

# SHAPE
def cxy(xx,yy):   # transform x,y coordinate
    global settings
    a  = settings["rotate_amnt"]
    s  = settings["scale_amnt"]
    ox = settings["real_ox"]
    oy = settings["real_oy"]
    x = xx
    y = yy
    if a > 0 :
        aa = angle_RAD(a)
        x = int(xx * math.cos(aa)) - int(yy * math.sin(aa))
        y = int(yy * math.cos(aa)) + int(xx * math.sin(aa))
    if s != 1 :
        x = x * s
        y = y * s
    if (ox != 0) or (oy != 0):
        x = x + ox
        y = y + oy     
    return (x, y)
    pass

def ctxy(c):    # transform tuple x,y coordinate
    tmp = []
    for i in range(len(c)):
        tmp.append(cxy(c[i][0],c[i][1]))
    return tmp  


def ellipse_array(x, y, width, height,thickness,scale):
    rx = (width/2  + thickness)*scale
    ry = (height/2 + thickness) * scale

    cx = x * scale
    cy = y * scale
    
    pts =[]
    # Get points on ellipse
    for n in range(0,360):
        xx = cx + int(rx*math.cos(n*math.pi/180))
        yy = cy + int(ry*math.sin(n*math.pi/180))
        pts.append((xx, yy))
    return pts

# ---- 2D PRIMITIVES ----
def arc(x, y, w, h, start, stop, mode = ARC):              
    emode = builtins.ellipse_mode
    if emode == RADIUS:
        w = 2 * w
        h = 2 * h
    if emode == CORNER:
        x = x + w/2
        y = y + h/2
    if emode == CORNERS:
        w = abs(w - x)
        h = abs(h - y)
        x = x + w/2
        y = y + h/2     
    draw_arc(CAIRO_SURFACE, x, y, w, h, angle_RAD(start), angle_RAD(stop), mode)    
    pass

def ellipse(x, y, w, h=None):    
    if not h:
        h = w
    emode = builtins.ellipse_mode
    if emode == RADIUS:
        w = 2 * w
        h = 2 * h
    if emode == CORNER:
        x = x + w/2
        y = y + h/2
    if emode == CORNERS:
        w = abs(w - x)
        h = abs(h - y)
        x = x + w/2
        y = y + h/2          
    draw_ellipse(CAIRO_SURFACE, x, y, w, h)
    pass

def circle(x, y, d):
    emode = builtins.ellipse_mode
    if emode == RADIUS:
        d = 2 * d
    if emode == CORNER:
        x = x + d/2
        y = y + d/2    
    draw_circle(CAIRO_SURFACE, x, y, d/2)   
    pass

def line(x1, y1, x2, y2):  
    draw_line(CAIRO_SURFACE, x1, y1, x2, y2)
    pass

def point(x, y):
    emode = builtins.ellipse_mode
    builtins.ellipse_mode = CENTER
    draw_circle(CAIRO_SURFACE, x, y, settings["stroke_weight"])
    builtins.ellipse_mode = emode  
    pass

def quad(x1, y1, x2, y2, x3, y3, x4, y4):
    vertices =[(x1, y1), (x2, y2), (x3, y3), (x4, y4)]
    draw_polygon(CAIRO_SURFACE, vertices)
    pass

def rect(x, y, w, h):
    rmode = builtins.rect_mode
    if rmode == RADIUS:
        w = 2 * w
        h = 2 * h
    if rmode == CENTER:
        x = x - w/2
        y = y - h/2
    if rmode == CORNERS:
        w = abs(w - x)
        h = abs(h - y)    
    draw_rect(CAIRO_SURFACE, x, y, w, h)     
    pass

def square(x, y, s):
    rect(x, y, s, s)
    pass

def triangle(x1, y1, x2, y2, x3, y3):
    vertices =[(x1, y1), (x2, y2), (x3, y3)]
    draw_polygon(CAIRO_SURFACE, vertices)
    pass

# ---- VERTEX ----
   
def beginShape():
    global shape, vertices, curvevertices
    shape = True
    vertices.clear()
    curvevertices.clear()
    pass

def vertex(x,y):
    global shape, vertices
    if shape:
        vertices.append((x,y))
    pass

def curveVertex(x,y):
    global shape, curvevertices
    if shape:
        curvevertices.append((x,y))
    pass    
    
def endShape(*args): # draw polygon/lines or spline curve
    global shape, vertices,curvevertices
    if len(args)==1 :
        if args[0] == "close":   
            if len(vertices) > 0:
                draw_polygon(CAIRO_SURFACE, vertices)
            if len(curvevertices) > 0:            
                spline(CAIRO_SURFACE, settings["stroke_color"], True, curvevertices,100, 0,0,0, settings["stroke_weight"])    
    else:
        if len(vertices) > 0:            
                draw_lines(CAIRO_SURFACE, vertices)
        if len(curvevertices) > 0:            
                spline(CAIRO_SURFACE, settings["stroke_color"], False, curvevertices,100, 0,0,0, settings["stroke_weight"])
    shape = None
    vertices.clear()
    curvevertices.clear()
    pass   
    
# ---- TYPOGRAPHY ---

def text(txt, x, y):
    style = "normal"
    if settings["text_italic"]:
        style = "italic"
    if settings["text_bold"]:
        style = "bold"
    if settings["text_bold"] and settings["text_italic"]:
        style = "bolditalic"       
    draw_text(CAIRO_SURFACE, txt, x, y, style)

def textStyle(style):
    if style == "bold":
           settings["text_bold"] = True 
    if style == "italic":
           settings["text_italic"] = True 
    if style == "bolditalic":
           settings["text_bold"] = True
           settings["text_italic"] = True 
    if style == "normal":
           settings["text_bold"] = False 
           settings["text_italic"] = False
    pass
        
def textSize(size: int): # Sets the current font size
    settings["text_size"] = size
    pass
    
def textFont(font, size=None): # Set current text font.
    settings["text_font"] = font 
    settings["text_size"] = size
    pass

def textAlign(align):
    if align in [CENTER,LEFT,RIGHT]:
        settings["text_align"] = align
    else:
        raise ValueError("textAlign() was expecting LEFT|CENTER|RIGHT")
      
# ---- IMAGE AND PIXEL ----

def loadImage(path):
    return pygame.image.load(path)

def image(img, x, y):
    pg_Screen.blit(img, (x, y))
        
def saveCanvas(filename):        
    pygame.image.save(pg_Screen, filename)

def loadPixels(image):
    return pygame.PixelArray(image)

def updatePixels(pixels):
    pixels.close()

# ---- ----
def createCanvas(w=100, h=100):
    global pg_Screen,CAIRO_SURFACE
    
    builtins.width  = w
    builtins.height = h
    pg_Screen = pygame.display.set_mode((w, h))
    pygame.display.set_caption('p5-python')
    p5_imgstring = b'\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xdd\x00R.\xb1\'=i\x00K\x00\xf1\xde\x00N\xc4\xff\x00Z\xd9\xff\x00[\xf1\xff\x00Y\xfd\xfe\x00X\xfd\xfc\x00W\xf1\xf9\x00V\xd9\xf6\x00U\xb5\xe0\x00N\x9e\xe9\x00OU\xeb\x00P)\x00\x00\x1f\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x03\xde\x00P\x0f\x9e\x00@\x84\xf2\x00V\xdc\xd4\x0eI\xf6\xa425\xfd\x00V\x00\xff\xbf\x1bA\xff\xbb_9\xff~\x8e\x1a\xff\x9cw*\xff\xea\x00O\xff\xfd\x00X\xff\xfb\x00W\xff\xf8\x00U\xff\xf5\x00T\xff\xf2\x00S\xfd\xf0\x00R\xf5\xee\x00Q\xdb\xdc\x08Kv\xec\x15O\x0e\x8c\x106\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x0b9.\xdf\x08N\x9f\xe7\x00R\xee\xf0\x00U\xff\xf1\x00V\xff;Q\x17\xff\x00Z\x00\xff\x00[\x00\xff\x00\x81\x00\xff\x00\xb1\x00\xff\x00\xaf\x00\xff\x00\xb0\x00\xff\x00\xab\x00\xff\xb4l5\xff\xfc\x00V\xff\xfb\x00V\xff\xf7\x00U\xff\xf4\x00S\xff\xf1\x00R\xff\xee\x00Q\xff\xec\x03P\xff\xeb\x11O\xe8\xe4\x17M\x9b\xd3\x19H#\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x1a\xa6\x16?\x8f\xed\x17Q\xed\xec\rR\xff\xed\x00T\xff\xef\x00U\xff\xf3\x00S\xff\xffo\x00\xff\xffu\x00\xff\x00{\x00\xff\x00\x8a\x00\xff\x00\xae\x00\xff\x00\xad\x00\xff\x00\xab\x00\xff\x00\xa1\x00\xff\x00\xaa\x00\xff\x9a\x82*\xff\xbd\'<\xff\xe8\x00M\xff\xf6\x00S\xff\xf2\x00R\xff\xef\x00P\xff\xed\x00O\xff\xeb\tN\xff\xea\x13N\xff\xe9\x18N\xee\xe8\x1bMx\x98\x158\x1a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x02\x00\x13!;\xdd\x1dL\xd5\xe9\x1cQ\xfe\xea\x17Q\xff\xeb\x0eR\xff\xec\x00S\xff\xee\x00U\xff\xfa><\xff\xff{\x00\xff\xffw\x00\xff\x00\x83\x00\xff\x00\x82\x00\xff\x00\xa9\x00\xff\x00\xac\x00\xff\x00\x9b\x00\xff\x00|\x00\xff\x00\x92\x00\xff\x00\xae\x00\xff\x00\xa1\x00\xff\x99>)\xff\xf9\x00S\xff\xf4\x00Q\xff\xf0\x00P\xff\xee\x00N\xff\xec\x00M\xff\xea\nM\xff\xe9\x13L\xff\xe9\x17M\xfd\xe6\x1bM\xd2\xdd\x1bJ+\x00\x11!\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x97\x198f\xdd\x1fM\xf5\xea\x1fP\xff\xea\x1cP\xff\xea\x18Q\xff\xea\x0fR\xff\xeb\x00S\xff\xed\x00U\xff\xfdN/\xff\xff{\x00\xff\xffy\x00\xff\x00\x83\x00\xff\x00\x81\x00\xff\x00\x93\x00\xff\x00\xac\x00\xff\x00\xa7\x00\xff\x00\x92\x00\xff\x00\xa3\x00\xff\x00\xac\x00\xff\x00\xae\x00\xff\x00\xa6\x00\xff\xd2L>\xff\xf5\x00P\xff\xf1\x00N\xff\xee\x00L\xff\xec\x00K\xff\xea\x00K\xff\xe9\x08K\xff\xe9\x11K\xff\xe9\x16L\xff\xe9\x1aL\xea\xd3\x1bGf\x85\x154\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x00\t\x96\x197\x85\xe7!P\xf4\xea P\xff\xea\x1fP\xff\xea\x1cP\xff\xea\x18Q\xff\xea\x10R\xff\xeb\x00S\xff\xec\x00T\xff\xf76A\xff\xff|\x00\xff\xffx\x00\xff{\x7f\x00\xff\x00\x82\x00\xff\x00\x82\x00\xff\x00\xa6\x00\xff\x12\xaa\x00\xff\x1a\xaa\x00\xff\x0b\xaa\x00\xff\x00\xab\x00\xff\x00\xac\x00\xff\x00\xae\x00\xff\x00\xa5\x00\xff\xf4\x00L\xff\xf1\x00K\xff\xee\x00I\xff\xec\x00H\xff\xea\x00G\xff\xe9\x00G\xff\xe9\x02H\xff\xe8\x0eJ\xff\xe8\x15K\xff\xe8\x1aL\xf4\xdc\x1bJs\xd0\x1dI\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x03\x84\x171\x85\xe9!P\xf6\xea P\xff\xea\x1fP\xff\xea\x1eP\xff\xea\x1cP\xff\xea\x17Q\xff\xea\x10Q\xff\xea\x00R\xff\xeb\x00T\xff\xef\x00S\xff\xffn\x00\xff\xffy\x00\xff\xffv\x00\xff\x00\x81\x00\xff\x00\x7f\x00\xff\x00\x87\x00\xff\x00\xaa\x00\xff\x00\x88\x00\xff\x00\x99\x00\xff\x00\xa9\x00\xff\x00\xaa\x00\xff\x00\xac\x00\xff\x00\xaf\x00\xff\xf0\x00B\xff\xf1\x00E\xff\xee\x00C\xff\xec\x00A\xff\xea\x00A\xff\xe9\x00B\xff\xe8\x00D\xff\xe8\x00F\xff\xe8\x0cI\xff\xe8\x15J\xff\xe8\x1aL\xf6\xde\x1bJp\x97\x1a8\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x82\x183x\xe6 O\xf3\xea P\xff\xea\x1fP\xff\xea\x1eP\xff\xea\x1cP\xff\xea\x19P\xff\xea\x15P\xff\xea\rQ\xff\xea\x00R\xff\xeb\x00S\xff\xed\x00U\xff\xf98@\xff\xffz\x00\xff\xffv\x00\xffAs\x00\xff\x00\x80\x00\xff\x00\x80\x00\xff\x00\xa8\x00\xff\x00\x89\x00\xff\x00\x97\x00\xff\x00\xa8\x00\xff\x00\xa9\x00\xff\x00\xaa\x00\xff\x91x\x00\xff\xf7\x00@\xff\xf1\x00;\xff\xee\x008\xff\xeb\x007\xff\xea\x008\xff\xe9\x00:\xff\xe8\x00>\xff\xe8\x00B\xff\xe8\x00E\xff\xe8\x0cH\xff\xe8\x16J\xff\xe8\x1bL\xf4\xd6\x1cHfk\x16,\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x1c;\xdb\x1eL\xf4\xeb\x1eP\xff\xea\x1dP\xff\xea\x1cP\xff\xea\x1aP\xff\xea\x18P\xff\xea\x14P\xff\xea\x0fP\xff\xeb\x05P\xff\xeb\x00Q\xff\xec\x00R\xff\xed\x00T\xff\xee\x00U\xff\xff_\x1b\xff\xffu\x00\xff\x83b\x00\xff\x00}\x00\xff\x00\x7f\x00\xff\x00\xa2\x00\xff\x00\xa9\x00\xff\x00\xa7\x00\xff\x00\x9b\x00\xff\x00\xa2\x00\xff\x00\xa3\x00\xff\xe4\x00&\xff\xf5\x002\xff\xf0\x00+\xff\xed\x00&\xff\xea\x00$\xff\xe9\x00\'\xff\xe8\x00-\xff\xe8\x004\xff\xe8\x00;\xff\xe8\x00A\xff\xe8\x00F\xff\xe8\x0fI\xff\xe8\x17K\xff\xe8\x1cL\xea\xe8\x1fM+\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x1b\xdc\x1cL\xd6\xeb\x1dP\xff\xeb\x1bP\xff\xeb\x19P\xff\xeb\x16P\xff\xeb\x13P\xff\xeb\x0eP\xff\xeb\x07P\xff\xec\x00P\xff\xec\x00P\xff\xec\x00P\xff\xec\x00Q\xff\xed\x00R\xff\xee\x00T\xff\xf6\x08H\xff\xffu\x00\xff\xfft\x00\xff\xdeu\x00\xff\x00\x7f\x00\xff\x00\x8f\x00\xff\x00\xa9\x00\xff\x00\x9e\x00\xff\x00t\x00\xff\x00~\x00\xff\x00\xa2\x00\xff}s\x00\xff\xf3\x00\x15\xff\xef\x00\x00\xff\xec\x00\x00\xff\xea\x00\x00\xff\xe8\x00\x00\xff\xe7\x00\x15\xff\xe7\x00&\xff\xe7\x003\xff\xe7\x00<\xff\xe8\x00B\xff\xe8\x05G\xff\xe8\x14J\xff\xe8\x1aL\xff\xe8\x1eM\xd0\xce\x1cF\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x124\x91\xea\x1bQ\xfe\xeb\x18Q\xff\xeb\x15Q\xff\xeb\x10Q\xff\xec\tQ\xff\xec\x00Q\xff\xed\x00P\xff\xed\x00P\xff\xed\x00P\xff\xee\x00O\xff\xee\x00O\xff\xee\x00P\xff\xee\x00P\xff\xef\x00Q\xff\xf0\x00R\xff\xffK%\xff\xffv\x00\xff\xffq\x00\xffoy\x00\xff\x00{\x00\xff\x00\x94\x00\xff\x00\xa3\x00\xff\x00\x82\x00\xff\xae\x7fi\xff\xb0\xb2\x8d\xff\xac\xb2\x87\xff\xfa\x9a\xb2\xff\xfe\x9c\xbb\xff\xfb\x9e\xbb\xff\xf9\xa0\xbb\xff\xf8\xa3\xbc\xff\xf7\xa7\xbe\xff\xf4\x8d\xa4\xff\xe7\x00/\xff\xe7\x007\xff\xe7\x00?\xff\xe8\x00E\xff\xe8\x10I\xff\xe8\x18K\xff\xe8\x1dL\xfd\xe8\x1fMx\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00-\xd8\x16M\xf9\xeb\x15Q\xff\xec\x0fQ\xff\xec\x06Q\xff\xec\x00Q\xff\xed\x00Q\xff\xee\x00Q\xff\xef\x00Q\xff\xef\x00P\xff\xf0\x00O\xff\xf0\x00N\xff\xf0\x00N\xff\xf0\x00M\xff\xf0\x00N\xff\xf0\x00N\xff\xf0\x00O\xff\xf1\x00N\xff\xffJ\x1a\xff\xff`\x00\xff\xffT\x00\xff\xc8o\x00\xff\xbfl\x00\xff\x87\x8e\x00\xff\x00\xa3\x00\xff\xdb\xb5\xad\xff\xe0\xff\xe4\xff\xdc\xfe\xe1\xff\xf7\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf8\xfc\xff\xe8\x00-\xff\xe7\x002\xff\xe7\x00=\xff\xe8\x00D\xff\xe8\rH\xff\xe8\x17K\xff\xe8\x1cL\xff\xe8\x1fM\xee\xce\x1dF#\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\xb1\rC\xa5\xec\x11R\xff\xec\x08R\xff\xec\x00R\xff\xed\x00R\xff\xee\x00R\xff\xef\x00R\xff\xf1\x00R\xff\xf2\x00Q\xff\xf2\x00O\xff\xf3\x00N\xff\xf3\x00L\xff\xf2\x00K\xff\xf1\x00J\xff\xf2\x00J\xff\xf2\x00J\xff\xf2\x00J\xff\xf2\x00K\xff\xf2\x00K\xff\xf5\x00H\xff\xf7\x00F\xff\xffR\x00\xff\xff_\x00\xff\xff`\x00\xff\x00\x9e\x00\xff\xd9\xc4\xbd\xff\xd9\xf4\xe2\xff\xd9\xfb\xdf\xff\xeb\xff\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\xf4\xff\xe7\x00+\xff\xe7\x001\xff\xe7\x00=\xff\xe8\x00D\xff\xe8\x0cH\xff\xe8\x17K\xff\xe8\x1cL\xff\xe8\x1fM\xff\xe4 L\x9b\xa7\x1c<\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\n@\x10\xd9\tL\xf1\xec\x01R\xff\xec\x00S\xff\xed\x00S\xff\xef\x00S\xff\xf0\x00S\xff\xf2\x00S\xff\xf4\x00R\xff\xf8\x00I\xff\xdf.6\xff\xa4p\x14\xff\x81\x8c\x00\xffr\x8d\x00\xffw\x8b\x00\xff\x97v\x00\xff\xcb"$\xff\xf3\x00C\xff\xf3\x00C\xff\xf3\x00D\xff\xf3\x00D\xff\xf5\x00B\xff\xffE\x00\xff\xff\\\x00\xff\xff]\x00\xff\x00\x9b\x00\xff\xd8\xcb\xc4\xff\xd8\xf2\xe0\xff\xd9\xfc\xdf\xff\x9cd\x00\xff\xf0\x00C\xff\xee\x00C\xff\xec\x00G\xff\xeb\x00M\xff\xeb\x00U\xff\xe9\x00N\xff\xe7\x00!\xff\xe7\x002\xff\xe7\x00=\xff\xe8\x00D\xff\xe8\x0eH\xff\xe8\x18K\xff\xe8\x1dL\xff\xe8\x1fM\xff\xe8!N\xe8\xe8!N\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x90\xee\x00S\xff\xed\x00S\xff\xed\x00T\xff\xef\x00T\xff\xf1\x00U\xff\xf7\x00I\xff\xffB-\xff\xe7x\x00\xffp\x9f\x00\xff\x00\xae\x00\xff\x00\xab\x00\xff\x00\xa6\x00\xff\x00\xa9\x00\xff\x00\xa7\x00\xff\x00\xa7\x00\xff\x00\xaa\x00\xff\x00\x97\x00\xff\xbaK\x00\xff\xe7\x00-\xff\xf5\x00:\xff\xf6\x007\xff\xffA\x00\xff\xffW\x00\xff\xc4v\x00\xff\x00\x9d\x00\xff\xdb\xd3\xc2\xff\xda\xfb\xdf\xff\xd5\xd8\xc2\xff\x86N\x00\xff\xeb\x00\x00\xff\xe9\x00\x00\xff\xe7\x00\x00\xff\xe7\x00\x00\xff\xe6\x00\x00\xff\xe6\x00\x00\xff\xe7\x00\x1e\xff\xe7\x002\xff\xe7\x00=\xff\xe8\x00D\xff\xe8\x0eH\xff\xe8\x18K\xff\xe8\x1dL\xff\xe8\x1fM\xff\xe8!N\xff\xe7!Nn\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\xc8\x00I\xdf\xed\x00T\xff\xed\x00T\xff\xef\x00U\xff\xf1\x00T\xff\xff?4\xff\xffq\x00\xff\xb5\x92\x00\xff\x00\xad\x00\xff\x00\xad\x00\xff\x00\xa0\x00\xff\x00y\x00\xff\x00\x83\x00\xff\x00\xa7\x00\xff\x00\x99\x00\xff\x00t\x00\xff\x00\x89\x00\xffb\x9b(\xff\xc1k^\xff\xcaZ]\xff\x8bq\x00\xff\xe5\x04\x00\xff\xffZ\x00\xff\xd5n\x00\xff\x00\x9a\x00\xff\x00\x8d\x00\xff\xd9\xd1\xc1\xff\xda\xfc\xde\xff\xd4\xd1\xbb\xff\xc1\x00\x00\xff\xeb\x00\x00\xff\xe9\x00\x00\xff\xe7\x00\x00\xff\xe6\x00\x00\xff\xe6\x00\x00\xff\xe6\x00\x00\xff\xe7\x00\x19\xff\xe7\x000\xff\xe7\x00<\xff\xe8\x00C\xff\xe8\x0bH\xff\xe8\x17J\xff\xe8\x1cL\xff\xe8\x1fM\xff\xe8 N\xff\xe8!N\xdbc\x19.\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x039\xe6\x00S\xf8\xed\x00U\xff\xee\x00U\xff\xf0\x00U\xff\xffW#\xff\xffu\x00\xff\xab\x94\x00\xff\x00\xae\x00\xff\x00\x9f\x00\xff\x00\xa8\x00\xff\x00\xa5\x00\xffY[\x00\xff\xdc\xde\xd1\xff\xe0\xec\xd7\xff\xd8\xc3\xb5\xff\xa2XJ\xff\xd9\xdc\xca\xff\xdd\xff\xe3\xff\xdb\xff\xe6\xff\xda\xff\xe6\xff\xdc\xf0\xd9\xff\xae\xd3\xaa\xff?\x89\x00\xff\x00\x9d\x00\xff\x00\x98\x00\xff\x00c\x00\xff\xd4\xc8\xc0\xff\xd9\xfb\xde\xff\xe1\xe3\xd1\xff\xfb\x80\xa7\xff\xfa\x92\xb2\xff\xf8\x96\xb2\xff\xf1\x00d\xff\xe6\x00\x00\xff\xe6\x00\x00\xff\xe6\x00\x00\xff\xe6\x00\x07\xff\xe7\x00*\xff\xe7\x009\xff\xe8\x00A\xff\xe8\x02F\xff\xe8\x13I\xff\xe8\x19K\xff\xe8\x1dL\xff\xe8\x1fM\xff\xe8 N\xf5\xe8!N)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xab\x00C[\xea\x00S\xfe\xee\x00V\xff\xef\x00V\xff\xffL/\xff\xffu\x00\xff\xdb\x89\x00\xff\x00\xad\x00\xff\x00\x98\x00\xff\x00w\x00\xff\x00\x91\x00\xff\x00\xa4\x00\xffd\x81\x00\xff\xdf\xf5\xdc\xff\xe2\xfd\xe2\xff\xdc\xea\xd1\xff\xda\xfb\xdf\xff\xdb\xff\xe3\xff\xda\xe5\xd0\xff\xd4\xd8\xcc\xff\xd7\xf1\xe0\xff\xda\xfe\xe3\xff\xdc\xfe\xe3\xff\xd6\xc4\xb8\xff\x00~\x00\xff\x00\x9a\x00\xff\x00y\x00\xff\xda\xf1\xdb\xff\xda\xfc\xe0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x81\x9a\xff\xe6\x00\x00\xff\xe6\x00\x00\xff\xe7\x00 \xff\xe7\x004\xff\xe7\x00>\xff\xe8\x00D\xff\xe8\nH\xff\xe8\x15J\xff\xe8\x1aK\xff\xe8\x1dL\xff\xe8\x1fM\xfd\xe5 MR\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x00<\xa1\xed\x00V\xff\xee\x00V\xff\xf7 G\xff\xffs\x00\xff\xfft\x00\xff\x00\xa8\x00\xff\x00\xac\x00\xff\x00\xa3\x00\xff\x00\x7f\x00\xff\x00\x9b\x00\xff\x00\x9e\x00\xff\xacJ\x00\xff\xff\xf4\xe9\xff\xff\xf4\xe2\xff\xff\xf2\xdf\xff\xfb\xee\xd9\xff\xd0\x80q\xff\x00\x9c\x00\xff\x00\x8f\x00\xff\x90e#\xff\xd8\xe5\xce\xff\xdb\xfb\xe1\xff\xd8\xf1\xe1\xff\xa9\xb6\x98\xff\x00\x98\x00\xff\x00\x97\x00\xff\xdc\xfd\xe2\xff\xfb\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf5\x90\xaa\xff\xe7\x00\x00\xff\xe7\x00\x0e\xff\xe7\x00,\xff\xe8\x009\xff\xe8\x00A\xff\xe8\x00E\xff\xe8\x0bH\xff\xe8\x14J\xff\xe8\x19K\xff\xe8\x1cL\xff\xe5\x1eK\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8d\x00=\xd4\xee\x00V\xff\xef\x00W\xff\xff]\x17\xff\xfft\x00\xff\xc8\x8c\x00\xff\x00\xac\x00\xff\x00\xa7\x00\xff\x00\xa9\x00\xff\x00\xa6\x00\xff\x00\xa0\x00\xff\xd7\x00\x00\xff\xfa\x00\'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xffpn\xff\xffW\x00\xff\xdbn\x00\xffm\x89\x00\xff\x00\x9b\x00\xff\x88\x86+\xff\xd8\xf5\xda\xff\xd9\xf9\xe0\xff\xd9\xda\xc7\xff\x00\x98\x00\xff\x00\x86\x00\xff\xf3\x8b\x9a\xff\xf7\x00`\xff\xf0\x00\x00\xff\xed\x00\x00\xff\xeb\x00\x00\xff\xed\x00\x00\xff\xfa\xb8\xc6\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe9\x005\xff\xe7\x00\x00\xff\xe8\x00$\xff\xe8\x004\xff\xe8\x00<\xff\xe8\x00A\xff\xe8\x00E\xff\xe8\x08G\xff\xe8\x12I\xff\xe8\x17J\xff\xe2\x18H\xb6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x00E\xee\xee\x00W\xff\xf3\x00O\xff\xffx\x00\xff\xfft\x00\xff\x82\x9e\x00\xff\x00\xa3\x00\xff\x00|\x00\xff\x00\x93\x00\xff\x00\xa7\x00\xff\xc8)\x00\xff\xf9\x00\x17\xff\xf7\x00\x17\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf8\xff\xff\xee\x00\x00\xff\xf8\x00\x00\xff\xff#\x00\xff\xff?\x00\xff\xffV\x00\xff\xbeg\x00\xff\xe5\xe9\xd4\xff\xec\xff\xf4\xff\xf1\xff\xf7\xff\xc53\x05\xff\xf1\x00\x00\xff\xf3\x00\x00\xff\xf1\x00\x00\xff\xf0\x00\x00\xff\xef\x00\x00\xff\xed\x00\x00\xff\xec\x00\x00\xff\xeb\x00\x00\xff\xff\xe5\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3c\x88\xff\xe8\x00\x00\xff\xe8\x00\x1a\xff\xe8\x00-\xff\xe8\x007\xff\xe8\x00<\xff\xe8\x00@\xff\xe8\x00D\xff\xe8\x01F\xff\xe8\rH\xff\xe2\x0eF\xd9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x00M\xfa\xee\x00W\xff\xfc;:\xff\xffv\x00\xff\xfft\x00\xff<\xa5\x00\xff\x00\x9b\x00\xff\x00\x7f\x00\xff\x00\x98\x00\xff;\x94\x00\xff\xf5\x00&\xff\xf6\x00\x06\xff\xf5\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe9\xf3\xff\xec\x00\x00\xff\xeb\x00\x00\xff\xec\x00\x00\xff\xee\x00\x00\xff\xf1\x00\x00\xff\xf0\x00\x00\xff\xff\xc2\xde\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00R\xff\xf3\x00\x00\xff\xf3\x00\x00\xff\xf2\x00\x00\xff\xf2\x00\x00\xff\xf1\x00\x00\xff\xf0\x00\x00\xff\xee\x00\x00\xff\xed\x00\x00\xff\xfan\x9b\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf9\x8a\xac\xff\xea\x00\x00\xff\xe9\x00\x10\xff\xe9\x00&\xff\xe8\x00/\xff\xe8\x005\xff\xe8\x00:\xff\xe8\x00>\xff\xe8\x00B\xff\xe8\x00E\xff\xe1\x00D\xf1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x00S\xfd\xee\x00X\xff\xffU0\xff\xffu\x00\xff\xffu\x00\xff\x00\xa7\x00\xff\x00\xac\x00\xff\x00\xa7\x00\xff\x00\xa7\x00\xffu\x88\x00\xff\xf8\x00)\xff\xf6\x00\x00\xff\xf4\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\xfa\xff\xeb\x00\x00\xff\xea\x00\x00\xff\xeb\x00\x00\xff\xec\x00\x00\xff\xed\x00\x00\xff\xee\x00\x00\xff\xff\xfa\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf6\x00O\xff\xf6\x00\x00\xff\xdc\x00\x00\xff\xbe\x00\x00\xff\xa8\x07\x00\xff\x94\x1e\x00\xff\x8d\x05\x00\xff\x98\x00\x00\xff\xb8\x00\x00\xff\xf7O\x83\xff\xff\xff\xff\xff\xff\xff\xff\xff\xfb\x80\xa5\xff\xec\x00\x00\xff\xeb\x00\x05\xff\xea\x00\x1c\xff\xe9\x00%\xff\xe8\x00!\xff\xe8\x001\xff\xe8\x007\xff\xe8\x00<\xff\xe8\x00A\xff\xe0\x00@\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x00P\xfe\xee\x00X\xff\xffY-\xff\xffu\x00\xff\xffu\x00\xff\x00\xa7\x00\xff\x00\xa7\x00\xff\x00\xa0\x00\xff\x00\xa6\x00\xffu\x88\x00\xff\xf7\x00*\xff\xf5\x00\x00\xff\xf4\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf2\x1eo\xff\xea\x00\x00\xff\xeb\x00\x00\xff\xed\x00\x00\xff\xee\x00\x00\xff\xf5\x00]\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe9\xe6\xff\x86v\x00\xff\x00\x97\x00\xff\x8d\x87%\xff\xc9\xa7\x91\xff\x00\xa1\x00\xff\x00~\x00\xff\x00l\x00\xff\x00j\x00\xff\x00]\x00\xff\xc8\xba\xac\xff\xee\xff\xf9\xff\xff\xff\xff\xff\xf86q\xff\xee\x00\x00\xff\xed\x00\x01\xff\xeb\x00\x00\xff\xee\x00M\xff\xff\xd7\xe7\xff\xea\x00;\xff\xe8\x00+\xff\xe8\x005\xff\xe8\x00;\xff\xe0\x00<\xfd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x00M\xfa\xee\x00X\xff\xffQ2\xff\xffu\x00\xff\xfft\x00\xff;\xa4\x00\xff\x00\x98\x00\xff\x00{\x00\xff\x00\x9a\x00\xff3\x95\x00\xff\xf3\x00(\xff\xf6\x00\x00\xff\xf5\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf3\x00b\xff\xee\x00\x00\xff\xf0\x00\x00\xff\xfa\x00\x00\xff\xff\xd2\xca\xff\xf7\xf9\xe2\xff\xe0\xfd\xe0\xff\xb2\xd1\xa4\xff\x00\x9a\x00\xff\x98{<\xff\xdc\xf1\xd7\xff\xdd\xfc\xe0\xff_\x9db\xff\x00m\x00\xff\x00g\x00\xff\x00i\x00\xff\xbfkq\xff\xd5\xf0\xde\xff\xd6\xf5\xe0\xff\xd2\xda\xca\xff\x9e$\x00\xff\xf0\x00\x00\xff\xf2\x00C\xff\xfd\x94\xb4\xff\xf4U\x81\xff\xff\xff\xff\xff\xf1a\x81\xff\xf7y\x9d\xff\xe8\x00,\xff\xe8\x006\xff\xe0\x008\xf1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x00D\xee\xee\x00W\xff\xfa3?\xff\xffv\x00\xff\xffr\x00\xff\x83\x9e\x00\xff\x00\xa1\x00\xff\x00\x8b\x00\xff\x00\xa0\x00\xff\x00\xa6\x00\xff\xbf*\x00\xff\xf9\x00\x00\xff\xf7\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd9\xdd\xff\xff\xc8\xbe\xff\xfb\xeb\xd7\xff\xe3\xfd\xe1\xff\xdd\xfd\xe1\xff\xde\xe4\xd0\xff+\x90\x00\xff\x00{\x00\xff\xa0\x84m\xff\xde\xff\xe6\xff\xde\xff\xe5\xff\xda\xf8\xe3\xff\xd6\xd5\xc9\xff\xd2\xcd\xc0\xff\xd3\xd2\xc6\xff\xd7\xeb\xe1\xff\xd7\xf0\xe2\xff\xd9\xf2\xdf\xff\x9b\x7f\\\xff\x00r\x00\xffvH\x00\xff\xf6\x00M\xff\xff\xc0\xd2\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xf7\x9f\xb5\xff\xe8\x00\'\xff\xe8\x003\xff\xe2\x005\xd9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x00=\xd4\xed\x00W\xff\xf0\x00Q\xff\xffv\x00\xff\xffs\x00\xff\xcb\x88\x00\xff\x00\xad\x00\xff\x00\xab\x00\xff\x00\xa8\x00\xff\x00\xa2\x00\xff\x00\xa0\x00\xff\xd1\x00\x00\xff\xf9\x00\x02\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xef\xfc\xff\xffv\x98\xff\xff\xf0\xe7\xff\xff\xf5\xe0\xff\xea\xfc\xe2\xff\xdd\xff\xe3\xff\xdf\xfd\xe3\xff\xd4\xd0\xc2\xff\x14\x82\x00\xff\x00\xa0\x00\xff\x00\x96\x00\xff\x00\x85\x00\xff\xb6\x9e\x7f\xff\xdc\xef\xd8\xff\xdc\xff\xe7\xff\xd8\xfe\xe6\xff\xd5\xf8\xe6\xff\xd7\xf8\xe6\xff\xd6\xf8\xe6\xff\xd3\xdb\xcf\xff\x9d\x81f\xff\x00U\x00\xff\x00^\x00\xff\x00v\x00\xff\x9c/\x00\xff\xf3\x00L\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xce\xde\xff\xe9\x00\x1c\xff\xe8\x00+\xff\xe8\x003\xff\xe2\x005\xb6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x00=\xa1\xed\x00V\xff\xee\x00W\xff\xffU\'\xff\xffu\x00\xff\xffo\x00\xff\x00\xa4\x00\xff\x00\xaa\x00\xff\x00\x8b\x00\xff\x00|\x00\xff\x00\xa0\x00\xff\x00\x9c\x00\xff\x95b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xe1\xe0\xff\xe3[\x00\xffc\x91\x00\xff\xc9wm\xff\xcd\xac\x9d\xff\xca\x91\x86\xff\xa3\x82L\xff\x00q\x00\xff\x00{\x00\xff\x00\xa5\x00\xff\x00\xa5\x00\xff\x00\xa0\x00\xffU\x8a\x00\xff\xafw\x00\xff\xf2r\x80\xff\xfd\xab\xaa\xff\xff\xb6\xb0\xff\xfc\xa4\xa1\xff\xde[g\xff\x00n\x00\xff\x00g\x00\xff\x00(\x00\xff\x003\x00\xff\x00l\x00\xff\x00q\x00\xff\xf1c\x8c\xff\xff\xca\xdd\xff\xf2\x00_\xff\xff\xff\xff\xff\xee/j\xff\xe9\x000\xff\xe8\x007\xff\xe2\x007\x89\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x00>[\xe8\x00T\xfe\xed\x00W\xff\xf3\x00M\xff\xfft\x00\xff\xffs\x00\xff\xe0\x84\x00\xff\x00\xab\x00\xff\x00\x8e\x00\xff\x00{\x00\xff\x00\x9e\x00\xff\x00\xa0\x00\xfff\x7f\x00\xff\xde\xf3\xd8\xff\xe1\xfb\xdf\xff\xde\xd7\xc3\xff\x00\x96\x00\xff\x00\x9a\x00\xff\x00\x8f\x00\xff\x00o\x00\xff\x00\x8f\x00\xff\x00\xa6\x00\xff\x00\x9f\x00\xff\x00\xa8\x00\xffY\x8d\x00\xff\xc9=\x19\xff\xea\x005\xff\xf4\x00=\xff\xf3\x008\xff\xf0\x002\xff\xf1\x00!\xff\xfa\x00\x00\xff\xffZ\x00\xff\xffc\x00\xff\xebf\x00\xff\x00m\x00\xff\x00c\x00\xff\x00e\x00\xff\x00t\x00\xff\x00v\x00\xffnG\x00\xff\xf3\x00.\xff\xee\x00,\xff\xed\x00B\xff\xea\x000\xff\xe9\x007\xff\xe9\x00;\xfd\xe0\x00;V\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x069\xe5\x00T\xf8\xed\x00V\xff\xee\x00W\xff\xfb8;\xff\xffu\x00\xff\xffq\x00\xff\xb5\x90\x00\xff\x00\xab\x00\xff\x00\xa2\x00\xff\x00\xa6\x00\xff\x00\x8b\x00\xffWL\x00\xff\xe0\xf3\xdc\xff\xe2\xfc\xe2\xff\xdd\xd7\xc8\xff\x00v\x00\xff\x00\x9d\x00\xff\x00\x98\x00\xff\x00u\x00\xff\x00\x8f\x00\xff\x00\xaa\x00\xff<\x97\x00\xff\xc4B\x1d\xff\xf8\x00E\xff\xf5\x00E\xff\xf3\x00D\xff\xf1\x00B\xff\xef\x00?\xff\xed\x00=\xff\xed\x00<\xff\xec\x00<\xff\xf4\x00!\xff\xff\\\x00\xff\xff`\x00\xff\xe2b\x00\xff\x00l\x00\xff\x00k\x00\xff\x00b\x00\xff\x00f\x00\xff\x00n\x00\xff\xe7\x003\xff\xef\x009\xff\xec\x009\xff\xeb\x00:\xff\xea\x00=\xff\xe9\x00@\xf5\xe6\x00@)\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\xb3\x00F\xe6\xee\x00U\xff\xed\x00V\xff\xee\x00V\xff\xfdB6\xff\xfft\x00\xff\xffr\x00\xff\xc2\x8b\x00\xff\x00\xaa\x00\xff\x00\xa7\x00\xff\x00\x84\x00\xffWT\x00\xff\xe1\xf5\xde\xff\xe4\xff\xe5\xff\xde\xd7\xcb\xff\x00n\x00\xff\x00\x9b\x00\xff\x00\xa5\x00\xff\x00\xa5\x00\xff\x00\xa6\x00\xff\xa4k\x00\xff\xf3\x00D\xff\xf8\x00J\xff\xf6\x00J\xff\xf3\x00J\xff\xf1\x00H\xff\xef\x00F\xff\xed\x00D\xff\xeb\x00B\xff\xea\x00A\xff\xea\x00A\xff\xea\x00B\xff\xfa\x00\x00\xff\xffX\x00\xff\xffU\x00\xff__\x00\xff\x00W\x00\xff\x00\x00\x00\xff\x007\x00\xff\x00i\x00\xff\xce\x00,\xff\xee\x00?\xff\xec\x00?\xff\xea\x00@\xff\xe9\x00A\xff\xe6\x00A\xdb\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x90\xee\x00T\xff\xed\x00U\xff\xed\x00U\xff\xef\x00V\xff\xf8\x1aD\xff\xfff\x00\xff\xffq\x00\xff\xf4{\x00\xff\x86\x96\x00\xff\x00\xa6\x00\xffh\x84\x00\xff\xe4\xf8\xe0\xff\xe6\xff\xe7\xff\xe3\xde\xce\xff\x00\x99\x00\xff\x00\xa6\x00\xff\x00\xa3\x00\xff\xa5p\x00\xff\xe8\x00>\xff\xfd\x00M\xff\xf9\x00N\xff\xf7\x00N\xff\xf5\x00M\xff\xf2\x00L\xff\xef\x00K\xff\xed\x00I\xff\xeb\x00G\xff\xe9\x00E\xff\xe8\x00D\xff\xe8\x00C\xff\xe8\x00D\xff\xef\x001\xff\xff>\x00\xff\xffb\x00\xff\xce\x81\x00\xff\x00\x8a\x00\xff\x00j\x00\xff\x00a\x00\xff\x00]\x00\xff\xbf\x00%\xff\xec\x00B\xff\xeb\x00B\xff\xe9\x00B\xff\xe7\x00D\xff\xd9\x00@n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00g\x003\x10\xcf\x00K\xf4\xed\x00T\xff\xed\x00U\xff\xee\x00U\xff\xf0\x00V\xff\xf2\x00U\xff\xff 9\xff\xffS\r\xff\xffZ\x00\xff\xfef\x00\xff\xdaa\x00\xff\xf7\xd9\xd0\xff\xf5\xe0\xd7\xff\xf5\xc3\xc3\xff\xb3j\r\xff\xd12\x1f\xff\xfc\x00G\xff\xff\x00N\xff\xfe\x00P\xff\xfc\x00Q\xff\xfa\x00Q\xff\xf7\x00P\xff\xf4\x00O\xff\xf1\x00N\xff\xee\x00L\xff\xec\x00J\xff\xe9\x00H\xff\xe8\x00F\xff\xe6\x00D\xff\xea\x00L\xff\xf3\x8eZ\xff\xff\xcbj\xff\xff\xfds\xff\xff\xff}\xff\xff\xff}\xff\xff\xff}\xff\xff\xff}\xff\xff\xff}\xff\xff\xffx\xff\xff\xe3k\xff\xfd\xb1`\xff\xf3xT\xff\xeb\x00G\xff\xe3\x00A\xe8\xe0\x00B\x0e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x87\x00:\xaa\xef\x00T\xff\xed\x00T\xff\xee\x00U\xff\xf0\x00V\xff\xf2\x00V\xff\xf5\x00U\xff\xf7\x00S\xff\xfb\x00O\xff\xff\x00H\xff\xfa\x00C\xff\xf3\x00K\xff\xd1\x0e7\xff\xc0\t3\xff\xc1\x00!\xff\xc5\x14$\xff\xd0 /\xff\xdf\x00@\xff\xf1\x00L\xff\xf4\x00O\xff\xf5\x00P\xff\xf7\x00R\xff\xf5\x00P\xff\xf2\x00N\xff\xee\x00L\xff\xeb\x00I\xff\xe8\x00G\xff\xe9\x00J\xff\xfb\xbdf\xff\xff\xfew\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffz\xff\xff\xffw\xff\xff\xf4r\xff\xf0\xb0[\xad\x81\x00\x1d\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00-\xc8\x00J\xfa\xee\x00U\xff\xef\x00U\xff\xf1\x00V\xff\xf3\x00V\xff\xf6\x00W\xff\xff\x00D\xff\xffQ!\xff\xbbg\x00\xffFr\x00\xff\x00}\x00\xff\x00\x7f\x00\xff\x00\x7f\x00\xff\x00\x80\x00\xff\x00\x81\x00\xff\x00\x82\x00\xff\x00\x83\x00\xff\x00\x84\x00\xff\x00|\x00\xff#p\x00\xff\x80\\\x16\xff\xc9\x00;\xff\xf2\x00N\xff\xee\x00K\xff\xeb\x00H\xff\xf5~[\xff\xff\xf7u\xff\xff\xffz\xff\xff\xffy\xff\xff\xffy\xff\xff\xffx\xff\xff\xfex\xff\xff\xfex\xff\xff\xfey\xff\xff\xfey\xff\xff\xffy\xff\xff\xffy\xff\xff\xfcx\xff\xfc\xe5q\xff\xf8\xd9m\xff\xf5\xd6k\xff\xf5\xd0j\xff\xd3qR5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x00/\x91\xed\x00T\xfe\xf1\x00V\xff\xf2\x00W\xff\xf9\x00N\xff\xff]\x1c\xff\xffz\x00\xffM\x82\x00\xff\x00\x84\x00\xff\x00\x82\x00\xff\x00\x80\x00\xff\x00[\x00\xff\x00[\x00\xff\x00\x80\x00\xff\x00z\x00\xff\x00Y\x00\xff\x00c\x00\xff\x00\x81\x00\xff\x00z\x00\xff\x00q\x00\xff\x00t\x00\xff\x00t\x00\xff\x00Y\x00\xff\xa4\x00!\xff\xfa\xa9c\xff\xff\xff{\xff\xff\xffz\xff\xff\xffy\xff\xff\xffx\xff\xff\xfex\xff\xff\xfdw\xff\xff\xfcw\xff\xff\xfcw\xff\xff\xfcx\xff\xff\xfcx\xff\xff\xfcx\xff\xff\xe9s\xff\xf4\xcej\xff\xf4\xcfj\xff\xf4\xd1k\xff\xf4\xd2k\xff\xeb\xabb\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\xac\x00D\xe3\xf3\x00W\xff\xfc(H\xff\xffv\x00\xff\xfa|\x00\xff\x00\x88\x00\xff\x00\x84\x00\xff\x00e\x00\xff\x00\x80\x00\xff\x00\x82\x00\xff\x00]\x00\xff\x00\\\x00\xff\x00\x81\x00\xff\x00z\x00\xff\x00P\x00\xff\x00]\x00\xff\x00~\x00\xff\x00g\x00\xff\x006\x00\xff\x00R\x00\xff\x00g\x00\xff\x00a\x00\xff\xbc\xd3R\xff\xff\xff{\xff\xff\xffz\xff\xff\xffy\xff\xff\xfex\xff\xff\xfcw\xff\xff\xf4q\xff\xf8\xdaZ\xff\xff\xf7u\xff\xff\xfaw\xff\xff\xfbw\xff\xff\xfaw\xff\xf9\xdcn\xff\xf2\xc8f\xff\xf3\xcbh\xff\xf3\xcdj\xff\xf3\xcfj\xff\xf0\xc1h\xeb\x9c\x00=!\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x16;\xe5\'@\xf4\xffw\x00\xff\xff|\x00\xff#\x86\x00\xff\x00\x88\x00\xff\x00m\x00\xff\x00T\x00\xff\x00l\x00\xff\x00\x85\x00\xff\x00\x81\x00\xff\x00\x80\x00\xff\x00\x84\x00\xff\x00\x81\x00\xff\x00{\x00\xff\x00z\x00\xff\x00z\x00\xff\x00i\x00\xff\x00D\x00\xff\x00X\x00\xff\x00\\\x00\xff\xb9\xc7S\xff\xff\xff{\xff\xff\xffz\xff\xff\xffy\xff\xff\xfdx\xff\xff\xfbw\xff\xff\xfaw\xff\xf5\xd5V\xff\xe8\xaa\'\xff\xfe\xeck\xff\xff\xfaw\xff\xff\xf8u\xff\xf7\xd7m\xff\xf0\xc3a\xff\xed\xb51\xff\xf1\xbfM\xff\xf3\xcdj\xff\xf3\xc6i\xf9\xe5~Z?\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x9e$\x1d\x86\xffp\x00\xff\x88\x85\x00\xff\x00\x88\x00\xff\x00\x88\x00\xff\x00\x86\x00\xff\x00r\x00\xff\x00\x85\x00\xffDw\x00\xff\xaeg\x1d\xff\xcfe\x10\xff\xcec\x0b\xff\xcag\x00\xff\xc4k\x00\xff\xb9q\x00\xff\x9co\x00\xffch\x00\xff\x00b\x00\xff\x00Y\x00\xff\xa7\xc4I\xff\xff\xff{\xff\xff\xff{\xff\xff\xfey\xff\xff\xfcx\xff\xff\xf8t\xff\xfd\xeai\xff\xff\xf8u\xff\xff\xf6s\xff\xfb\xe5f\xff\xff\xf8u\xff\xff\xf9u\xff\xf6\xd8m\xff\xf0\xc7i\xff\xf1\xc7g\xff\xef\xbeK\xff\xf1\xc7^\xff\xf3\xc9j\xff\xd7\x8cX\x87\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04|"\x1d\xa2\x00\x81\x00\xfe\x00o\x00\xff\x00p\x00\xff\x00\x86\x00\xff\x00\x88\x00\xff\x8ec&\xff\xf7\x00S\xff\xfb\x00T\xff\xfa\x00S\xff\xfa\x00S\xff\xf9\x00Q\xff\xf8\x00P\xff\xfc\x00B\xff\xff\x1c\x00\xff\xffE\x00\xff\xffA\x00\xff\xe2\xc1M\xff\xff\xff{\xff\xff\xff{\xff\xff\xfey\xff\xff\xfbx\xff\xff\xfaw\xff\xf9\xdc]\xff\xea\xac)\xff\xfb\xe2d\xff\xff\xf9v\xff\xff\xf9v\xff\xff\xf8v\xff\xf7\xd9l\xff\xf0\xc7h\xff\xf1\xc8i\xff\xf1\xcai\xff\xf2\xcbj\xff\xf2\xc9j\xfd\xc9}S\xa3:\x00\x0b\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0c4\'\x1e\xa8\x00T\x00\xff\x00^\x00\xff\x00\x85\x00\xff\x85g!\xff\xfa\x00U\xff\xfa\x00U\xff\xf7\x00T\xff\xf5\x00S\xff\xf4\x00R\xff\xf2\x00Q\xff\xf1\x00P\xff\xf0\x00O\xff\xef\x00O\xff\xf2\x00B\xff\xff\xc1W\xff\xff\xff{\xff\xff\xff{\xff\xff\xfdy\xff\xff\xfbx\xff\xff\xfaw\xff\xff\xf9v\xff\xff\xf1p\xff\xf8\xd9[\xff\xff\xf4r\xff\xff\xf9v\xff\xff\xf8v\xff\xf7\xd9n\xff\xf0\xc6h\xff\xf1\xc8h\xff\xf1\xc9i\xff\xf2\xcbi\xff\xf2\xc7j\xff\xc7|S\xa3(\x00\x00\x0b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04K$\x1f\x8d\x00m\x00\xfd\x00\x85\x00\xff\xe6\x00L\xff\xfa\x00U\xff\xf7\x00S\xff\xf4\x00R\xff\xf2\x00P\xff\xf0\x00O\xff\xee\x00N\xff\xed\x00M\xff\xec\x00K\xff\xf1\x00P\xff\xff\xcck\xff\xff\xff|\xff\xff\xffz\xff\xff\xfey\xff\xff\xfbx\xff\xff\xfaw\xff\xff\xf9v\xff\xff\xf8v\xff\xff\xf8v\xff\xff\xf8v\xff\xff\xf9v\xff\xff\xf7u\xff\xf7\xd9l\xff\xf0\xc6h\xff\xf0\xc8h\xff\xf1\xc9i\xff\xf1\xcai\xff\xf0\xc3h\xf9\xd5\x89W\x88(\x00\x08\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x009\x00Jn`\x14\xeb\xfa\x00U\xff\xf7\x00S\xff\xf4\x00Q\xff\xf1\x00P\xff\xef\x00N\xff\xed\x00M\xff\xed\x00M\xff\xed\x00M\xff\xfd\xa7a\xff\xff\xfex\xff\xff\xff{\xff\xff\xffz\xff\xff\xfey\xff\xff\xfcx\xff\xff\xfaw\xff\xff\xf9v\xff\xff\xf8v\xff\xff\xf8v\xff\xff\xf8v\xff\xff\xf9v\xff\xff\xf2u\xff\xf3\xcek\xff\xf0\xc6h\xff\xf0\xc8h\xff\xf1\xc9h\xff\xf1\xc9i\xff\xec\xbbe\xed\xcd\x1bKG\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00BA\x1d#\xb1tH\xa5\xea\x8c[\xff\xfb\xb8e\xff\xfa\xac\\\xff\xfb\xbcc\xff\xff\xdcn\xff\xff\xear\xff\xff\xffx\xff\xff\xff{\xff\xff\xffz\xff\xff\xffz\xff\xff\xffy\xff\xff\xfdx\xff\xff\xfbw\xff\xff\xfav\xff\xff\xf9v\xff\xff\xf9v\xff\xff\xf9v\xff\xff\xf5t\xff\xf8\xddm\xff\xf1\xc8g\xff\xf0\xc6h\xff\xf1\xc8h\xff\xf1\xc9h\xff\xf1\xc3g\xff\xce\x7fU\xa5c\x00)!\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x007W4;\xc7gQ\xb7\xe8\xc4h\xfd\xfb\xe3p\xff\xf9\xe4q\xff\xff\xf1t\xff\xff\xfaw\xff\xff\xfex\xff\xff\xffx\xff\xff\xffy\xff\xff\xfex\xff\xff\xfcw\xff\xff\xfbw\xff\xff\xf7u\xff\xff\xf2u\xff\xfd\xebr\xff\xf7\xdbm\xff\xf1\xc6i\xff\xf0\xc6h\xff\xf0\xc7h\xff\xf2\xcah\xff\xeb\xbad\xfc\xe5\xac_\xb6\x99\x004;\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00?#\x04\xc4cQ\x14ya>\xb0\xee\xcej\xeb\xee\xd2j\xfb\xf2\xd0k\xff\xf5\xd4k\xff\xf4\xd2l\xff\xf4\xd1k\xff\xf3\xd0j\xff\xf2\xcej\xff\xf2\xcbi\xff\xf2\xcai\xff\xf1\xc8g\xff\xf0\xc5g\xff\xf0\xc6g\xff\xf0\xc5h\xff\xec\xc0e\xfb\xed\xb9e\xeb\xa8\x00B\xb0\xe9\x9fa\x14Y\x00"\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\tL\x00+F\xbbhMc\xab\x8dM\xba\xb5yN\xec\xdd\x8cZ\xfa\xf0\xbfg\xfe\xf1\xc5h\xff\xf1\xc4h\xff\xef\xbcf\xfe\xf0\xaec\xf6\xc6hO\xec\xb2~L\xbb\xe0\xa8_b\x8c\x003F\x00\x00\x00\t\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'
    p5_img = pygame.image.fromstring(p5_imgstring, (64,64), 'RGBA')
    pygame.display.set_icon(p5_img)
    CAIRO_SURFACE = cairo.ImageSurface(cairo.FORMAT_ARGB32, w, h) # create pycairo surface
    
    pass   

# ---- SETTING ----
    
def background(*args): # clear and set background color    
    clear_background(CAIRO_SURFACE, builtins.width, builtins.height, set_colors(*args))
    
def strokeWeight(weight):
    settings["stroke_weight"] = weight
    settings["no_stroke"]     = False
    stroke_color = settings["stroke_color"]
    stroke_color[3] = 255
    settings["stroke_color"]  = stroke_color
    settings["text_outline"]  = stroke_color
    pass

def noStroke():
    settings["no_stroke"] = True
    stroke_color = settings["stroke_color"]
    stroke_color[3] = 0
    settings["stroke_color"] = stroke_color
    settings["text_outline"] = stroke_color
    pass

def ellipseMode(mode):
    if mode in [CENTER,RADIUS,CORNER,CORNERS]:
        builtins.ellipse_mode = mode
    else:
        raise ValueError("ellipseMode() was expecting CENTER|RADIUS|CORNER|CORNERS")
 
def rectMode(mode):
    if mode in [CENTER,RADIUS,CORNER,CORNERS]:
        builtins.rect_mode = mode
    else:
        raise ValueError("rectMode() was expecting CENTER|RADIUS|CORNER|CORNERS")
 
# ---- ENVIRONMENT ----

def cursor(type):
    pygame.mouse.set_cursor(*type)
    pass

def noCursor():
    pygame.mouse.set_cursor((8,8),(0,0),(0,0,0,0,0,0,0,0),(0,0,0,0,0,0,0,0))
    pass

def isLooping():
    return builtins.is_Looping
 
def frameRate(f):
    builtins.framerate = f

def loop():    
    builtins.is_Looping = True

def noLoop():    
    builtins.is_Looping = False

def angleMode(amode):
    if amode not in [DEGREES,RADIANS]:
        raise ValueError("AngleMode must be radians/degrees")
    builtins.ANGLEMODE = amode
    pass    

def keyIsDown(key):
     return (builtins.key == key)     
    
def eventsManager(events):     #events manager 

    def _keyPressed(ekey):
        builtins.keyCode = ekey
        builtins.key=pygame.key.name(ekey)
        builtins.key_pressed_method()
    pass
    
    def _keyReleased(ekey):
        builtins.keyCode = ekey
        builtins.key=pygame.key.name(ekey)       
        builtins.key_released_method()
    pass  

    def _mousePressed():       
        builtins.mouse_clicked_method()
        builtins.mouse_pressed_method()
    pass  
    # main eventsManager  
    builtins.pmouseX = builtins.mouseX
    builtins.pmouseY = builtins.mouseY
    builtins.mouseX, builtins.mouseY = pygame.mouse.get_pos()
    builtins.movedX = builtins.mouseX - builtins.pmouseX
    builtins.movedY = builtins.mouseY - builtins.pmouseY
        
    if (builtins.movedX != 0) or (builtins.movedY != 0) :
        if builtins.mouseIsPressed :
            builtins.mouse_dragged_method()
        else:
            builtins.mouse_moved_method() 
    
    for event in events:
        if event.type == pygame.QUIT:
            doLoop = False
            pygame.quit()
            sys.exit()
        elif event.type == pygame.KEYDOWN:
            _keyPressed(event.key)
        elif event.type == pygame.KEYUP:
            _keyPressed(event.key)
            _keyReleased(event.key)    
        elif event.type == pygame.MOUSEBUTTONUP:
            builtins.mouseIsPressed = False
            builtins.mouse_released_method()
        elif event.type == pygame.MOUSEBUTTONDOWN:            
            builtins.mouseIsPressed = True
            mouse_button = pygame.mouse.get_pressed()
            builtins.mouseButton = None
            if mouse_button[0] :
                builtins.mouseButton = "left"
            elif mouse_button[1] :
                builtins.mouseButton = "center"
            elif mouse_button[2] :
                builtins.mouseButton = "right" 
            _mousePressed()
        elif event.type == pygame.MOUSEMOTION:
            if (not builtins.mouseIsPressed):
                pass 
    
    pass # end of eventsManager   

def _setup():
    global clock         
    pygame.init()
    builtins.MILLIS = milli_sec()
    builtins.setup_method()
    clock = pygame.time.Clock()   
    
def _draw():        
    global clock 
    doLoop = True
    builtins.frameCount = 0
    
    while True:
        while (builtins.is_Looping or doLoop):                                      
            
            eventsManager(pygame.event.get())                                    
            builtins.frameCount += 1
            
            transform_canvas_reset()
            builtins.draw_method()

            # Create PyGame surface from Cairo Surface
            buf = CAIRO_SURFACE.get_data()
            image = pygame.image.frombuffer(buf, (builtins.width, builtins.height), "RGBA")
            # Tranfer to Screen
            pg_Screen.blit(image, (0, 0))
            pygame.display.flip()
                    
            doLoop = False
            clock.tick(builtins.framerate)
# ---- END ----
