# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class BrowseNodeAncestor(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ancestor': 'BrowseNodeAncestor',
        'context_free_name': 'str',
        'display_name': 'str',
        'id': 'str'
    }

    attribute_map = {
        'ancestor': 'Ancestor',
        'context_free_name': 'ContextFreeName',
        'display_name': 'DisplayName',
        'id': 'Id'
    }

    def __init__(self, ancestor=None, context_free_name=None, display_name=None, id=None):  # noqa: E501
        """BrowseNodeAncestor - a model defined in Swagger"""  # noqa: E501

        self._ancestor = None
        self._context_free_name = None
        self._display_name = None
        self._id = None
        self.discriminator = None

        if ancestor is not None:
            self.ancestor = ancestor
        if context_free_name is not None:
            self.context_free_name = context_free_name
        if display_name is not None:
            self.display_name = display_name
        if id is not None:
            self.id = id

    @property
    def ancestor(self):
        """Gets the ancestor of this BrowseNodeAncestor.  # noqa: E501


        :return: The ancestor of this BrowseNodeAncestor.  # noqa: E501
        :rtype: BrowseNodeAncestor
        """
        return self._ancestor

    @ancestor.setter
    def ancestor(self, ancestor):
        """Sets the ancestor of this BrowseNodeAncestor.


        :param ancestor: The ancestor of this BrowseNodeAncestor.  # noqa: E501
        :type: BrowseNodeAncestor
        """

        self._ancestor = ancestor

    @property
    def context_free_name(self):
        """Gets the context_free_name of this BrowseNodeAncestor.  # noqa: E501


        :return: The context_free_name of this BrowseNodeAncestor.  # noqa: E501
        :rtype: str
        """
        return self._context_free_name

    @context_free_name.setter
    def context_free_name(self, context_free_name):
        """Sets the context_free_name of this BrowseNodeAncestor.


        :param context_free_name: The context_free_name of this BrowseNodeAncestor.  # noqa: E501
        :type: str
        """

        self._context_free_name = context_free_name

    @property
    def display_name(self):
        """Gets the display_name of this BrowseNodeAncestor.  # noqa: E501


        :return: The display_name of this BrowseNodeAncestor.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this BrowseNodeAncestor.


        :param display_name: The display_name of this BrowseNodeAncestor.  # noqa: E501
        :type: str
        """

        self._display_name = display_name

    @property
    def id(self):
        """Gets the id of this BrowseNodeAncestor.  # noqa: E501


        :return: The id of this BrowseNodeAncestor.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BrowseNodeAncestor.


        :param id: The id of this BrowseNodeAncestor.  # noqa: E501
        :type: str
        """

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BrowseNodeAncestor, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BrowseNodeAncestor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
