# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from paapi5_python_sdk.models.multi_valued_attribute import MultiValuedAttribute  # noqa: F401,E501


class ExternalIds(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ea_ns': 'MultiValuedAttribute',
        'isb_ns': 'MultiValuedAttribute',
        'up_cs': 'MultiValuedAttribute'
    }

    attribute_map = {
        'ea_ns': 'EANs',
        'isb_ns': 'ISBNs',
        'up_cs': 'UPCs'
    }

    def __init__(self, ea_ns=None, isb_ns=None, up_cs=None):  # noqa: E501
        """ExternalIds - a model defined in Swagger"""  # noqa: E501

        self._ea_ns = None
        self._isb_ns = None
        self._up_cs = None
        self.discriminator = None

        if ea_ns is not None:
            self.ea_ns = ea_ns
        if isb_ns is not None:
            self.isb_ns = isb_ns
        if up_cs is not None:
            self.up_cs = up_cs

    @property
    def ea_ns(self):
        """Gets the ea_ns of this ExternalIds.  # noqa: E501


        :return: The ea_ns of this ExternalIds.  # noqa: E501
        :rtype: MultiValuedAttribute
        """
        return self._ea_ns

    @ea_ns.setter
    def ea_ns(self, ea_ns):
        """Sets the ea_ns of this ExternalIds.


        :param ea_ns: The ea_ns of this ExternalIds.  # noqa: E501
        :type: MultiValuedAttribute
        """

        self._ea_ns = ea_ns

    @property
    def isb_ns(self):
        """Gets the isb_ns of this ExternalIds.  # noqa: E501


        :return: The isb_ns of this ExternalIds.  # noqa: E501
        :rtype: MultiValuedAttribute
        """
        return self._isb_ns

    @isb_ns.setter
    def isb_ns(self, isb_ns):
        """Sets the isb_ns of this ExternalIds.


        :param isb_ns: The isb_ns of this ExternalIds.  # noqa: E501
        :type: MultiValuedAttribute
        """

        self._isb_ns = isb_ns

    @property
    def up_cs(self):
        """Gets the up_cs of this ExternalIds.  # noqa: E501


        :return: The up_cs of this ExternalIds.  # noqa: E501
        :rtype: MultiValuedAttribute
        """
        return self._up_cs

    @up_cs.setter
    def up_cs(self, up_cs):
        """Sets the up_cs of this ExternalIds.


        :param up_cs: The up_cs of this ExternalIds.  # noqa: E501
        :type: MultiValuedAttribute
        """

        self._up_cs = up_cs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ExternalIds, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExternalIds):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
