# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from paapi5_python_sdk.models.deal_details import DealDetails  # noqa: F401,E501
from paapi5_python_sdk.models.offer_availability_v2 import OfferAvailabilityV2  # noqa: F401,E501
from paapi5_python_sdk.models.offer_condition_v2 import OfferConditionV2  # noqa: F401,E501
from paapi5_python_sdk.models.offer_loyalty_points_v2 import OfferLoyaltyPointsV2  # noqa: F401,E501
from paapi5_python_sdk.models.offer_merchant_info_v2 import OfferMerchantInfoV2  # noqa: F401,E501
from paapi5_python_sdk.models.offer_price_v2 import OfferPriceV2  # noqa: F401,E501
from paapi5_python_sdk.models.offer_type import OfferType  # noqa: F401,E501


class OfferListingV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'availability': 'OfferAvailabilityV2',
        'condition': 'OfferConditionV2',
        'deal_details': 'DealDetails',
        'is_buy_box_winner': 'bool',
        'loyalty_points': 'OfferLoyaltyPointsV2',
        'merchant_info': 'OfferMerchantInfoV2',
        'price': 'OfferPriceV2',
        'type': 'OfferType',
        'violates_map': 'bool'
    }

    attribute_map = {
        'availability': 'Availability',
        'condition': 'Condition',
        'deal_details': 'DealDetails',
        'is_buy_box_winner': 'IsBuyBoxWinner',
        'loyalty_points': 'LoyaltyPoints',
        'merchant_info': 'MerchantInfo',
        'price': 'Price',
        'type': 'Type',
        'violates_map': 'ViolatesMAP'
    }

    def __init__(self, availability=None, condition=None, deal_details=None, is_buy_box_winner=None, loyalty_points=None, merchant_info=None, price=None, type=None, violates_map=None):  # noqa: E501
        """OfferListingV2 - a model defined in Swagger"""  # noqa: E501

        self._availability = None
        self._condition = None
        self._deal_details = None
        self._is_buy_box_winner = None
        self._loyalty_points = None
        self._merchant_info = None
        self._price = None
        self._type = None
        self._violates_map = None
        self.discriminator = None

        if availability is not None:
            self.availability = availability
        if condition is not None:
            self.condition = condition
        if deal_details is not None:
            self.deal_details = deal_details
        if is_buy_box_winner is not None:
            self.is_buy_box_winner = is_buy_box_winner
        if loyalty_points is not None:
            self.loyalty_points = loyalty_points
        if merchant_info is not None:
            self.merchant_info = merchant_info
        if price is not None:
            self.price = price
        if type is not None:
            self.type = type
        if violates_map is not None:
            self.violates_map = violates_map

    @property
    def availability(self):
        """Gets the availability of this OfferListingV2.  # noqa: E501


        :return: The availability of this OfferListingV2.  # noqa: E501
        :rtype: OfferAvailabilityV2
        """
        return self._availability

    @availability.setter
    def availability(self, availability):
        """Sets the availability of this OfferListingV2.


        :param availability: The availability of this OfferListingV2.  # noqa: E501
        :type: OfferAvailabilityV2
        """

        self._availability = availability

    @property
    def condition(self):
        """Gets the condition of this OfferListingV2.  # noqa: E501


        :return: The condition of this OfferListingV2.  # noqa: E501
        :rtype: OfferConditionV2
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this OfferListingV2.


        :param condition: The condition of this OfferListingV2.  # noqa: E501
        :type: OfferConditionV2
        """

        self._condition = condition

    @property
    def deal_details(self):
        """Gets the deal_details of this OfferListingV2.  # noqa: E501


        :return: The deal_details of this OfferListingV2.  # noqa: E501
        :rtype: DealDetails
        """
        return self._deal_details

    @deal_details.setter
    def deal_details(self, deal_details):
        """Sets the deal_details of this OfferListingV2.


        :param deal_details: The deal_details of this OfferListingV2.  # noqa: E501
        :type: DealDetails
        """

        self._deal_details = deal_details

    @property
    def is_buy_box_winner(self):
        """Gets the is_buy_box_winner of this OfferListingV2.  # noqa: E501


        :return: The is_buy_box_winner of this OfferListingV2.  # noqa: E501
        :rtype: bool
        """
        return self._is_buy_box_winner

    @is_buy_box_winner.setter
    def is_buy_box_winner(self, is_buy_box_winner):
        """Sets the is_buy_box_winner of this OfferListingV2.


        :param is_buy_box_winner: The is_buy_box_winner of this OfferListingV2.  # noqa: E501
        :type: bool
        """

        self._is_buy_box_winner = is_buy_box_winner

    @property
    def loyalty_points(self):
        """Gets the loyalty_points of this OfferListingV2.  # noqa: E501


        :return: The loyalty_points of this OfferListingV2.  # noqa: E501
        :rtype: OfferLoyaltyPointsV2
        """
        return self._loyalty_points

    @loyalty_points.setter
    def loyalty_points(self, loyalty_points):
        """Sets the loyalty_points of this OfferListingV2.


        :param loyalty_points: The loyalty_points of this OfferListingV2.  # noqa: E501
        :type: OfferLoyaltyPointsV2
        """

        self._loyalty_points = loyalty_points

    @property
    def merchant_info(self):
        """Gets the merchant_info of this OfferListingV2.  # noqa: E501


        :return: The merchant_info of this OfferListingV2.  # noqa: E501
        :rtype: OfferMerchantInfoV2
        """
        return self._merchant_info

    @merchant_info.setter
    def merchant_info(self, merchant_info):
        """Sets the merchant_info of this OfferListingV2.


        :param merchant_info: The merchant_info of this OfferListingV2.  # noqa: E501
        :type: OfferMerchantInfoV2
        """

        self._merchant_info = merchant_info

    @property
    def price(self):
        """Gets the price of this OfferListingV2.  # noqa: E501


        :return: The price of this OfferListingV2.  # noqa: E501
        :rtype: OfferPriceV2
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OfferListingV2.


        :param price: The price of this OfferListingV2.  # noqa: E501
        :type: OfferPriceV2
        """

        self._price = price

    @property
    def type(self):
        """Gets the type of this OfferListingV2.  # noqa: E501


        :return: The type of this OfferListingV2.  # noqa: E501
        :rtype: OfferType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OfferListingV2.


        :param type: The type of this OfferListingV2.  # noqa: E501
        :type: OfferType
        """

        self._type = type

    @property
    def violates_map(self):
        """Gets the violates_map of this OfferListingV2.  # noqa: E501


        :return: The violates_map of this OfferListingV2.  # noqa: E501
        :rtype: bool
        """
        return self._violates_map

    @violates_map.setter
    def violates_map(self, violates_map):
        """Sets the violates_map of this OfferListingV2.


        :param violates_map: The violates_map of this OfferListingV2.  # noqa: E501
        :type: bool
        """

        self._violates_map = violates_map

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferListingV2, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferListingV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
