# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from paapi5_python_sdk.models.money import Money  # noqa: F401,E501


class OfferSavingsV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'money': 'Money',
        'percentage': 'int'
    }

    attribute_map = {
        'money': 'Money',
        'percentage': 'Percentage'
    }

    def __init__(self, money=None, percentage=None):  # noqa: E501
        """OfferSavingsV2 - a model defined in Swagger"""  # noqa: E501

        self._money = None
        self._percentage = None
        self.discriminator = None

        if money is not None:
            self.money = money
        if percentage is not None:
            self.percentage = percentage

    @property
    def money(self):
        """Gets the money of this OfferSavingsV2.  # noqa: E501


        :return: The money of this OfferSavingsV2.  # noqa: E501
        :rtype: Money
        """
        return self._money

    @money.setter
    def money(self, money):
        """Sets the money of this OfferSavingsV2.


        :param money: The money of this OfferSavingsV2.  # noqa: E501
        :type: Money
        """

        self._money = money

    @property
    def percentage(self):
        """Gets the percentage of this OfferSavingsV2.  # noqa: E501


        :return: The percentage of this OfferSavingsV2.  # noqa: E501
        :rtype: int
        """
        return self._percentage

    @percentage.setter
    def percentage(self, percentage):
        """Sets the percentage of this OfferSavingsV2.


        :param percentage: The percentage of this OfferSavingsV2.  # noqa: E501
        :type: int
        """

        self._percentage = percentage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferSavingsV2, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferSavingsV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
