# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from paapi5_python_sdk.models.availability import Availability  # noqa: F401,E501
from paapi5_python_sdk.models.condition import Condition  # noqa: F401,E501
from paapi5_python_sdk.models.delivery_flag import DeliveryFlag  # noqa: F401,E501
from paapi5_python_sdk.models.max_price import MaxPrice  # noqa: F401,E501
from paapi5_python_sdk.models.merchant import Merchant  # noqa: F401,E501
from paapi5_python_sdk.models.min_price import MinPrice  # noqa: F401,E501
from paapi5_python_sdk.models.min_reviews_rating import MinReviewsRating  # noqa: F401,E501
from paapi5_python_sdk.models.min_saving_percent import MinSavingPercent  # noqa: F401,E501
from paapi5_python_sdk.models.offer_count import OfferCount  # noqa: F401,E501
from paapi5_python_sdk.models.partner_type import PartnerType  # noqa: F401,E501
from paapi5_python_sdk.models.properties import Properties  # noqa: F401,E501
from paapi5_python_sdk.models.search_items_resource import SearchItemsResource  # noqa: F401,E501
from paapi5_python_sdk.models.sort_by import SortBy  # noqa: F401,E501


class SearchItemsRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'actor': 'str',
        'artist': 'str',
        'author': 'str',
        'availability': 'Availability',
        'brand': 'str',
        'browse_node_id': 'str',
        'condition': 'Condition',
        'currency_of_preference': 'str',
        'delivery_flags': 'list[DeliveryFlag]',
        'item_count': 'int',
        'item_page': 'int',
        'keywords': 'str',
        'languages_of_preference': 'list[str]',
        'marketplace': 'str',
        'max_price': 'MaxPrice',
        'merchant': 'Merchant',
        'min_price': 'MinPrice',
        'min_reviews_rating': 'MinReviewsRating',
        'min_saving_percent': 'MinSavingPercent',
        'offer_count': 'OfferCount',
        'partner_tag': 'str',
        'partner_type': 'PartnerType',
        'properties': 'Properties',
        'resources': 'list[SearchItemsResource]',
        'search_index': 'str',
        'sort_by': 'SortBy',
        'title': 'str'
    }

    attribute_map = {
        'actor': 'Actor',
        'artist': 'Artist',
        'author': 'Author',
        'availability': 'Availability',
        'brand': 'Brand',
        'browse_node_id': 'BrowseNodeId',
        'condition': 'Condition',
        'currency_of_preference': 'CurrencyOfPreference',
        'delivery_flags': 'DeliveryFlags',
        'item_count': 'ItemCount',
        'item_page': 'ItemPage',
        'keywords': 'Keywords',
        'languages_of_preference': 'LanguagesOfPreference',
        'marketplace': 'Marketplace',
        'max_price': 'MaxPrice',
        'merchant': 'Merchant',
        'min_price': 'MinPrice',
        'min_reviews_rating': 'MinReviewsRating',
        'min_saving_percent': 'MinSavingPercent',
        'offer_count': 'OfferCount',
        'partner_tag': 'PartnerTag',
        'partner_type': 'PartnerType',
        'properties': 'Properties',
        'resources': 'Resources',
        'search_index': 'SearchIndex',
        'sort_by': 'SortBy',
        'title': 'Title'
    }

    def __init__(self, actor=None, artist=None, author=None, availability=None, brand=None, browse_node_id=None, condition=None, currency_of_preference=None, delivery_flags=None, item_count=None, item_page=None, keywords=None, languages_of_preference=None, marketplace=None, max_price=None, merchant=None, min_price=None, min_reviews_rating=None, min_saving_percent=None, offer_count=None, partner_tag=None, partner_type=None, properties=None, resources=None, search_index=None, sort_by=None, title=None):  # noqa: E501
        """SearchItemsRequest - a model defined in Swagger"""  # noqa: E501

        self._actor = None
        self._artist = None
        self._author = None
        self._availability = None
        self._brand = None
        self._browse_node_id = None
        self._condition = None
        self._currency_of_preference = None
        self._delivery_flags = None
        self._item_count = None
        self._item_page = None
        self._keywords = None
        self._languages_of_preference = None
        self._marketplace = None
        self._max_price = None
        self._merchant = None
        self._min_price = None
        self._min_reviews_rating = None
        self._min_saving_percent = None
        self._offer_count = None
        self._partner_tag = None
        self._partner_type = None
        self._properties = None
        self._resources = None
        self._search_index = None
        self._sort_by = None
        self._title = None
        self.discriminator = None

        if actor is not None:
            self.actor = actor
        if artist is not None:
            self.artist = artist
        if author is not None:
            self.author = author
        if availability is not None:
            self.availability = availability
        if brand is not None:
            self.brand = brand
        if browse_node_id is not None:
            self.browse_node_id = browse_node_id
        if condition is not None:
            self.condition = condition
        if currency_of_preference is not None:
            self.currency_of_preference = currency_of_preference
        if delivery_flags is not None:
            self.delivery_flags = delivery_flags
        if item_count is not None:
            self.item_count = item_count
        if item_page is not None:
            self.item_page = item_page
        if keywords is not None:
            self.keywords = keywords
        if languages_of_preference is not None:
            self.languages_of_preference = languages_of_preference
        if marketplace is not None:
            self.marketplace = marketplace
        if max_price is not None:
            self.max_price = max_price
        if merchant is not None:
            self.merchant = merchant
        if min_price is not None:
            self.min_price = min_price
        if min_reviews_rating is not None:
            self.min_reviews_rating = min_reviews_rating
        if min_saving_percent is not None:
            self.min_saving_percent = min_saving_percent
        if offer_count is not None:
            self.offer_count = offer_count
        self.partner_tag = partner_tag
        self.partner_type = partner_type
        if properties is not None:
            self.properties = properties
        if resources is not None:
            self.resources = resources
        if search_index is not None:
            self.search_index = search_index
        if sort_by is not None:
            self.sort_by = sort_by
        if title is not None:
            self.title = title

    @property
    def actor(self):
        """Gets the actor of this SearchItemsRequest.  # noqa: E501


        :return: The actor of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._actor

    @actor.setter
    def actor(self, actor):
        """Sets the actor of this SearchItemsRequest.


        :param actor: The actor of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._actor = actor

    @property
    def artist(self):
        """Gets the artist of this SearchItemsRequest.  # noqa: E501


        :return: The artist of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._artist

    @artist.setter
    def artist(self, artist):
        """Sets the artist of this SearchItemsRequest.


        :param artist: The artist of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._artist = artist

    @property
    def author(self):
        """Gets the author of this SearchItemsRequest.  # noqa: E501


        :return: The author of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this SearchItemsRequest.


        :param author: The author of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def availability(self):
        """Gets the availability of this SearchItemsRequest.  # noqa: E501


        :return: The availability of this SearchItemsRequest.  # noqa: E501
        :rtype: Availability
        """
        return self._availability

    @availability.setter
    def availability(self, availability):
        """Sets the availability of this SearchItemsRequest.


        :param availability: The availability of this SearchItemsRequest.  # noqa: E501
        :type: Availability
        """

        self._availability = availability

    @property
    def brand(self):
        """Gets the brand of this SearchItemsRequest.  # noqa: E501


        :return: The brand of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this SearchItemsRequest.


        :param brand: The brand of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def browse_node_id(self):
        """Gets the browse_node_id of this SearchItemsRequest.  # noqa: E501


        :return: The browse_node_id of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._browse_node_id

    @browse_node_id.setter
    def browse_node_id(self, browse_node_id):
        """Sets the browse_node_id of this SearchItemsRequest.


        :param browse_node_id: The browse_node_id of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._browse_node_id = browse_node_id

    @property
    def condition(self):
        """Gets the condition of this SearchItemsRequest.  # noqa: E501


        :return: The condition of this SearchItemsRequest.  # noqa: E501
        :rtype: Condition
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this SearchItemsRequest.


        :param condition: The condition of this SearchItemsRequest.  # noqa: E501
        :type: Condition
        """

        self._condition = condition

    @property
    def currency_of_preference(self):
        """Gets the currency_of_preference of this SearchItemsRequest.  # noqa: E501


        :return: The currency_of_preference of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._currency_of_preference

    @currency_of_preference.setter
    def currency_of_preference(self, currency_of_preference):
        """Sets the currency_of_preference of this SearchItemsRequest.


        :param currency_of_preference: The currency_of_preference of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._currency_of_preference = currency_of_preference

    @property
    def delivery_flags(self):
        """Gets the delivery_flags of this SearchItemsRequest.  # noqa: E501


        :return: The delivery_flags of this SearchItemsRequest.  # noqa: E501
        :rtype: list[DeliveryFlag]
        """
        return self._delivery_flags

    @delivery_flags.setter
    def delivery_flags(self, delivery_flags):
        """Sets the delivery_flags of this SearchItemsRequest.


        :param delivery_flags: The delivery_flags of this SearchItemsRequest.  # noqa: E501
        :type: list[DeliveryFlag]
        """

        self._delivery_flags = delivery_flags

    @property
    def item_count(self):
        """Gets the item_count of this SearchItemsRequest.  # noqa: E501


        :return: The item_count of this SearchItemsRequest.  # noqa: E501
        :rtype: int
        """
        return self._item_count

    @item_count.setter
    def item_count(self, item_count):
        """Sets the item_count of this SearchItemsRequest.


        :param item_count: The item_count of this SearchItemsRequest.  # noqa: E501
        :type: int
        """

        self._item_count = item_count

    @property
    def item_page(self):
        """Gets the item_page of this SearchItemsRequest.  # noqa: E501


        :return: The item_page of this SearchItemsRequest.  # noqa: E501
        :rtype: int
        """
        return self._item_page

    @item_page.setter
    def item_page(self, item_page):
        """Sets the item_page of this SearchItemsRequest.


        :param item_page: The item_page of this SearchItemsRequest.  # noqa: E501
        :type: int
        """

        self._item_page = item_page

    @property
    def keywords(self):
        """Gets the keywords of this SearchItemsRequest.  # noqa: E501


        :return: The keywords of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """Sets the keywords of this SearchItemsRequest.


        :param keywords: The keywords of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._keywords = keywords

    @property
    def languages_of_preference(self):
        """Gets the languages_of_preference of this SearchItemsRequest.  # noqa: E501


        :return: The languages_of_preference of this SearchItemsRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._languages_of_preference

    @languages_of_preference.setter
    def languages_of_preference(self, languages_of_preference):
        """Sets the languages_of_preference of this SearchItemsRequest.


        :param languages_of_preference: The languages_of_preference of this SearchItemsRequest.  # noqa: E501
        :type: list[str]
        """

        self._languages_of_preference = languages_of_preference

    @property
    def marketplace(self):
        """Gets the marketplace of this SearchItemsRequest.  # noqa: E501


        :return: The marketplace of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._marketplace

    @marketplace.setter
    def marketplace(self, marketplace):
        """Sets the marketplace of this SearchItemsRequest.


        :param marketplace: The marketplace of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._marketplace = marketplace

    @property
    def max_price(self):
        """Gets the max_price of this SearchItemsRequest.  # noqa: E501


        :return: The max_price of this SearchItemsRequest.  # noqa: E501
        :rtype: MaxPrice
        """
        return self._max_price

    @max_price.setter
    def max_price(self, max_price):
        """Sets the max_price of this SearchItemsRequest.


        :param max_price: The max_price of this SearchItemsRequest.  # noqa: E501
        :type: MaxPrice
        """

        self._max_price = max_price

    @property
    def merchant(self):
        """Gets the merchant of this SearchItemsRequest.  # noqa: E501


        :return: The merchant of this SearchItemsRequest.  # noqa: E501
        :rtype: Merchant
        """
        return self._merchant

    @merchant.setter
    def merchant(self, merchant):
        """Sets the merchant of this SearchItemsRequest.


        :param merchant: The merchant of this SearchItemsRequest.  # noqa: E501
        :type: Merchant
        """

        self._merchant = merchant

    @property
    def min_price(self):
        """Gets the min_price of this SearchItemsRequest.  # noqa: E501


        :return: The min_price of this SearchItemsRequest.  # noqa: E501
        :rtype: MinPrice
        """
        return self._min_price

    @min_price.setter
    def min_price(self, min_price):
        """Sets the min_price of this SearchItemsRequest.


        :param min_price: The min_price of this SearchItemsRequest.  # noqa: E501
        :type: MinPrice
        """

        self._min_price = min_price

    @property
    def min_reviews_rating(self):
        """Gets the min_reviews_rating of this SearchItemsRequest.  # noqa: E501


        :return: The min_reviews_rating of this SearchItemsRequest.  # noqa: E501
        :rtype: MinReviewsRating
        """
        return self._min_reviews_rating

    @min_reviews_rating.setter
    def min_reviews_rating(self, min_reviews_rating):
        """Sets the min_reviews_rating of this SearchItemsRequest.


        :param min_reviews_rating: The min_reviews_rating of this SearchItemsRequest.  # noqa: E501
        :type: MinReviewsRating
        """

        self._min_reviews_rating = min_reviews_rating

    @property
    def min_saving_percent(self):
        """Gets the min_saving_percent of this SearchItemsRequest.  # noqa: E501


        :return: The min_saving_percent of this SearchItemsRequest.  # noqa: E501
        :rtype: MinSavingPercent
        """
        return self._min_saving_percent

    @min_saving_percent.setter
    def min_saving_percent(self, min_saving_percent):
        """Sets the min_saving_percent of this SearchItemsRequest.


        :param min_saving_percent: The min_saving_percent of this SearchItemsRequest.  # noqa: E501
        :type: MinSavingPercent
        """

        self._min_saving_percent = min_saving_percent

    @property
    def offer_count(self):
        """Gets the offer_count of this SearchItemsRequest.  # noqa: E501


        :return: The offer_count of this SearchItemsRequest.  # noqa: E501
        :rtype: OfferCount
        """
        return self._offer_count

    @offer_count.setter
    def offer_count(self, offer_count):
        """Sets the offer_count of this SearchItemsRequest.


        :param offer_count: The offer_count of this SearchItemsRequest.  # noqa: E501
        :type: OfferCount
        """

        self._offer_count = offer_count

    @property
    def partner_tag(self):
        """Gets the partner_tag of this SearchItemsRequest.  # noqa: E501


        :return: The partner_tag of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._partner_tag

    @partner_tag.setter
    def partner_tag(self, partner_tag):
        """Sets the partner_tag of this SearchItemsRequest.


        :param partner_tag: The partner_tag of this SearchItemsRequest.  # noqa: E501
        :type: str
        """
        if partner_tag is None:
            raise ValueError("Invalid value for `partner_tag`, must not be `None`")  # noqa: E501

        self._partner_tag = partner_tag

    @property
    def partner_type(self):
        """Gets the partner_type of this SearchItemsRequest.  # noqa: E501


        :return: The partner_type of this SearchItemsRequest.  # noqa: E501
        :rtype: PartnerType
        """
        return self._partner_type

    @partner_type.setter
    def partner_type(self, partner_type):
        """Sets the partner_type of this SearchItemsRequest.


        :param partner_type: The partner_type of this SearchItemsRequest.  # noqa: E501
        :type: PartnerType
        """
        if partner_type is None:
            raise ValueError("Invalid value for `partner_type`, must not be `None`")  # noqa: E501

        self._partner_type = partner_type

    @property
    def properties(self):
        """Gets the properties of this SearchItemsRequest.  # noqa: E501


        :return: The properties of this SearchItemsRequest.  # noqa: E501
        :rtype: Properties
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this SearchItemsRequest.


        :param properties: The properties of this SearchItemsRequest.  # noqa: E501
        :type: Properties
        """

        self._properties = properties

    @property
    def resources(self):
        """Gets the resources of this SearchItemsRequest.  # noqa: E501


        :return: The resources of this SearchItemsRequest.  # noqa: E501
        :rtype: list[SearchItemsResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this SearchItemsRequest.


        :param resources: The resources of this SearchItemsRequest.  # noqa: E501
        :type: list[SearchItemsResource]
        """

        self._resources = resources

    @property
    def search_index(self):
        """Gets the search_index of this SearchItemsRequest.  # noqa: E501


        :return: The search_index of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._search_index

    @search_index.setter
    def search_index(self, search_index):
        """Sets the search_index of this SearchItemsRequest.


        :param search_index: The search_index of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._search_index = search_index

    @property
    def sort_by(self):
        """Gets the sort_by of this SearchItemsRequest.  # noqa: E501


        :return: The sort_by of this SearchItemsRequest.  # noqa: E501
        :rtype: SortBy
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """Sets the sort_by of this SearchItemsRequest.


        :param sort_by: The sort_by of this SearchItemsRequest.  # noqa: E501
        :type: SortBy
        """

        self._sort_by = sort_by

    @property
    def title(self):
        """Gets the title of this SearchItemsRequest.  # noqa: E501


        :return: The title of this SearchItemsRequest.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this SearchItemsRequest.


        :param title: The title of this SearchItemsRequest.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SearchItemsRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchItemsRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
