# coding: utf-8

"""
  Copyright 2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six

from paapi5_python_sdk.models.item import Item  # noqa: F401,E501
from paapi5_python_sdk.models.search_refinements import SearchRefinements  # noqa: F401,E501


class SearchResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'total_result_count': 'int',
        'search_url': 'str',
        'items': 'list[Item]',
        'search_refinements': 'SearchRefinements'
    }

    attribute_map = {
        'total_result_count': 'TotalResultCount',
        'search_url': 'SearchURL',
        'items': 'Items',
        'search_refinements': 'SearchRefinements'
    }

    def __init__(self, total_result_count=None, search_url=None, items=None, search_refinements=None):  # noqa: E501
        """SearchResult - a model defined in Swagger"""  # noqa: E501

        self._total_result_count = None
        self._search_url = None
        self._items = None
        self._search_refinements = None
        self.discriminator = None

        if total_result_count is not None:
            self.total_result_count = total_result_count
        if search_url is not None:
            self.search_url = search_url
        if items is not None:
            self.items = items
        if search_refinements is not None:
            self.search_refinements = search_refinements

    @property
    def total_result_count(self):
        """Gets the total_result_count of this SearchResult.  # noqa: E501


        :return: The total_result_count of this SearchResult.  # noqa: E501
        :rtype: int
        """
        return self._total_result_count

    @total_result_count.setter
    def total_result_count(self, total_result_count):
        """Sets the total_result_count of this SearchResult.


        :param total_result_count: The total_result_count of this SearchResult.  # noqa: E501
        :type: int
        """

        self._total_result_count = total_result_count

    @property
    def search_url(self):
        """Gets the search_url of this SearchResult.  # noqa: E501


        :return: The search_url of this SearchResult.  # noqa: E501
        :rtype: str
        """
        return self._search_url

    @search_url.setter
    def search_url(self, search_url):
        """Sets the search_url of this SearchResult.


        :param search_url: The search_url of this SearchResult.  # noqa: E501
        :type: str
        """

        self._search_url = search_url

    @property
    def items(self):
        """Gets the items of this SearchResult.  # noqa: E501


        :return: The items of this SearchResult.  # noqa: E501
        :rtype: list[Item]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this SearchResult.


        :param items: The items of this SearchResult.  # noqa: E501
        :type: list[Item]
        """

        self._items = items

    @property
    def search_refinements(self):
        """Gets the search_refinements of this SearchResult.  # noqa: E501


        :return: The search_refinements of this SearchResult.  # noqa: E501
        :rtype: SearchRefinements
        """
        return self._search_refinements

    @search_refinements.setter
    def search_refinements(self, search_refinements):
        """Sets the search_refinements of this SearchResult.


        :param search_refinements: The search_refinements of this SearchResult.  # noqa: E501
        :type: SearchRefinements
        """

        self._search_refinements = search_refinements

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SearchResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SearchResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
