require 'thor'

module Pact
  module ProviderVerifier
    module CLI
      ##
      # Custom Thor task allows the following:
      #
      # `script arg1 arg2` to be interpreted as `script <default_task> arg1 arg2`
      # `--option 1 --option 2` to be interpreted as `--option 1 2` (the standard Thor format for multiple value options)
      # `script --help` to display the help for the default task instead of the command list
      #
      class CustomThor < ::Thor

        no_commands do
          def self.start given_args = ARGV, config = {}
            super(massage_args(given_args))
          end

          def help *args
            if args.empty?
              super(self.class.default_task)
            else
              super
            end
          end

          def self.massage_args argv
            prepend_default_task_name(turn_muliple_tag_options_into_array(argv))
          end

          def self.prepend_default_task_name argv
            if known_first_arguments.include?(argv[0])
              argv
            else
              [default_command] + argv
            end
          end

          # other task names, help, and the help shortcuts
          def self.known_first_arguments
            @known_first_arguments ||= tasks.keys + ::Thor::HELP_MAPPINGS + ['help']
          end

          def self.turn_muliple_tag_options_into_array argv
            new_argv = []
            opt_name = nil
            argv.each_with_index do | word, i |
              if word.start_with?('-')
                if word.include?('=')
                  opt_name, opt_value = word.split('=', 2)

                  existing = new_argv.find { | a | a.first == opt_name }
                  if existing
                    existing << opt_value
                  else
                    new_argv << [opt_name, opt_value]
                  end
                else
                  opt_name = word
                  existing = new_argv.find { | a | a.first == opt_name }
                  if !existing
                    new_argv << [word]
                  end
                end
              else
                if opt_name
                  existing = new_argv.find { | a | a.first == opt_name }
                  existing << word
                  opt_name = nil
                else
                  new_argv << [word]
                end
              end
            end
            new_argv.flatten
          end
        end
      end
    end
  end
end