# Releases

Pact Python is made available through both GitHub releases and PyPI. The GitHub releases also come with a summary of changes and contributions since the last release.

The entire process is automated through the [build](https://github.com/pact-foundation/pact-python/actions/workflows/build.yml?query=branch%3Amaster) GitHub Action. A description of the process is provided [below](#build-pipeline).

## Versioning

Pact Python follows [semantic versioning](https://semver.org/). Breaking changes are indicated by a major version bump, new features by a minor version bump, and bug fixes by a patch version bump.

There are a couple of exceptions to the [semantic versioning](https://semver.org/) rules:

-   Dropping support for a Python version is not considered a breaking change and is not necessarily accompanied by a major version bump.
-   Private APIs are not considered part of the public API and are not subject to the same rules as the public API. They can be changed at any time without a major version bump. Private APIs are denoted by a leading underscore in the name. Please be aware that the distinction between public and private APIs will be made concrete from version 3 onwards, and best judgement is used in the meantime to determine what is public and what is private.
-   Deprecations are not considered breaking changes and are not necessarily accompanied by a major version bump. Their removal is considered a breaking change and is accompanied by a major version bump.

Any deviation from the the standard semantic versioning rules will be clearly documented in the release notes.

The version is stored in `pact/__version__.py`. This file is automatically generated by [`hatch-vcs`](https://pypi.org/project/hatch-vcs/) and generates a version based on the latest version tag and the number of commits since that tag. Specifically:

-   If the latest tag is `v1.2.3` and there have been no commits since then and the repository is clean, the version will be `1.2.3`.
-   Otherwise, the version will take the form of `1.2.3.dev{N}+g{hash}` (or `1.2.3.dev{N}+g{hash}.d{date}` if there's a dirty repository) where `N` is the number of commits since the latest tag, `hash` is the short hash of the latest commit.

## Build Pipeline

The build pipeline is defined in `.github/workflows/build.yml`. It is triggered on PRs targeting `master`, pushes to the `master` branch, and on every new tag. The pipeline is responsible for building the package (both as source distribution, and compiled wheels), creating the GitHub release, and uploading artifacts to PyPI.

### Build Steps

The build steps generates the source distribution and wheels. This is done using [cibuildwheel](https://cibuildwheel.readthedocs.io/) to ensure that the wheels are compatible with a wide range of Python versions and platforms.

In order to reduce the build time, the pipeline builds different sets of wheels depending on the trigger:

| Trigger      | Platforms         | Wheels    |
| ------------ | ----------------- | --------- |
| Tag          | `x86_64`, `arm64` | all       |
| `master`     | `x86_64`          | all       |
| Pull Request | `x86_64`          | `cp312-*` |

### Publish Step

The publish step uses the `pypi` GitHub environment, and is gated behind a manual approval. The publish step is responsible for the following:

-   Generating a changelog based on the conventional commits since the latest release.
-   Generating a new GitHub release with the changelog.
-   Uploading the source distribution and wheels to PyPI.
-   Creating a PR to update the `CHANGELOG.md` file with the new release notes.

While the generated changelog should be accurate, it may require some manual adjustments on the release page and in the PR.
