# ruff: noqa: PGH004
# ruff: noqa
"""
Client and server classes for gRPC services defined in the person.proto file.

This module is generated by the protobuf compiler plugin and demonstrates how to use gRPC in Python.
It is intended for pedagogical purposes, showing how to implement and interact with gRPC services.

/// note
This file is generated and should not be modified manually, except for documentation improvements.
///
"""

from __future__ import annotations

from typing import Any
import grpc

from examples.plugins.proto import person_pb2 as person__pb2

GRPC_GENERATED_VERSION = "1.73.1"
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower

    _version_not_supported = first_version_is_lower(
        GRPC_VERSION, GRPC_GENERATED_VERSION
    )
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f"The grpc package installed is at version {GRPC_VERSION},"
        + f" but the generated code in person_pb2_grpc.py depends on"
        + f" grpcio>={GRPC_GENERATED_VERSION}."
        + f" Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}"
        + f" or downgrade your generated code using grpcio-tools<={GRPC_VERSION}."
    )


class AddressBookServiceStub(object):
    """
    Stub client for the AddressBook gRPC service.

    This class provides client-side methods for interacting with the AddressBook service.
    It is typically instantiated with a gRPC channel and used to make remote procedure calls.
    """

    def __init__(self, channel: grpc.Channel) -> None:
        """
        Initializes the AddressBookServiceStub.

        Args:
            channel:
                The gRPC channel through which to make calls.
        """
        self.GetPerson = channel.unary_unary(  # type: ignore[call-arg]
            "/person.AddressBookService/GetPerson",
            request_serializer=person__pb2.GetPersonRequest.SerializeToString,
            response_deserializer=person__pb2.GetPersonResponse.FromString,
            _registered_method=True,
        )
        self.ListPeople = channel.unary_unary(  # type: ignore[call-arg]
            "/person.AddressBookService/ListPeople",
            request_serializer=person__pb2.ListPeopleRequest.SerializeToString,
            response_deserializer=person__pb2.ListPeopleResponse.FromString,
            _registered_method=True,
        )
        self.AddPerson = channel.unary_unary(  # type: ignore[call-arg]
            "/person.AddressBookService/AddPerson",
            request_serializer=person__pb2.AddPersonRequest.SerializeToString,
            response_deserializer=person__pb2.AddPersonResponse.FromString,
            _registered_method=True,
        )


class AddressBookServiceServicer(object):
    """
    Server-side implementation base for the AddressBook gRPC service.

    This class should be subclassed to provide concrete implementations of the service methods.
    Each method receives a request and a context, and should return the appropriate response.
    """

    def GetPerson(
        self,
        request: person__pb2.GetPersonRequest,
        context: grpc.ServicerContext,
    ) -> person__pb2.GetPersonResponse:
        """
        Gets a person by their unique ID.

        Args:
            request:
                The request message containing the person's ID.

            context:
                The context for the RPC call.

        Returns:
            The response containing the person's details.

        Raises:
            If the method is not implemented.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListPeople(
        self,
        request: person__pb2.ListPeopleRequest,
        context: grpc.ServicerContext,
    ) -> person__pb2.ListPeopleResponse:
        """
        Lists all people in the address book.

        Args:
            request:
                The request message (typically empty).

            context:
                The context for the RPC call.

        Returns:
            The response containing a list of people.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def AddPerson(
        self,
        request: person__pb2.AddPersonRequest,
        context: grpc.ServicerContext,
    ) -> person__pb2.AddPersonResponse:
        """
        Adds a new person to the address book.

        Args:
            request:
                The request message containing the new person's details.

            context:
                The context for the RPC call.

        Returns:
            The response confirming the addition.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_AddressBookServiceServicer_to_server(
    servicer: AddressBookServiceServicer,
    server: grpc.Server,
) -> None:
    """
    Registers the AddressBookServiceServicer with a gRPC server.

    Args:
        servicer:
            The service implementation to add to the server.

        server:
            The gRPC server to which the service will be added.
    """
    rpc_method_handlers: dict[str, Any] = {
        "GetPerson": grpc.unary_unary_rpc_method_handler(
            servicer.GetPerson,
            request_deserializer=person__pb2.GetPersonRequest.FromString,
            response_serializer=person__pb2.GetPersonResponse.SerializeToString,
        ),
        "ListPeople": grpc.unary_unary_rpc_method_handler(
            servicer.ListPeople,
            request_deserializer=person__pb2.ListPeopleRequest.FromString,
            response_serializer=person__pb2.ListPeopleResponse.SerializeToString,
        ),
        "AddPerson": grpc.unary_unary_rpc_method_handler(
            servicer.AddPerson,
            request_deserializer=person__pb2.AddPersonRequest.FromString,
            response_serializer=person__pb2.AddPersonResponse.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "person.AddressBookService",
        rpc_method_handlers,
    )
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers(  # type: ignore[attr-defined]
        "person.AddressBookService",
        rpc_method_handlers,
    )


# This class is part of an EXPERIMENTAL API.
class AddressBookService(object):
    """
    EXPERIMENTAL: Client for the AddressBook gRPC service using the experimental API.

    This class provides static methods for making calls to the AddressBook service using the experimental gRPC API.
    """

    @staticmethod
    def GetPerson(
        request: person__pb2.GetPersonRequest,
        target: str,
        options: tuple[Any, ...] = tuple(),
        channel_credentials: grpc.ChannelCredentials | None = None,
        call_credentials: grpc.CallCredentials | None = None,
        insecure: bool = False,
        compression: grpc.Compression | None = None,
        wait_for_ready: bool | None = None,
        timeout: float | None = None,
        metadata: dict[str, Any] | None = None,
    ) -> person__pb2.GetPersonResponse:
        """
        Makes an experimental unary call to GetPerson.

        Args:
            request:
                The request message containing the person's ID.

            target:
                The server address.

            options:
                Call options.

            channel_credentials:
                Channel credentials.

            call_credentials:
                Call credentials.

            insecure:
                Whether to use an insecure channel.

            compression:
                Compression option.

            wait_for_ready:
                Wait for ready option.

            timeout:
                Timeout for the call.

            metadata:
                Metadata for the call.

        Returns:
            The response containing the person's details.
        """
        return grpc.experimental.unary_unary(  # type: ignore[attr-defined]
            request,
            target,
            "/person.AddressBookService/GetPerson",
            person__pb2.GetPersonRequest.SerializeToString,
            person__pb2.GetPersonResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True,
        )

    @staticmethod
    def ListPeople(
        request: person__pb2.ListPeopleRequest,
        target: str,
        options: tuple[Any, ...] = tuple(),
        channel_credentials: grpc.ChannelCredentials | None = None,
        call_credentials: grpc.CallCredentials | None = None,
        insecure: bool = False,
        compression: grpc.Compression | None = None,
        wait_for_ready: bool | None = None,
        timeout: float | None = None,
        metadata: dict[str, Any] | None = None,
    ) -> person__pb2.ListPeopleResponse:
        """
        Makes an experimental unary call to ListPeople.

        Args:
            request:
                The request message (typically empty).

            target:
                The server address.

            options:
                Call options.

            channel_credentials:
                Channel credentials.

            call_credentials:
                Call credentials.

            insecure:
                Whether to use an insecure channel.

            compression:
                Compression option.

            wait_for_ready:
                Wait for ready option.

            timeout:
                Timeout for the call.

            metadata:
                Metadata for the call.


        Returns:
            The response containing a list of people.
        """
        return grpc.experimental.unary_unary(  # type: ignore[attr-defined]
            request,
            target,
            "/person.AddressBookService/ListPeople",
            person__pb2.ListPeopleRequest.SerializeToString,
            person__pb2.ListPeopleResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True,
        )

    @staticmethod
    def AddPerson(
        request: person__pb2.AddPersonRequest,
        target: str,
        options: tuple[Any, ...] = tuple(),
        channel_credentials: grpc.ChannelCredentials | None = None,
        call_credentials: grpc.CallCredentials | None = None,
        insecure: bool = False,
        compression: grpc.Compression | None = None,
        wait_for_ready: bool | None = None,
        timeout: float | None = None,
        metadata: dict[str, Any] | None = None,
    ) -> person__pb2.AddPersonResponse:
        """
        Makes an experimental unary call to AddPerson.

        Args:
            request:
                The request message containing the new person's details.

            target:
                The server address.

            options:
                Call options.

            channel_credentials:
                Channel credentials.

            call_credentials:
                Call credentials.

            insecure:
                Whether to use an insecure channel.

            compression:
                Compression option.

            wait_for_ready:
                Wait for ready option.

            timeout:
                Timeout for the call.

            metadata:
                Metadata for the call.


        Returns:
            The response confirming the addition.
        """
        return grpc.experimental.unary_unary(  # type: ignore[attr-defined]
            request,
            target,
            "/person.AddressBookService/AddPerson",
            person__pb2.AddPersonRequest.SerializeToString,
            person__pb2.AddPersonResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True,
        )
